/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.app.rfid;

import java.text.MessageFormat;
import java.util.Date;
import org.apache.commons.lang.builder.ToStringBuilder;

public class RFIDValue {
    private long unitID = 0L;
    private long timeStamp = 0L;
    private long rfidTag = 0L;
    private static final MessageFormat rfidTagIdpattern = new MessageFormat("{0,number,#0,000,000,000}");
    private String tagName;

    public RFIDValue(long unitID, long rfidTag, long timeStamp) {
        this.unitID = unitID;
        this.rfidTag = rfidTag;
        this.timeStamp = timeStamp;
    }

    public long getRfidTag() {
        return this.rfidTag;
    }

    public void setRfidTag(long rfidTag) {
        this.rfidTag = rfidTag;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public long getUnitID() {
        return this.unitID;
    }

    public void setUnitID(long unitID) {
        this.unitID = unitID;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String description) {
        this.tagName = description;
    }

    private String formatTagId(long rfidTagId) {
        if (this.tagName != null) {
            return this.tagName;
        }
        return rfidTagIdpattern.format(new Object[]{rfidTagId});
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        toStringBuilder.append("unitId", this.unitID);
        toStringBuilder.append("timeStamp", (Object)(this.timeStamp + " " + new Date(this.timeStamp)));
        toStringBuilder.append("TagID", (Object)this.formatTagId(this.rfidTag));
        toStringBuilder.append("Description", (Object)this.tagName);
        return toStringBuilder.toString();
    }
}

