/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.app.resource;

import de.proveo.wwt.datamodel.resourceString.ResourceString;
import de.proveo.wwt.logic.app.resource.ApplicationResourceBundle;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;

public class ResourceControl
extends ResourceBundle.Control {
    private Locale locale;
    private List<ResourceString> resources;
    private Locale defaultLocale;
    private List<ResourceString> defaultResources;

    public ResourceControl(Locale locale, List<ResourceString> resources, Locale defaultLocale, List<ResourceString> defaultResources) {
        this.locale = locale;
        this.resources = resources;
        this.defaultLocale = defaultLocale;
        this.defaultResources = defaultResources;
    }

    @Override
    public ResourceBundle newBundle(String baseName, Locale _locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        ApplicationResourceBundle defaultBundle = null;
        if (this.defaultLocale != null && this.defaultResources != null) {
            Properties defaultProperties = this.resourceStringsToProperties(this.defaultResources);
            defaultBundle = new ApplicationResourceBundle(this.defaultLocale, defaultProperties, null);
        }
        Properties properties = this.resourceStringsToProperties(this.resources);
        ApplicationResourceBundle bundle = new ApplicationResourceBundle(this.locale, properties, defaultBundle);
        return bundle;
    }

    private Properties resourceStringsToProperties(List<ResourceString> list) {
        Properties properties = new Properties();
        for (ResourceString resourceString : list) {
            properties.put(resourceString.getName(), resourceString.getResourceValue());
        }
        return properties;
    }

    @Override
    public long getTimeToLive(String baseName, Locale locale) {
        return -1L;
    }

    @Override
    public boolean needsReload(String baseName, Locale locale, String format, ClassLoader loader, ResourceBundle bundle, long loadTime) {
        return false;
    }
}

