/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.use;

import de.proveo.maven.plugins.extendedObject.annotations.Equals;
import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.wwt.datamodel.area.Area;
import de.proveo.wwt.datamodel.base.HistoryHelperBase;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.datamodel.use.UseBase;
import de.proveo.wwt.datamodel.use.UseCache;
import de.proveo.wwt.datamodel.use.UseHistoryHelper;
import de.proveo.wwt.logic.ejb.dataIn.event.history.IEndTime;
import de.proveo.wwt.logic.ejb.dataIn.event.history.IHistoryEntity;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="use_history")
@NamedQueries(value={@NamedQuery(name="findUseHistoryByUnit", query="SELECT h FROM UseHistory h WHERE h.unitId = :unitId AND h.beginTime BETWEEN :since AND :until"), @NamedQuery(name="findUseHistoryByUnitIdOrderByBegin", query="SELECT c FROM UseHistory c WHERE c.unitId = :unitId AND (c.endTime > :since OR c.endTime <= 0) AND c.beginTime < :until ORDER BY c.beginTime ASC"), @NamedQuery(name="findUseHistoryByUnitGroupIdOrderByUnitAndBegin", query="SELECT c FROM UseHistory c, IN (c.groupHistory.unitGroups) ug WHERE ug.unitId = :unitGroupId AND ((c.endTime > :since OR c.endTime <= 0) AND c.beginTime < :until) ORDER BY c.unitId ASC, c.beginTime ASC"), @NamedQuery(name="findUseHistoryAllByTimeOrderByUnitAndBegin", query="SELECT c FROM UseHistory c WHERE (c.endTime > ?1 AND c.beginTime < ?2) OR (c.endTime <= 0 AND c.beginTime < ?2) ORDER BY c.unitId ASC, c.beginTime ASC")})
public class UseHistory
extends UseBase
implements IHistoryEntity<UseHistory, UseCache>,
IEndTime {
    private static final long serialVersionUID = 1081909919835168738L;
    @Id
    @Column(name="ID")
    @GenericGenerator(name="incrementer", strategy="increment")
    @GeneratedValue(generator="incrementer")
    @Equals
    @ToString
    private long id;
    @JoinColumn(name="ID", updatable=false, insertable=false)
    @OneToMany(targetEntity=UseHistoryHelper.class, fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<UseHistoryHelper> useHistoryHelper;
    @Column(name="UNIT_ID")
    @Equals
    @ToString
    private long unitId;
    @ManyToOne(targetEntity=UnitModel.class, fetch=FetchType.LAZY)
    @JoinColumn(name="UNIT_ID", updatable=false, insertable=false)
    private UnitModel unitModel;
    @Column(name="END_TIME")
    @Equals
    @ToString
    private long endTime;
    @Column(name="END_RECEIVE_TIME")
    @Equals
    @ToString
    private long endReceiveTime;
    @Column(name="END_AREA_ID")
    @Equals
    @ToString
    private Integer endAreaId;
    @ManyToOne(targetEntity=Area.class, fetch=FetchType.EAGER)
    @JoinColumn(name="END_AREA_ID", updatable=false, insertable=false)
    private Area endArea;
    @OneToOne(targetEntity=UseCache.class, fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="history")
    @JoinColumn(name="id", referencedColumnName="history_id", insertable=false, updatable=false)
    private UseCache cache;

    public UseHistory() {
    }

    public UseHistory(UseCache useCache) {
        super(useCache);
    }

    @Override
    public Class<? extends HistoryHelperBase> getHelperClass() {
        return UseHistoryHelper.class;
    }

    @Override
    public void finishHistory(UseHistory oldHistory) {
        oldHistory.endAreaId = this.getBeginAreaId();
        oldHistory.endTime = this.getBeginTime();
        oldHistory.endReceiveTime = this.getBeginReceiveTime();
    }

    @Override
    public UseCache generateCache() {
        return new UseCache(this);
    }

    @Override
    public long getHistoryId() {
        return this.id;
    }

    @Override
    public void setHistoryId(long historyId) {
        this.id = historyId;
    }

    public Object getPrimaryKey() {
        return this.id;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public long getUnitId() {
        return this.unitId;
    }

    @Override
    public void setUnitId(long unitId) {
        this.unitId = unitId;
    }

    @Override
    public UnitModel getUnitModel() {
        return this.unitModel;
    }

    @Override
    protected void setUnitModel(UnitModel unitModel) {
        this.unitModel = unitModel;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getEndReceiveTime() {
        return this.endReceiveTime;
    }

    public void setEndReceiveTime(long endReceiveTime) {
        this.endReceiveTime = endReceiveTime;
    }

    public Integer getEndAreaId() {
        return this.endAreaId;
    }

    public void setEndAreaId(Integer endAreaId) {
        this.endAreaId = endAreaId;
    }

    public Area getEndArea() {
        return this.endArea;
    }

    public void setCache(UseCache cache) {
        this.cache = cache;
    }

    public UseCache getCache() {
        return this.cache;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UseHistory");
        stringBuilder.append(" (");
        stringBuilder.append("id = ");
        stringBuilder.append(this.id);
        stringBuilder.append(", ");
        stringBuilder.append("unitId = ");
        stringBuilder.append(this.unitId);
        stringBuilder.append(", ");
        stringBuilder.append("endTime = ");
        stringBuilder.append(this.endTime);
        stringBuilder.append(", ");
        stringBuilder.append("endReceiveTime = ");
        stringBuilder.append(this.endReceiveTime);
        stringBuilder.append(", ");
        stringBuilder.append("endAreaId = ");
        stringBuilder.append(this.endAreaId == null ? "[null]" : this.endAreaId.toString());
        stringBuilder.append(" (");
        stringBuilder.append(super.toString());
        stringBuilder.append(")");
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UseHistory useHistory = (UseHistory)object;
        if (this.id != useHistory.id) {
            return false;
        }
        if (this.unitId != useHistory.unitId) {
            return false;
        }
        if (this.endTime != useHistory.endTime) {
            return false;
        }
        if (this.endReceiveTime != useHistory.endReceiveTime) {
            return false;
        }
        return !(this.endAreaId == null ? useHistory.endAreaId != null : !this.endAreaId.equals(useHistory.endAreaId));
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = n * n2 + (int)(this.id ^ this.id >>> 32);
        n2 = n * n2 + (int)(this.unitId ^ this.unitId >>> 32);
        n2 = n * n2 + (int)(this.endTime ^ this.endTime >>> 32);
        n2 = n * n2 + (int)(this.endReceiveTime ^ this.endReceiveTime >>> 32);
        n2 = n * n2 + (this.endAreaId == null ? 0 : this.endAreaId.hashCode());
        return n2;
    }
}

