/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.use;

import de.proveo.maven.plugins.extendedObject.annotations.Equals;
import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.datamodel.use.UseBase;
import de.proveo.wwt.datamodel.use.UseHistory;
import de.proveo.wwt.logic.ejb.dataIn.event.history.ICacheEntity;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Table;

@Entity
@Table(name="use_cache")
@NamedQueries(value={@NamedQuery(name="findUseCacheAll", query="SELECT c FROM UseCache c"), @NamedQuery(name="findUseCacheByUnitId", query="SELECT c FROM UseCache c WHERE c.unitId = ?1"), @NamedQuery(name="findUseCacheByUserId", query="SELECT c FROM UseCache c WHERE c.useUserId = ?1"), @NamedQuery(name="findUseCacheByUnitIdAndUseUserId", query="SELECT c FROM UseCache c WHERE c.unitId = ?1 AND c.useUser.id = ?2 ORDER BY c.unitId"), @NamedQuery(name="findUseCacheByUnitGroupId", query="SELECT c FROM UseCache c, IN (c.groupHistory.unitGroups) ug WHERE ug.unitId = ?1 ORDER BY c.unitId"), @NamedQuery(name="findUseCacheByUnitGroupIdAndUseUserId", query="SELECT c FROM UseCache c, IN (c.groupHistory.unitGroups) ug WHERE ug.unitId = ?1 AND c.useUser.id = ?2 ORDER BY c.unitId")})
public class UseCache
extends UseBase
implements ICacheEntity<UseHistory> {
    private static final long serialVersionUID = -7323788513172312404L;
    @Id
    @Column(name="UNIT_ID")
    @Equals
    @ToString
    private long unitId;
    @OneToOne(targetEntity=UnitModel.class, fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="UNIT_ID", updatable=false, insertable=false)
    private UnitModel unitModel;
    @Column(name="history_id", nullable=false)
    @Equals
    @ToString
    private long historyId;
    @OneToOne(targetEntity=UseHistory.class, fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="history_id", updatable=false, insertable=false)
    private UseHistory history;

    public UseCache() {
    }

    public UseCache(UseBase useBase) {
        super(useBase);
        this.unitId = useBase.getUnitId();
        this.unitModel = new UnitModel(useBase.getUnitId());
    }

    public long getTimestamp() {
        return this.getBeginTime();
    }

    public void setTimestamp(long timestamp) {
        this.setBeginTime(timestamp);
    }

    public Object getPrimaryKey() {
        return this.unitId;
    }

    @Override
    public long getUnitId() {
        return this.unitId;
    }

    @Override
    public void setUnitId(long unitId) {
        this.unitId = unitId;
    }

    @Override
    public UnitModel getUnitModel() {
        return this.unitModel;
    }

    @Override
    protected void setUnitModel(UnitModel unitModel) {
        this.unitModel = unitModel;
    }

    @Override
    public long getHistoryId() {
        return this.historyId;
    }

    @Override
    public void setHistoryId(long historyId) {
        this.historyId = historyId;
    }

    @Override
    public UseHistory getHistory() {
        return this.history;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UseCache");
        stringBuilder.append(" (");
        stringBuilder.append("unitId = ");
        stringBuilder.append(this.unitId);
        stringBuilder.append(", ");
        stringBuilder.append("historyId = ");
        stringBuilder.append(this.historyId);
        stringBuilder.append(" (");
        stringBuilder.append(super.toString());
        stringBuilder.append(")");
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UseCache useCache = (UseCache)object;
        if (this.unitId != useCache.unitId) {
            return false;
        }
        return this.historyId == useCache.historyId;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = n * n2 + (int)(this.unitId ^ this.unitId >>> 32);
        n2 = n * n2 + (int)(this.historyId ^ this.historyId >>> 32);
        return n2;
    }
}

