/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.stateModel;

import de.proveo.maven.plugins.extendedObject.annotations.Equals;
import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.wwt.datamodel.state.StateCache;
import de.proveo.wwt.datamodel.state.StateHistory;
import de.proveo.wwt.datamodel.stateModel.StateInterpretation;
import de.proveo.wwt.datamodel.stateModel.StateModel;
import de.proveo.wwt.datamodel.stateModel.StateModelBase;
import de.proveo.wwt.datamodel.statesum.StateSummary;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditRelevant;
import de.proveo.wwt.logic.ejb.entityListener.StateModelListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="state_defn")
@NamedQueries(value={@NamedQuery(name="State.findByStateModelId", query="SELECT s FROM State s WHERE s.pk.stateModelId = ?1 ORDER BY s.order, s.pk.id")})
@EntityListeners(value={StateModelListener.class})
public class State
extends StateModelBase {
    private static final long serialVersionUID = -4343853615602489544L;
    @AuditRelevant
    @EmbeddedId
    @Equals
    @ToString
    private PK pk = new PK();
    @AuditRelevant
    @Equals
    @Column(name="color", length=15, nullable=false)
    @ToString
    private String color;
    @AuditRelevant
    @Equals
    @Column(name="user_settable_flag", nullable=false)
    @ToString
    private boolean userSettable;
    @AuditRelevant
    @Equals
    @Column(name="state_interpretation_id")
    @ToString
    private Integer stateInterpretationId;
    @ManyToOne(targetEntity=StateInterpretation.class, fetch=FetchType.LAZY)
    @JoinColumn(name="state_interpretation_id", insertable=false, updatable=false)
    private StateInterpretation stateInterpretation;
    @ManyToOne(targetEntity=StateModel.class, fetch=FetchType.LAZY)
    @JoinColumn(name="state_model_id", insertable=false, updatable=false)
    private StateModel stateModel;
    @OneToMany(targetEntity=StateCache.class, fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, mappedBy="state")
    private List<StateCache> stateCache = new ArrayList<StateCache>();
    @OneToMany(targetEntity=StateHistory.class, fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, mappedBy="state")
    private List<StateHistory> stateHistory = new ArrayList<StateHistory>();
    @OneToMany(targetEntity=StateHistory.class, fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, mappedBy="stateNext")
    private List<StateHistory> stateHistoryNext = new ArrayList<StateHistory>();
    @OneToMany(targetEntity=StateSummary.class, fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, mappedBy="state")
    private List<StateSummary> stateSummaries = new ArrayList<StateSummary>();

    public State() {
    }

    public State(State state) {
        super(state);
        this.pk = state.pk;
        this.color = state.color;
        this.userSettable = state.userSettable;
        this.stateInterpretationId = state.stateInterpretationId;
    }

    public String getName() {
        return this.pk != null ? ((Object)this.pk).toString() : "";
    }

    public Object getPrimaryKey() {
        return this.pk;
    }

    public PK getPk() {
        return this.pk;
    }

    public void setPk(PK pk) {
        this.pk = pk;
    }

    public int getId() {
        return this.pk.getId();
    }

    public int getStateModelId() {
        return this.pk.getStateModelId();
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public boolean isUserSettable() {
        return this.userSettable;
    }

    public void setUserSettable(boolean userSettable) {
        this.userSettable = userSettable;
    }

    public StateModel getStateModel() {
        return this.stateModel;
    }

    public Integer getStateInterpretationId() {
        return this.stateInterpretationId;
    }

    public void setStateInterpretationId(Integer stateInterpretationId) {
        this.stateInterpretationId = stateInterpretationId;
    }

    public StateInterpretation getStateInterpretation() {
        return this.stateInterpretation;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("State");
        stringBuilder.append(" (");
        stringBuilder.append("pk = ");
        stringBuilder.append(this.pk == null ? "[null]" : this.pk.toString());
        stringBuilder.append(", ");
        stringBuilder.append("color = ");
        stringBuilder.append(this.color == null ? "[null]" : this.color.toString());
        stringBuilder.append(", ");
        stringBuilder.append("userSettable = ");
        stringBuilder.append(this.userSettable);
        stringBuilder.append(", ");
        stringBuilder.append("stateInterpretationId = ");
        stringBuilder.append(this.stateInterpretationId == null ? "[null]" : this.stateInterpretationId.toString());
        stringBuilder.append(" (");
        stringBuilder.append(super.toString());
        stringBuilder.append(")");
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        State state = (State)((Object)object);
        if (this.pk == null ? state.pk != null : !this.pk.equals(state.pk)) {
            return false;
        }
        if (this.color == null ? state.color != null : !this.color.equals(state.color)) {
            return false;
        }
        if (this.userSettable != state.userSettable) {
            return false;
        }
        return !(this.stateInterpretationId == null ? state.stateInterpretationId != null : !this.stateInterpretationId.equals(state.stateInterpretationId));
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = n * n2 + (this.pk == null ? 0 : this.pk.hashCode());
        n2 = n * n2 + (this.color == null ? 0 : this.color.hashCode());
        n2 = n * n2 + (this.userSettable ? 0 : 1);
        n2 = n * n2 + (this.stateInterpretationId == null ? 0 : this.stateInterpretationId.hashCode());
        return n2;
    }

    @Embeddable
    public static class PK
    implements Serializable {
        private static final long serialVersionUID = -4756378255623676938L;
        @Equals
        @Column(name="id", nullable=false)
        @ToString
        private int id;
        @Equals
        @Column(name="state_model_id", nullable=false)
        @ToString
        private int stateModelId;

        public PK(PK pk) {
            this.id = pk.id;
            this.stateModelId = pk.stateModelId;
        }

        public PK(int stateId, int stateModelId) {
            this.id = stateId;
            this.stateModelId = stateModelId;
        }

        public PK() {
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public int getStateModelId() {
            return this.stateModelId;
        }

        public void setStateModelId(int stateModelId) {
            this.stateModelId = stateModelId;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("State$PK");
            stringBuilder.append(" (");
            stringBuilder.append("id = ");
            stringBuilder.append(this.id);
            stringBuilder.append(", ");
            stringBuilder.append("stateModelId = ");
            stringBuilder.append(this.stateModelId);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            PK pK = (PK)object;
            if (this.id != pK.id) {
                return false;
            }
            return this.stateModelId == pK.stateModelId;
        }

        public int hashCode() {
            int n = 31;
            int n2 = 1;
            n2 = n * n2 + this.id;
            n2 = n * n2 + this.stateModelId;
            return n2;
        }
    }
}

