/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.scanmanmsg;

import de.proveo.maven.plugins.extendedObject.annotations.Equals;
import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.wwt.datamodel.scanmanmsg.ScanmanMsgBase;
import de.proveo.wwt.datamodel.scanmanmsg.ScanmanMsgHistory;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.logic.ejb.dataIn.event.history.ICacheEntity;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Table;

@Entity
@Table(name="scanman_msg_cache")
@NamedQueries(value={@NamedQuery(name="findScanmanMsgCacheAllByTime", query="SELECT c FROM ScanmanMsgCache c WHERE c.createTime BETWEEN ?1 AND ?2"), @NamedQuery(name="findScanmanMsgCacheByUnitTime", query="SELECT c FROM ScanmanMsgCache c WHERE c.pk.unitId = :unitId AND c.createTime BETWEEN :since AND :until"), @NamedQuery(name="findScanmanMsgCacheAll", query="SELECT c FROM ScanmanMsgCache c"), @NamedQuery(name="findScanmanMsgCacheByUnit", query="SELECT c FROM ScanmanMsgCache c WHERE c.pk.unitId = ?1"), @NamedQuery(name="findScanmanMsgCacheByUnitGroup", query="SELECT c FROM ScanmanMsgCache c, IN (c.groupHistory.unitGroups) ug WHERE ug.unitId = :unitId"), @NamedQuery(name="findScanmanMsgCacheByTypeTime", query="SELECT c FROM ScanmanMsgCache c WHERE c.pk.type = :type AND c.createTime BETWEEN :since AND :until"), @NamedQuery(name="findScanmanMsgCacheByUnitTypeTime", query="SELECT c FROM ScanmanMsgCache c WHERE c.pk.type = :type AND c.pk.unitId = :unitId AND c.createTime BETWEEN :since AND :until"), @NamedQuery(name="findScanmanMsgCacheByUnitGroupId", query="SELECT c FROM ScanmanMsgCache c, IN (c.groupHistory.unitGroups) ug WHERE ug.unitId = :unitId AND c.createTime BETWEEN :since AND :until")})
public class ScanmanMsgCache
extends ScanmanMsgBase
implements ICacheEntity<ScanmanMsgHistory> {
    private static final long serialVersionUID = -7660575518449686492L;
    @EmbeddedId
    @Equals
    @ToString
    private PK pk = new PK();
    @ManyToOne(targetEntity=UnitModel.class, fetch=FetchType.LAZY)
    @JoinColumn(name="UNIT_ID", updatable=false, insertable=false)
    private UnitModel unitModel;
    @Column(name="history_id", nullable=false)
    @Equals
    @ToString
    private long historyId;
    @OneToOne(targetEntity=ScanmanMsgHistory.class, fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="history_id", updatable=false, insertable=false)
    private ScanmanMsgHistory history;

    public ScanmanMsgCache() {
    }

    public ScanmanMsgCache(ScanmanMsgBase scanmanMsgBase) {
        super(scanmanMsgBase);
        this.pk = new PK(scanmanMsgBase.getUnitId(), scanmanMsgBase.getType());
        this.unitModel = new UnitModel(scanmanMsgBase.getUnitId());
    }

    @Override
    public long getBeginTime() {
        return this.getCreateTime();
    }

    @Override
    public void setBeginTime(long timestamp) {
        this.setCreateTime(timestamp);
    }

    public Object getPrimaryKey() {
        return this.pk;
    }

    public PK getPk() {
        return this.pk;
    }

    public void setPk(PK pk) {
        this.pk = pk;
    }

    @Override
    public int getType() {
        return this.pk.getType();
    }

    @Override
    public void setType(int type) {
        this.pk.setType(type);
    }

    @Override
    public long getUnitId() {
        return this.pk.getUnitId();
    }

    @Override
    public void setUnitId(long unitId) {
        this.pk.setUnitId(unitId);
    }

    @Override
    public UnitModel getUnitModel() {
        return this.unitModel;
    }

    @Override
    protected void setUnitModel(UnitModel unitModel) {
        this.unitModel = unitModel;
    }

    @Override
    public long getHistoryId() {
        return this.historyId;
    }

    @Override
    public void setHistoryId(long historyId) {
        this.historyId = historyId;
    }

    @Override
    public ScanmanMsgHistory getHistory() {
        return this.history;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ScanmanMsgCache");
        stringBuilder.append(" (");
        stringBuilder.append("pk = ");
        stringBuilder.append(this.pk == null ? "[null]" : this.pk.toString());
        stringBuilder.append(", ");
        stringBuilder.append("historyId = ");
        stringBuilder.append(this.historyId);
        stringBuilder.append(" (");
        stringBuilder.append(super.toString());
        stringBuilder.append(")");
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ScanmanMsgCache scanmanMsgCache = (ScanmanMsgCache)object;
        if (this.pk == null ? scanmanMsgCache.pk != null : !this.pk.equals(scanmanMsgCache.pk)) {
            return false;
        }
        return this.historyId == scanmanMsgCache.historyId;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = n * n2 + (this.pk == null ? 0 : this.pk.hashCode());
        n2 = n * n2 + (int)(this.historyId ^ this.historyId >>> 32);
        return n2;
    }

    @Embeddable
    public static class PK
    implements Serializable {
        private static final long serialVersionUID = 7022876288310584954L;
        @Column(name="UNIT_ID")
        private long unitId;
        @Column(name="TYPE")
        private int type;

        public PK() {
        }

        public PK(PK pk) {
            this.unitId = pk.unitId;
            this.type = pk.type;
        }

        public PK(long unitId, int type) {
            this.unitId = unitId;
            this.type = type;
        }

        public long getUnitId() {
            return this.unitId;
        }

        public void setUnitId(long unitId) {
            this.unitId = unitId;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PK)) {
                return false;
            }
            PK other = (PK)o;
            return this.unitId == other.unitId && this.type == other.type;
        }

        public int hashCode() {
            return (int)(this.unitId ^ this.unitId >>> 32) ^ this.type;
        }

        public String toString() {
            String TAB = "    ";
            StringBuilder retValue = new StringBuilder();
            retValue.append("PK ( ").append(super.toString()).append("    ").append("type = ").append(this.type).append("    ").append("unitId = ").append(this.unitId).append("    ").append(" )");
            return retValue.toString();
        }
    }
}

