/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.measurement;

import de.proveo.maven.plugins.extendedObject.annotations.Equals;
import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.util.jpa.entity.EntityBase;
import de.proveo.wwt.datamodel.measurement.MeasurementCache;
import de.proveo.wwt.datamodel.measurement.MeasurementConversion;
import de.proveo.wwt.datamodel.measurement.MeasurementHistory;
import de.proveo.wwt.datamodel.measurement.MeasurementIntervalDefn;
import de.proveo.wwt.datamodel.measurement.MeasurementRange;
import de.proveo.wwt.datamodel.measurement.MeasurementType;
import de.proveo.wwt.datamodel.measurement.MeasurementUnit;
import de.proveo.wwt.logic.ejb.entityListener.MeasurementListener;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="measurement_defn")
@NamedQueries(value={@NamedQuery(name="measurementDefinition.findAll", query="SELECT m FROM MeasurementDefinition m"), @NamedQuery(name="measurementDefinition.findByMeasurementType", query="SELECT m FROM MeasurementDefinition m WHERE m.measurementUnit.measurementTypeId=?1")})
@EntityListeners(value={MeasurementListener.class})
public class MeasurementDefinition
extends EntityBase {
    private static final long serialVersionUID = -7559727001960808348L;
    @Id
    @Column(name="id")
    @Equals
    @ToString
    private int id;
    @Column(name="name", length=255, nullable=false)
    @Equals
    @ToString
    private String name;
    @Column(name="description", length=255)
    @Equals
    @ToString
    private String description;
    @Column(name="min_value")
    @Equals
    @ToString
    private Float minValue;
    @Column(name="max_value")
    @Equals
    @ToString
    private Float maxValue;
    @Column(name="custom_format_pattern", length=50)
    @Equals
    @ToString
    private String customFormatPattern;
    @Lob
    @Column(name="conversion_script", length=65535)
    @Equals
    @ToString
    private String conversionScript;
    @Column(name="measurement_unit_id", nullable=false)
    @Equals
    @ToString
    private int measurementUnitId;
    @Column(name="cache_only")
    @Equals
    @ToString
    private boolean cacheOnly;
    @ManyToOne(targetEntity=MeasurementUnit.class, fetch=FetchType.EAGER)
    @JoinColumn(name="measurement_unit_id", updatable=false, insertable=false)
    private MeasurementUnit measurementUnit;
    @OneToMany(targetEntity=MeasurementRange.class, mappedBy="measurementDefinition", cascade={CascadeType.REMOVE}, fetch=FetchType.EAGER)
    private List<MeasurementRange> measurementRanges = new ArrayList<MeasurementRange>();
    @OneToMany(targetEntity=MeasurementConversion.class, mappedBy="measurementDefinition", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private List<MeasurementConversion> measurementConversions = new ArrayList<MeasurementConversion>();
    @OneToMany(targetEntity=MeasurementCache.class, mappedBy="measurementDefinition", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private List<MeasurementCache> measurementCache = new ArrayList<MeasurementCache>();
    @OneToMany(targetEntity=MeasurementHistory.class, mappedBy="measurementDefinition", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private List<MeasurementHistory> measurementHistory = new ArrayList<MeasurementHistory>();
    @OneToMany(fetch=FetchType.LAZY, mappedBy="measurementDefn", targetEntity=MeasurementIntervalDefn.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    private List<MeasurementIntervalDefn> measurementIntervalDefns = new ArrayList<MeasurementIntervalDefn>();

    public MeasurementDefinition() {
    }

    public MeasurementDefinition(MeasurementDefinition md) {
        this();
        this.id = md.id;
        this.name = md.name;
        this.description = md.description;
        this.minValue = md.minValue;
        this.maxValue = md.maxValue;
        this.customFormatPattern = md.customFormatPattern;
        this.conversionScript = md.conversionScript;
        this.measurementUnitId = md.measurementUnitId;
        this.cacheOnly = md.cacheOnly;
    }

    public Object getPrimaryKey() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Float getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Float minValue) {
        this.minValue = minValue;
    }

    public Float getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Float maxValue) {
        this.maxValue = maxValue;
    }

    public String getCustomFormatPattern() {
        if (this.customFormatPattern != null) {
            return this.customFormatPattern;
        }
        if (this.measurementUnit != null) {
            return this.measurementUnit.getFormatPattern();
        }
        return null;
    }

    public void setCustomFormatPattern(String customFormatPattern) {
        this.customFormatPattern = customFormatPattern;
    }

    public String getConversionScript() {
        return this.conversionScript;
    }

    public void setConversionScript(String conversionScript) {
        this.conversionScript = conversionScript;
    }

    public int getMeasurementUnitId() {
        return this.measurementUnitId;
    }

    public void setMeasurementUnitId(int measurementUnitId) {
        this.measurementUnitId = measurementUnitId;
    }

    public boolean isCacheOnly() {
        return this.cacheOnly;
    }

    public void setCacheOnly(boolean cacheOnly) {
        this.cacheOnly = cacheOnly;
    }

    public MeasurementUnit getMeasurementUnit() {
        return this.measurementUnit;
    }

    public List<MeasurementRange> getMeasurementRanges() {
        return this.measurementRanges;
    }

    public List<MeasurementConversion> getMeasurementConversions() {
        return this.measurementConversions;
    }

    public MeasurementType getMeasurementType() {
        return this.measurementUnit.getMeasurementType();
    }

    public List<MeasurementCache> getMeasurementCache() {
        return this.measurementCache;
    }

    public void setMeasurementCache(List<MeasurementCache> measurementCache) {
        this.measurementCache = measurementCache;
    }

    public List<MeasurementHistory> getMeasurementHistory() {
        return this.measurementHistory;
    }

    public void setMeasurementHistory(List<MeasurementHistory> measurementHistory) {
        this.measurementHistory = measurementHistory;
    }

    public void setMeasurementIntervalDefns(List<MeasurementIntervalDefn> measurementIntervalDefns) {
        this.measurementIntervalDefns = measurementIntervalDefns;
    }

    public List<MeasurementIntervalDefn> getMeasurementIntervalDefns() {
        return this.measurementIntervalDefns;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MeasurementDefinition");
        stringBuilder.append(" (");
        stringBuilder.append("id = ");
        stringBuilder.append(this.id);
        stringBuilder.append(", ");
        stringBuilder.append("name = ");
        stringBuilder.append(this.name == null ? "[null]" : this.name.toString());
        stringBuilder.append(", ");
        stringBuilder.append("description = ");
        stringBuilder.append(this.description == null ? "[null]" : this.description.toString());
        stringBuilder.append(", ");
        stringBuilder.append("minValue = ");
        stringBuilder.append(this.minValue == null ? "[null]" : this.minValue.toString());
        stringBuilder.append(", ");
        stringBuilder.append("maxValue = ");
        stringBuilder.append(this.maxValue == null ? "[null]" : this.maxValue.toString());
        stringBuilder.append(", ");
        stringBuilder.append("customFormatPattern = ");
        stringBuilder.append(this.customFormatPattern == null ? "[null]" : this.customFormatPattern.toString());
        stringBuilder.append(", ");
        stringBuilder.append("conversionScript = ");
        stringBuilder.append(this.conversionScript == null ? "[null]" : this.conversionScript.toString());
        stringBuilder.append(", ");
        stringBuilder.append("measurementUnitId = ");
        stringBuilder.append(this.measurementUnitId);
        stringBuilder.append(", ");
        stringBuilder.append("cacheOnly = ");
        stringBuilder.append(this.cacheOnly);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        MeasurementDefinition measurementDefinition = (MeasurementDefinition)((Object)object);
        if (this.id != measurementDefinition.id) {
            return false;
        }
        if (this.name == null ? measurementDefinition.name != null : !this.name.equals(measurementDefinition.name)) {
            return false;
        }
        if (this.description == null ? measurementDefinition.description != null : !this.description.equals(measurementDefinition.description)) {
            return false;
        }
        if (this.minValue == null ? measurementDefinition.minValue != null : !this.minValue.equals(measurementDefinition.minValue)) {
            return false;
        }
        if (this.maxValue == null ? measurementDefinition.maxValue != null : !this.maxValue.equals(measurementDefinition.maxValue)) {
            return false;
        }
        if (this.customFormatPattern == null ? measurementDefinition.customFormatPattern != null : !this.customFormatPattern.equals(measurementDefinition.customFormatPattern)) {
            return false;
        }
        if (this.conversionScript == null ? measurementDefinition.conversionScript != null : !this.conversionScript.equals(measurementDefinition.conversionScript)) {
            return false;
        }
        if (this.measurementUnitId != measurementDefinition.measurementUnitId) {
            return false;
        }
        return this.cacheOnly == measurementDefinition.cacheOnly;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = n * n2 + this.id;
        n2 = n * n2 + (this.name == null ? 0 : this.name.hashCode());
        n2 = n * n2 + (this.description == null ? 0 : this.description.hashCode());
        n2 = n * n2 + (this.minValue == null ? 0 : this.minValue.hashCode());
        n2 = n * n2 + (this.maxValue == null ? 0 : this.maxValue.hashCode());
        n2 = n * n2 + (this.customFormatPattern == null ? 0 : this.customFormatPattern.hashCode());
        n2 = n * n2 + (this.conversionScript == null ? 0 : this.conversionScript.hashCode());
        n2 = n * n2 + this.measurementUnitId;
        n2 = n * n2 + (this.cacheOnly ? 0 : 1);
        return n2;
    }
}

