/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.locale;

import de.proveo.maven.plugins.extendedObject.annotations.Equals;
import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.util.jpa.entity.EntityBase;
import de.proveo.wwt.datamodel.resourceString.ResourceString;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.QueryHint;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="locale_defn")
@NamedQueries(value={@NamedQuery(name="Locale.findAll", query="SELECT l FROM Locale l", hints={@QueryHint(name="org.hibernate.cacheable", value="true")}), @NamedQuery(name="Locale.findByLanguageAndCountry", query="SELECT l FROM Locale l WHERE l.language = ?1 AND l.country = ?2", hints={@QueryHint(name="org.hibernate.cacheable", value="true")})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class Locale
extends EntityBase {
    private static final long serialVersionUID = -6366831038345054237L;
    @Equals
    @Id
    @Column(name="id")
    @GenericGenerator(name="incrementer", strategy="increment")
    @GeneratedValue(generator="incrementer")
    @ToString
    private int id;
    @Equals
    @Column(name="language", length=2, nullable=false)
    @ToString
    private String language;
    @Equals
    @Column(name="country", length=2, nullable=false)
    @ToString
    private String country;
    @OneToMany(targetEntity=ResourceString.class, fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, mappedBy="locale")
    private List<ResourceString> resourceStrings = new ArrayList<ResourceString>();

    public Locale() {
    }

    public Locale(String language, String country) {
        this.setLanguage(language);
        this.setCountry(country);
    }

    public String getName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.language).append("-").append(this.country);
        return sb.toString();
    }

    public Object getPrimaryKey() {
        return this.id;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language.toLowerCase();
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country.toUpperCase();
    }

    public List<ResourceString> getResourceStrings() {
        return this.resourceStrings;
    }

    public void setLocale(java.util.Locale locale) {
        this.setLanguage(locale.getLanguage());
        this.setCountry(locale.getCountry());
    }

    public java.util.Locale getLocale() {
        return new java.util.Locale(this.language, this.country);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Locale");
        stringBuilder.append(" (");
        stringBuilder.append("id = ");
        stringBuilder.append(this.id);
        stringBuilder.append(", ");
        stringBuilder.append("language = ");
        stringBuilder.append(this.language == null ? "[null]" : this.language.toString());
        stringBuilder.append(", ");
        stringBuilder.append("country = ");
        stringBuilder.append(this.country == null ? "[null]" : this.country.toString());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        Locale locale = (Locale)((Object)object);
        if (this.id != locale.id) {
            return false;
        }
        if (this.language == null ? locale.language != null : !this.language.equals(locale.language)) {
            return false;
        }
        return !(this.country == null ? locale.country != null : !this.country.equals(locale.country));
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = n * n2 + this.id;
        n2 = n * n2 + (this.language == null ? 0 : this.language.hashCode());
        n2 = n * n2 + (this.country == null ? 0 : this.country.hashCode());
        return n2;
    }
}

