/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.fis;

import de.proveo.maven.plugins.extendedObject.annotations.Equals;
import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.util.jpa.entity.EntityBase;
import de.proveo.wwt.datamodel.fis.FISFlight;
import de.proveo.wwt.datamodel.fis.StandStateHistory;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Table;

@Entity
@Table(name="stand_state_cache")
@NamedQueries(value={@NamedQuery(name="findAllStandStateCache", query="SELECT o FROM StandStateCache o"), @NamedQuery(name="findAllStandStateCacheWithFlight", query="SELECT o FROM StandStateCache o LEFT JOIN FETCH o.inbFlight"), @NamedQuery(name="findStandStateCacheForStand", query="SELECT o FROM StandStateCache o WHERE o.pk.stand=?1"), @NamedQuery(name="findStandStateCacheForStandAndStateModel", query="SELECT o FROM StandStateCache o WHERE o.pk.stand=?1 AND o.pk.stateModelId=?2")})
public class StandStateCache
extends EntityBase
implements Serializable {
    private static final long serialVersionUID = 7941615503083815745L;
    @EmbeddedId
    private PK pk = new PK();
    @Column(name="STATE_ID")
    @Equals
    @ToString
    private long stateId;
    @Column(name="BEGIN_TIME")
    @Equals
    @ToString
    private long beginTime;
    @ManyToOne(targetEntity=FISFlight.class)
    @JoinColumn(name="INB_FLIGHT_ID")
    @Equals
    @ToString
    private FISFlight inbFlight;
    @ManyToOne(targetEntity=FISFlight.class)
    @JoinColumn(name="OUTB_FLIGHT_ID")
    @Equals
    @ToString
    private FISFlight outbFlight;
    @Column(name="HISTORY_ID")
    @Equals
    @ToString
    private long historyId;
    @OneToOne(targetEntity=StandStateHistory.class, fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="HISTORY_ID", updatable=false, insertable=false)
    private StandStateHistory history;

    public PK getPk() {
        return this.pk;
    }

    public void setPk(PK pk) {
        this.pk = pk;
    }

    public long getStateId() {
        return this.stateId;
    }

    public void setStateId(long stateId) {
        this.stateId = stateId;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(long beginTime) {
        this.beginTime = beginTime;
    }

    public FISFlight getInbFlight() {
        return this.inbFlight;
    }

    public void setInbFlight(FISFlight flight) {
        this.inbFlight = flight;
    }

    public FISFlight getOutbFlight() {
        return this.outbFlight;
    }

    public void setOutbFlight(FISFlight outbFlight) {
        this.outbFlight = outbFlight;
    }

    public long getHistoryId() {
        return this.historyId;
    }

    public void setHistoryId(long historyId) {
        this.historyId = historyId;
    }

    public StandStateHistory getHistory() {
        return this.history;
    }

    public String getName() {
        return ((Object)this.pk).toString();
    }

    public Object getPrimaryKey() {
        return this.pk;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("StandStateCache");
        stringBuilder.append(" (");
        stringBuilder.append("stateId = ");
        stringBuilder.append(this.stateId);
        stringBuilder.append(", ");
        stringBuilder.append("beginTime = ");
        stringBuilder.append(this.beginTime);
        stringBuilder.append(", ");
        stringBuilder.append("inbFlight = ");
        stringBuilder.append(this.inbFlight == null ? "[null]" : this.inbFlight.toString());
        stringBuilder.append(", ");
        stringBuilder.append("outbFlight = ");
        stringBuilder.append(this.outbFlight == null ? "[null]" : this.outbFlight.toString());
        stringBuilder.append(", ");
        stringBuilder.append("historyId = ");
        stringBuilder.append(this.historyId);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StandStateCache standStateCache = (StandStateCache)object;
        if (this.stateId != standStateCache.stateId) {
            return false;
        }
        if (this.beginTime != standStateCache.beginTime) {
            return false;
        }
        if (this.inbFlight == null ? standStateCache.inbFlight != null : !this.inbFlight.equals(standStateCache.inbFlight)) {
            return false;
        }
        if (this.outbFlight == null ? standStateCache.outbFlight != null : !this.outbFlight.equals(standStateCache.outbFlight)) {
            return false;
        }
        return this.historyId == standStateCache.historyId;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = n * n2 + (int)(this.stateId ^ this.stateId >>> 32);
        n2 = n * n2 + (int)(this.beginTime ^ this.beginTime >>> 32);
        n2 = n * n2 + (this.inbFlight == null ? 0 : this.inbFlight.hashCode());
        n2 = n * n2 + (this.outbFlight == null ? 0 : this.outbFlight.hashCode());
        n2 = n * n2 + (int)(this.historyId ^ this.historyId >>> 32);
        return n2;
    }

    @Embeddable
    public static class PK
    implements Serializable {
        private static final long serialVersionUID = -4444291585403585751L;
        @Column(name="STAND")
        @Equals
        @ToString
        private String stand;
        @Column(name="STATE_MODEL_ID")
        @Equals
        @ToString
        private long stateModelId;

        public PK(PK pK) {
            this.stand = pK.stand;
            this.stateModelId = pK.stateModelId;
        }

        public PK(String stand, long stateModelId) {
            this.stand = stand;
            this.stateModelId = stateModelId;
        }

        public PK() {
        }

        public String getStand() {
            return this.stand;
        }

        public void setStand(String stand) {
            this.stand = stand;
        }

        public long getStateModelId() {
            return this.stateModelId;
        }

        public void setStateModelId(long stateModelId) {
            this.stateModelId = stateModelId;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("StandStateCache$PK");
            stringBuilder.append(" (");
            stringBuilder.append("stand = ");
            stringBuilder.append(this.stand == null ? "[null]" : this.stand.toString());
            stringBuilder.append(", ");
            stringBuilder.append("stateModelId = ");
            stringBuilder.append(this.stateModelId);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            PK pK = (PK)object;
            if (this.stand == null ? pK.stand != null : !this.stand.equals(pK.stand)) {
                return false;
            }
            return this.stateModelId == pK.stateModelId;
        }

        public int hashCode() {
            int n = 31;
            int n2 = 1;
            n2 = n * n2 + (this.stand == null ? 0 : this.stand.hashCode());
            n2 = n * n2 + (int)(this.stateModelId ^ this.stateModelId >>> 32);
            return n2;
        }
    }
}

