/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.audit;

import de.proveo.util.jpa.entity.EntityBase;
import de.proveo.wwt.datamodel.stateModel.StateModel;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.QueryHint;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="report_audit")
@NamedQueries(value={@NamedQuery(name="findReportAuditAll", query="SELECT a FROM ReportAudit a", hints={@QueryHint(name="org.hibernate.cacheable", value="true")}), @NamedQuery(name="findReportAuditByTimeframe", query="SELECT a FROM ReportAudit a WHERE a.execTime > ?1 AND a.execTime < ?2 ORDER BY a.execTime ASC", hints={@QueryHint(name="org.hibernate.cacheable", value="true")})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class ReportAudit
extends EntityBase {
    private static final long serialVersionUID = 671473758990349267L;
    @Id
    @Column(name="ID")
    @GenericGenerator(name="incrementer", strategy="increment")
    @GeneratedValue(generator="incrementer")
    private long id;
    @Column(name="REPORT_NAME")
    private String reportName;
    @Column(name="USERNAME")
    private String userName;
    @Column(name="EXEC_TIME", nullable=false)
    private long execTime;
    @Column(name="EXEC_DURATION")
    private long execDuration;
    @Column(name="DATA_SIZE", nullable=false)
    private long dataSize;
    @Column(name="BEGIN_TIME", nullable=false)
    private long beginTime;
    @Column(name="END_TIME")
    private long endTime;
    @Column(name="STATE_MODEL_ID")
    private Integer stateModelId;
    @ManyToOne(targetEntity=StateModel.class, fetch=FetchType.LAZY)
    @JoinColumn(name="STATE_MODEL_ID", updatable=false, insertable=false)
    private StateModel stateModel;
    @ManyToMany(targetEntity=UnitModel.class, fetch=FetchType.EAGER)
    @JoinTable(name="report_audit_x_unit_model", joinColumns={@JoinColumn(name="REPORT_AUDIT_ID")}, inverseJoinColumns={@JoinColumn(name="UNIT_ID")})
    private List<UnitModel> units = new ArrayList<UnitModel>();
    @Column(name="REMARK")
    private String remark;
    @Column(name="SELECTION")
    private String selection;

    public ReportAudit() {
    }

    public ReportAudit(ReportAudit reportAudit) {
        this.id = reportAudit.id;
        this.reportName = reportAudit.reportName;
        this.userName = reportAudit.userName;
        this.execTime = reportAudit.execTime;
        this.execDuration = reportAudit.execDuration;
        this.dataSize = reportAudit.dataSize;
        this.beginTime = reportAudit.beginTime;
        this.endTime = reportAudit.endTime;
        this.units = reportAudit.units;
        this.stateModelId = reportAudit.stateModelId;
        this.remark = reportAudit.remark;
        this.selection = reportAudit.selection;
    }

    public String getName() {
        return this.reportName;
    }

    public Object getPrimaryKey() {
        return this.id;
    }

    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public long getExecTime() {
        return this.execTime;
    }

    public void setExecTime(long execTime) {
        this.execTime = execTime;
    }

    public long getExecDuration() {
        return this.execDuration;
    }

    public void setExecDuration(long execDuration) {
        this.execDuration = execDuration;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public void setDataSize(long dataSize) {
        this.dataSize = dataSize;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(long beginTime) {
        this.beginTime = beginTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public Integer getStateModelId() {
        return this.stateModelId;
    }

    public void setStateModelId(Integer stateId) {
        this.stateModelId = stateId;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getSelection() {
        return this.selection;
    }

    public void setSelection(String selection) {
        this.selection = selection;
    }

    public long getId() {
        return this.id;
    }

    public String toString() {
        String TAB = "    ";
        String retValue = "";
        retValue = "ReportAudit ( " + super.toString() + "    " + "Id = " + this.id + "    " + "reportName = " + this.reportName + "    " + "userName = " + this.userName + "    " + "execTime = " + this.execTime + "    " + "execDuration = " + this.execDuration + "    " + "dataSize = " + this.dataSize + "    " + "beginTime = " + this.beginTime + "    " + "endTime = " + this.endTime + "    " + "units = " + this.units + "    " + "stateId = " + this.stateModelId + "    " + "remark = " + this.remark + "    " + "section = " + this.selection + "    " + " )";
        return retValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (int)(this.beginTime ^ this.beginTime >>> 32);
        result = 31 * result + (int)(this.dataSize ^ this.dataSize >>> 32);
        result = 31 * result + (int)(this.endTime ^ this.endTime >>> 32);
        result = 31 * result + (int)(this.execDuration ^ this.execDuration >>> 32);
        result = 31 * result + (int)(this.execTime ^ this.execTime >>> 32);
        result = 31 * result + (this.remark == null ? 0 : this.remark.hashCode());
        result = 31 * result + (this.reportName == null ? 0 : this.reportName.hashCode());
        result = 31 * result + (this.selection == null ? 0 : this.selection.hashCode());
        result = 31 * result + (this.stateModelId == null ? 0 : this.stateModelId.hashCode());
        result = 31 * result + ((Object)this.units).hashCode();
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ReportAudit other = (ReportAudit)((Object)obj);
        if (this.id != other.id) {
            return false;
        }
        if (this.beginTime != other.beginTime) {
            return false;
        }
        if (this.dataSize != other.dataSize) {
            return false;
        }
        if (this.endTime != other.endTime) {
            return false;
        }
        if (this.execDuration != other.execDuration) {
            return false;
        }
        if (this.execTime != other.execTime) {
            return false;
        }
        if (this.remark == null ? other.remark != null : !this.remark.equals(other.remark)) {
            return false;
        }
        if (this.reportName == null ? other.reportName != null : !this.reportName.equals(other.reportName)) {
            return false;
        }
        if (this.selection == null ? other.selection != null : !this.selection.equals(other.selection)) {
            return false;
        }
        if (this.stateModelId == null ? other.stateModelId != null : !this.stateModelId.equals(other.stateModelId)) {
            return false;
        }
        if (this.getUnitIds() != other.getUnitIds()) {
            return false;
        }
        return !(this.userName == null ? other.userName != null : !this.userName.equals(other.userName));
    }

    public void setStateModel(StateModel stateModel) {
        this.stateModel = stateModel;
    }

    public StateModel getStateModel() {
        return this.stateModel;
    }

    public void setUnits(List<UnitModel> units) {
        this.units = units;
    }

    public List<UnitModel> getUnits() {
        return this.units;
    }

    public List<Long> getUnitIds() {
        ArrayList<Long> unitIds = new ArrayList<Long>();
        if (this.units == null || this.units.isEmpty()) {
            unitIds.add(0L);
        } else {
            for (UnitModel m : this.units) {
                unitIds.add(m.getUnitId());
            }
        }
        return unitIds;
    }
}

