/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.area;

import de.proveo.util.jpa.entity.EntityBase;
import de.proveo.util.math.Point;
import de.proveo.wwt.datamodel.area.Area;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="area_points")
@NamedQueries(value={@NamedQuery(name="findAreaPointsByAreaIdMissingPoints", query="SELECT a FROM AreaPoints a WHERE a.areaPK.areaId = ?1 AND a.areaPK.point > ?2"), @NamedQuery(name="findAreaPointsByAreaId", query="SELECT a FROM AreaPoints a WHERE a.areaPK.areaId = ?1 ORDER BY a.areaPK.point")})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class AreaPoints
extends EntityBase
implements Point {
    @EmbeddedId
    private AreaPK areaPK;
    @ManyToOne(targetEntity=Area.class, fetch=FetchType.LAZY)
    @JoinColumn(name="area_id", updatable=false, insertable=false)
    private Area area;
    @Column(name="LONG_MSEC")
    private int longMsec;
    @Column(name="LAT_MSEC")
    private int latMsec;
    private static final long serialVersionUID = 1L;

    public AreaPoints(AreaPoints areaPoints) {
        this.areaPK = areaPoints.areaPK;
        this.longMsec = areaPoints.longMsec;
        this.latMsec = areaPoints.latMsec;
    }

    public AreaPoints() {
        this.areaPK = new AreaPK();
    }

    public AreaPK getPk() {
        return this.areaPK;
    }

    public void setPk(AreaPK areaPK) {
        this.areaPK = areaPK;
    }

    public String getName() {
        return this.areaPK != null ? this.areaPK.toString() : "";
    }

    public Object getPrimaryKey() {
        return this.areaPK;
    }

    public int getLongMsec() {
        return this.longMsec;
    }

    public void setLongMsec(int longMsec) {
        this.longMsec = longMsec;
    }

    public int getLatMsec() {
        return this.latMsec;
    }

    public void setLatMsec(int latMsec) {
        this.latMsec = latMsec;
    }

    public double getX() {
        return this.getLongMsec();
    }

    public double getY() {
        return this.getLatMsec();
    }

    public void setLatitude(int degree, int minute, int second, int millisecond) {
        this.setLatitude(AreaPoints.getMsec(degree, minute, second, millisecond));
    }

    public void setLatitude(int msec) {
        this.setLatMsec(msec);
    }

    public int getLatitude() {
        return this.getLatMsec();
    }

    public int getLatitudeDegree() {
        return this.getDegree(this.getLatitude());
    }

    public int getLatitudeMillisecond() {
        return this.getMillisecond(this.getLatitude());
    }

    public int getLatitudeMinute() {
        return this.getMinute(this.getLatitude());
    }

    public int getLatitudeSecond() {
        return this.getSecond(this.getLatitude());
    }

    public void setLongitude(int longitude) {
        this.setLongMsec(longitude);
    }

    public void setLongitude(int degree, int minute, int second, int millisecond) {
        this.setLongitude(AreaPoints.getMsec(degree, minute, second, millisecond));
    }

    public int getLongitude() {
        return this.getLongMsec();
    }

    public int getLongitudeDegree() {
        return this.getDegree(this.getLongitude());
    }

    public int getLongitudeMillisecond() {
        return this.getMillisecond(this.getLongitude());
    }

    public int getLongitudeMinute() {
        return this.getMinute(this.getLongitude());
    }

    public static int getMsec(int degree, int minute, int second, int millisecond) {
        return degree * 60 * 60 * 1000 + minute * 60 * 1000 + second * 1000 + millisecond;
    }

    private int getDegree(int msec) {
        return msec / 3600000;
    }

    private int getMillisecond(int msec) {
        return msec - this.getDegree(msec) * 60 * 60 * 1000 - this.getMinute(msec) * 60 * 1000 - this.getSecond(msec) * 60 * 1000;
    }

    private int getMinute(int msec) {
        return msec / 60000 - this.getDegree(msec) * 60;
    }

    private int getSecond(int msec) {
        return msec / 1000 - this.getDegree(msec) * 60 * 60 - this.getMinute(msec) * 60;
    }

    public int getPoint() {
        return this.areaPK.getPoint();
    }

    public void setPoint(int point) {
        this.areaPK.setPoint(point);
    }

    public int getAreaId() {
        return this.areaPK.getAreaId();
    }

    public void setAreaId(int areaId) {
        this.areaPK.setAreaId(areaId);
    }

    public String toString() {
        String TAB = "    ";
        StringBuilder retValue = new StringBuilder();
        retValue.append("AreaPoints ( ").append(super.toString()).append("    ").append("latMsec = ").append(this.latMsec).append("    ").append("longMsec = ").append(this.longMsec).append("    ").append("areaPK = ").append(this.areaPK).append("    ").append(" )");
        return retValue.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.latMsec;
        result = 31 * result + this.longMsec;
        result = 31 * result + (this.areaPK == null ? 0 : this.areaPK.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AreaPoints)) {
            return false;
        }
        AreaPoints other = (AreaPoints)((Object)obj);
        if (this.latMsec != other.latMsec) {
            return false;
        }
        if (this.longMsec != other.longMsec) {
            return false;
        }
        return !(this.areaPK == null ? other.areaPK != null : !this.areaPK.equals(other.areaPK));
    }

    @Embeddable
    public static class AreaPK
    implements Serializable {
        private static final long serialVersionUID = -8450709073747438360L;
        @Column(name="POINT")
        private int point;
        @Column(name="AREA_ID")
        private int areaId;

        public AreaPK(int areaId, int point) {
            this.areaId = areaId;
            this.point = point;
        }

        public AreaPK() {
        }

        public int getPoint() {
            return this.point;
        }

        public void setPoint(int point) {
            this.point = point;
        }

        public int getAreaId() {
            return this.areaId;
        }

        public void setAreaId(int areaId) {
            this.areaId = areaId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.areaId;
            result = 31 * result + this.point;
            result = 31 * result + -1918625737;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AreaPK other = (AreaPK)obj;
            if (this.areaId != other.areaId) {
                return false;
            }
            return this.point == other.point;
        }

        public String toString() {
            String TAB = "    ";
            StringBuffer retValue = new StringBuffer();
            retValue.append("AreaPK ( ").append(super.toString()).append("    ").append("point = ").append(this.point).append("    ").append("areaId = ").append(this.areaId).append("    ").append(" )");
            return retValue.toString();
        }
    }
}

