/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.area;

import de.proveo.maven.plugins.extendedObject.annotations.Equals;
import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.util.jpa.entity.EntityBase;
import de.proveo.wwt.datamodel.area.AreaPoints;
import de.proveo.wwt.datamodel.geo.GdataCache;
import de.proveo.wwt.datamodel.geo.GdataHistory;
import de.proveo.wwt.datamodel.geofencing.GeofZone;
import de.proveo.wwt.datamodel.notify.NotifyCache;
import de.proveo.wwt.datamodel.notify.NotifyHistory;
import de.proveo.wwt.datamodel.state.StateCache;
import de.proveo.wwt.datamodel.state.StateHistory;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.datamodel.use.UseCache;
import de.proveo.wwt.datamodel.use.UseHistory;
import de.proveo.wwt.logic.web.common.dto.interfaces.IDTOAttachable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.QueryHint;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="area")
@NamedQueries(value={@NamedQuery(name="findAreaAll", query="SELECT a FROM Area a", hints={@QueryHint(name="org.hibernate.cacheable", value="true")}), @NamedQuery(name="Area.findAllWithPoints", query="SELECT DISTINCT a FROM Area a LEFT JOIN FETCH a.areaPoints ap WHERE a.deleted = false ORDER BY a.priority, a.areaId, ap.areaPK.point"), @NamedQuery(name="findAreaByVicinity", query="SELECT a FROM Area a WHERE a.minLongMsec <= ?1 AND a.maxLongMsec > ?1 AND a.minLatMsec < ?2 AND a.maxLatMsec > ?2 AND a.deleted=FALSE and a.isGeofencing=FALSE ORDER BY a.priority DESC", hints={@QueryHint(name="org.hibernate.cacheable", value="true")}), @NamedQuery(name="findAreaOrderedByPriority", query="SELECT a FROM Area a ORDER BY a.priority", hints={@QueryHint(name="org.hibernate.cacheable", value="true")}), @NamedQuery(name="findOrderedByPriorityByAirport", query="SELECT a FROM Area a WHERE a.unitModel.unitId = ?1 ORDER BY a.priority", hints={@QueryHint(name="org.hibernate.cacheable", value="true")}), @NamedQuery(name="findAreaAllForAirportmap", query="SELECT a FROM Area a, GdataCache g WHERE a.areaId = g.area.areaId", hints={@QueryHint(name="org.hibernate.cacheable", value="true")}), @NamedQuery(name="findAreasNotAllocatedToUnit", query="SELECT a FROM Area a WHERE a.unitModel IS NULL", hints={@QueryHint(name="org.hibernate.cacheable", value="true")}), @NamedQuery(name="findAreasAllocatedToUnit", query="SELECT a FROM Area a WHERE a.unitModel IS NOT NULL", hints={@QueryHint(name="org.hibernate.cacheable", value="true")}), @NamedQuery(name="findAreaByName", query="SELECT a FROM Area a WHERE a.area = ?1", hints={@QueryHint(name="org.hibernate.cacheable", value="true")}), @NamedQuery(name="findAreaById", query="SELECT a FROM Area a WHERE a.areaId = ?1", hints={@QueryHint(name="org.hibernate.cacheable", value="true")})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class Area
extends EntityBase
implements IDTOAttachable {
    private static final long serialVersionUID = -8392539012918477930L;
    @Id
    @Column(name="AREA_ID")
    @GenericGenerator(name="incrementer", strategy="increment")
    @GeneratedValue(generator="incrementer")
    @Equals
    @ToString
    private Integer areaId;
    @Column(name="AREA")
    @Equals
    @ToString
    private String area;
    @Column(name="MAX_LAT_MSEC")
    @Equals
    @ToString
    private int maxLatMsec;
    @Column(name="MAX_LONG_MSEC")
    @Equals
    @ToString
    private int maxLongMsec;
    @Column(name="MIN_LAT_MSEC")
    @Equals
    @ToString
    private int minLatMsec;
    @Column(name="MIN_LONG_MSEC")
    @Equals
    @ToString
    private int minLongMsec;
    @Column(name="DESCRIPTION")
    @Equals
    @ToString
    private String description;
    @Column(name="PRIORITY")
    @Equals
    @ToString
    private int priority;
    @Column(name="IS_GEOFENCING")
    @Equals
    @ToString
    private boolean isGeofencing;
    @Column(name="DELETED")
    @Equals
    @ToString
    private boolean deleted;
    @Column(name="UNIT_ID")
    @Equals
    @ToString
    private Long unitId;
    @OneToMany(targetEntity=StateCache.class, mappedBy="area", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private List<StateCache> currentStateCaches = new ArrayList<StateCache>();
    @OneToMany(targetEntity=StateHistory.class, mappedBy="area", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private List<StateHistory> stateHistories = new ArrayList<StateHistory>();
    @OneToMany(targetEntity=UseHistory.class, mappedBy="beginArea", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private List<UseHistory> useBeginHistories = new ArrayList<UseHistory>();
    @OneToMany(targetEntity=UseHistory.class, mappedBy="endArea", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private List<UseHistory> useEndHistories = new ArrayList<UseHistory>();
    @OneToMany(targetEntity=UseCache.class, mappedBy="beginArea", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private List<UseCache> useCaches = new ArrayList<UseCache>();
    @OneToMany(targetEntity=NotifyCache.class, mappedBy="area", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private List<NotifyCache> currentNotifyCaches = new ArrayList<NotifyCache>();
    @OneToMany(targetEntity=NotifyHistory.class, mappedBy="area", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private List<NotifyHistory> notifyHistories = new ArrayList<NotifyHistory>();
    @OneToMany(targetEntity=GdataCache.class, mappedBy="area", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private List<GdataCache> currentGdadaCaches = new ArrayList<GdataCache>();
    @OneToMany(targetEntity=GdataHistory.class, mappedBy="area", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private List<GdataHistory> gdataHistories = new ArrayList<GdataHistory>();
    @OneToMany(targetEntity=AreaPoints.class, mappedBy="areaPK.areaId", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    @OrderBy
    private List<AreaPoints> areaPoints = new ArrayList<AreaPoints>();
    @ManyToOne(targetEntity=UnitModel.class, fetch=FetchType.LAZY)
    @JoinColumn(name="UNIT_ID", updatable=false, insertable=false)
    private UnitModel unitModel;
    @ManyToMany(targetEntity=GeofZone.class, fetch=FetchType.LAZY)
    @JoinTable(name="geof_area_x_zone", joinColumns={@JoinColumn(name="AREA_ID")}, inverseJoinColumns={@JoinColumn(name="ZONE_ID")})
    private List<GeofZone> geofZones = new ArrayList<GeofZone>();

    public Area(Area area) {
        this.areaId = area.areaId;
        this.area = area.area;
        this.maxLatMsec = area.maxLatMsec;
        this.maxLongMsec = area.maxLongMsec;
        this.minLatMsec = area.minLatMsec;
        this.minLongMsec = area.minLongMsec;
        this.description = area.description;
        this.priority = area.priority;
        this.isGeofencing = area.isGeofencing;
        this.deleted = area.deleted;
        this.currentStateCaches = area.currentStateCaches;
        this.stateHistories = area.stateHistories;
        this.useBeginHistories = area.useBeginHistories;
        this.useEndHistories = area.useEndHistories;
        this.useCaches = area.useCaches;
        this.currentNotifyCaches = area.currentNotifyCaches;
        this.notifyHistories = area.notifyHistories;
        this.currentGdadaCaches = area.currentGdadaCaches;
        this.gdataHistories = area.gdataHistories;
        this.areaPoints = area.areaPoints;
        this.unitModel = area.unitModel;
        this.unitId = area.unitId;
        this.geofZones = area.geofZones;
    }

    public Area() {
    }

    public String getName() {
        return this.area;
    }

    public Object getPrimaryKey() {
        return this.areaId;
    }

    public int getAreaId() {
        return this.areaId;
    }

    public void setAreaId(int areaId) {
        this.areaId = areaId;
    }

    public String getArea() {
        return this.area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public int getMaxLatMsec() {
        return this.maxLatMsec;
    }

    public void setMaxLatMsec(int maxLatMsec) {
        this.maxLatMsec = maxLatMsec;
    }

    public int getMaxLongMsec() {
        return this.maxLongMsec;
    }

    public void setMaxLongMsec(int maxLongMsec) {
        this.maxLongMsec = maxLongMsec;
    }

    public int getMinLatMsec() {
        return this.minLatMsec;
    }

    public void setMinLatMsec(int minLatMsec) {
        this.minLatMsec = minLatMsec;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getMinLongMsec() {
        return this.minLongMsec;
    }

    public void setMinLongMsec(int minLongMsec) {
        this.minLongMsec = minLongMsec;
    }

    public List<StateCache> getCurrentStateCaches() {
        return this.currentStateCaches;
    }

    public void setCurrentStateCaches(List<StateCache> currentStateCaches) {
        this.currentStateCaches = currentStateCaches;
    }

    public List<UseHistory> getUseBeginHistories() {
        return this.useBeginHistories;
    }

    public void setUseBeginHistories(List<UseHistory> useBeginHistories) {
        this.useBeginHistories = useBeginHistories;
    }

    public List<UseHistory> getUseEndHistories() {
        return this.useEndHistories;
    }

    public void setUseEndHistories(List<UseHistory> useEndHistories) {
        this.useEndHistories = useEndHistories;
    }

    public List<UseCache> getUseCaches() {
        return this.useCaches;
    }

    public void setUseCaches(List<UseCache> useCaches) {
        this.useCaches = useCaches;
    }

    public List<NotifyCache> getCurrentNotifyCaches() {
        return this.currentNotifyCaches;
    }

    public void setCurrentNotifyCaches(List<NotifyCache> currentNotifyCaches) {
        this.currentNotifyCaches = currentNotifyCaches;
    }

    public List<NotifyHistory> getNotifyHistories() {
        return this.notifyHistories;
    }

    public void setNotifyHistories(List<NotifyHistory> notifyHistories) {
        this.notifyHistories = notifyHistories;
    }

    public List<GdataCache> getCurrentGdadaCaches() {
        return this.currentGdadaCaches;
    }

    public void setCurrentGdadaCaches(List<GdataCache> currentGdadaCaches) {
        this.currentGdadaCaches = currentGdadaCaches;
    }

    public List<GdataHistory> getGdataHistories() {
        return this.gdataHistories;
    }

    public void setGdataHistories(List<GdataHistory> gdataHistories) {
        this.gdataHistories = gdataHistories;
    }

    public List<StateHistory> getStateHistories() {
        return this.stateHistories;
    }

    public void setStateHistories(List<StateHistory> stateHistories) {
        this.stateHistories = stateHistories;
    }

    public List<AreaPoints> getAreaPoints() {
        return this.areaPoints;
    }

    public void setAreaPoints(List<AreaPoints> areaPoints) {
        this.areaPoints = areaPoints;
    }

    public boolean isGeofencing() {
        return this.isGeofencing;
    }

    public void setGeofencing(boolean isGeofencing) {
        this.isGeofencing = isGeofencing;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public UnitModel getUnitModel() {
        return this.unitModel;
    }

    public void setUnitModel(UnitModel unitModel) {
        this.unitModel = unitModel;
    }

    public Long getUnitId() {
        return this.unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public List<GeofZone> getGeofZones() {
        return this.geofZones;
    }

    public void setGeofZones(List<GeofZone> geofZones) {
        this.geofZones = geofZones;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Area");
        stringBuilder.append(" (");
        stringBuilder.append("areaId = ");
        stringBuilder.append(this.areaId == null ? "[null]" : this.areaId.toString());
        stringBuilder.append(", ");
        stringBuilder.append("area = ");
        stringBuilder.append(this.area == null ? "[null]" : this.area.toString());
        stringBuilder.append(", ");
        stringBuilder.append("maxLatMsec = ");
        stringBuilder.append(this.maxLatMsec);
        stringBuilder.append(", ");
        stringBuilder.append("maxLongMsec = ");
        stringBuilder.append(this.maxLongMsec);
        stringBuilder.append(", ");
        stringBuilder.append("minLatMsec = ");
        stringBuilder.append(this.minLatMsec);
        stringBuilder.append(", ");
        stringBuilder.append("minLongMsec = ");
        stringBuilder.append(this.minLongMsec);
        stringBuilder.append(", ");
        stringBuilder.append("description = ");
        stringBuilder.append(this.description == null ? "[null]" : this.description.toString());
        stringBuilder.append(", ");
        stringBuilder.append("priority = ");
        stringBuilder.append(this.priority);
        stringBuilder.append(", ");
        stringBuilder.append("isGeofencing = ");
        stringBuilder.append(this.isGeofencing);
        stringBuilder.append(", ");
        stringBuilder.append("deleted = ");
        stringBuilder.append(this.deleted);
        stringBuilder.append(", ");
        stringBuilder.append("unitId = ");
        stringBuilder.append(this.unitId == null ? "[null]" : this.unitId.toString());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Area area = (Area)object;
        if (this.areaId == null ? area.areaId != null : !this.areaId.equals(area.areaId)) {
            return false;
        }
        if (this.area == null ? area.area != null : !this.area.equals(area.area)) {
            return false;
        }
        if (this.maxLatMsec != area.maxLatMsec) {
            return false;
        }
        if (this.maxLongMsec != area.maxLongMsec) {
            return false;
        }
        if (this.minLatMsec != area.minLatMsec) {
            return false;
        }
        if (this.minLongMsec != area.minLongMsec) {
            return false;
        }
        if (this.description == null ? area.description != null : !this.description.equals(area.description)) {
            return false;
        }
        if (this.priority != area.priority) {
            return false;
        }
        if (this.isGeofencing != area.isGeofencing) {
            return false;
        }
        if (this.deleted != area.deleted) {
            return false;
        }
        return !(this.unitId == null ? area.unitId != null : !this.unitId.equals(area.unitId));
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = n * n2 + (this.areaId == null ? 0 : this.areaId.hashCode());
        n2 = n * n2 + (this.area == null ? 0 : this.area.hashCode());
        n2 = n * n2 + this.maxLatMsec;
        n2 = n * n2 + this.maxLongMsec;
        n2 = n * n2 + this.minLatMsec;
        n2 = n * n2 + this.minLongMsec;
        n2 = n * n2 + (this.description == null ? 0 : this.description.hashCode());
        n2 = n * n2 + this.priority;
        n2 = n * n2 + (this.isGeofencing ? 0 : 1);
        n2 = n * n2 + (this.deleted ? 0 : 1);
        n2 = n * n2 + (this.unitId == null ? 0 : this.unitId.hashCode());
        return n2;
    }
}

