/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.io.IOException;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.source.indexing.TransactionContext;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;

public final class PersistentIndexTransaction
extends TransactionContext.Service {
    private ClassIndexImpl.Writer indexWriter;

    public static PersistentIndexTransaction create() {
        return new PersistentIndexTransaction();
    }

    @Override
    protected void commit() throws IOException {
        if (this.indexWriter != null) {
            try {
                this.indexWriter.commit();
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                throw new IOException(t);
            }
        }
    }

    @Override
    protected void rollBack() throws IOException {
        if (this.indexWriter != null) {
            try {
                this.indexWriter.rollback();
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                throw new IOException(t);
            }
        }
    }

    public void setIndexWriter(@NonNull ClassIndexImpl.Writer writer) {
        assert (this.indexWriter == null);
        assert (writer != null);
        this.indexWriter = writer;
    }

    @CheckForNull
    public ClassIndexImpl.Writer getIndexWriter() {
        return this.indexWriter;
    }
}

