/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.JComponent;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.classfile.Annotation;
import org.netbeans.modules.classfile.AnnotationComponent;
import org.netbeans.modules.classfile.ArrayElementValue;
import org.netbeans.modules.classfile.CPClassInfo;
import org.netbeans.modules.classfile.CPFieldInfo;
import org.netbeans.modules.classfile.CPInterfaceMethodInfo;
import org.netbeans.modules.classfile.CPMethodInfo;
import org.netbeans.modules.classfile.ClassElementValue;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.ClassName;
import org.netbeans.modules.classfile.Code;
import org.netbeans.modules.classfile.ConstantPool;
import org.netbeans.modules.classfile.ElementValue;
import org.netbeans.modules.classfile.EnumElementValue;
import org.netbeans.modules.classfile.InvalidClassFormatException;
import org.netbeans.modules.classfile.LocalVariableTableEntry;
import org.netbeans.modules.classfile.LocalVariableTypeTableEntry;
import org.netbeans.modules.classfile.Method;
import org.netbeans.modules.classfile.NestedElementValue;
import org.netbeans.modules.classfile.Parameter;
import org.netbeans.modules.classfile.Variable;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.usages.ClassFileUtil;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.DocumentUtil;
import org.netbeans.modules.java.source.usages.LongHashMap;
import org.netbeans.modules.java.source.usages.Pair;
import org.netbeans.modules.parsing.impl.indexing.SPIAccessor;
import org.netbeans.modules.parsing.impl.indexing.SuspendSupport;
import org.netbeans.modules.parsing.lucene.support.LowMemoryWatcher;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public class BinaryAnalyser {
    private static final String ROOT = "/";
    private static final String TIME_STAMPS = "timestamps.properties";
    private static final String CRC = "crc.properties";
    private static final Logger LOGGER = Logger.getLogger(BinaryAnalyser.class.getName());
    private static final String JCOMPONENT = JComponent.class.getName();
    static final String OBJECT = Object.class.getName();
    private static boolean FULL_INDEX = Boolean.getBoolean("org.netbeans.modules.java.source.usages.BinaryAnalyser.fullIndex");
    private final ClassIndexImpl.Writer writer;
    private final File cacheRoot;
    private final List<Pair<Pair<String, String>, Object[]>> refs = new ArrayList<Pair<Pair<String, String>, Object[]>>();
    private final Set<Pair<String, String>> toDelete = new HashSet<Pair<String, String>>();
    private final LowMemoryWatcher lmListener;
    private Continuation cont;
    private Pair<LongHashMap<String>, Set<String>> timeStamps;

    BinaryAnalyser(@NonNull ClassIndexImpl.Writer writer, @NonNull File cacheRoot) {
        Parameters.notNull((CharSequence)"writer", (Object)writer);
        Parameters.notNull((CharSequence)"cacheRoot", (Object)cacheRoot);
        this.writer = writer;
        this.cacheRoot = cacheRoot;
        this.lmListener = LowMemoryWatcher.getInstance();
    }

    public final Result start(@NonNull Context ctx) throws IOException, IllegalArgumentException {
        return this.start(ctx.getRootURI(), ctx);
    }

    @Deprecated
    public final Result start(@NonNull URL url, AtomicBoolean canceled, AtomicBoolean shutdown) throws IOException, IllegalArgumentException {
        return this.start(url, SPIAccessor.getInstance().createContext(FileUtil.createMemoryFileSystem().getRoot(), url, "java", 14, null, false, false, false, SuspendSupport.NOP, null, null));
    }

    public Result resume() throws IOException {
        assert (this.cont != null);
        return this.cont.execute();
    }

    public Changes finish() throws IOException {
        if (this.cont == null) {
            return new Changes(Changes.NO_CHANGES, Changes.NO_CHANGES, Changes.NO_CHANGES, false);
        }
        if (!this.cont.hasChanges() && this.timeStampsEmpty()) {
            assert (this.refs.isEmpty());
            assert (this.toDelete.isEmpty());
            return new Changes(Changes.NO_CHANGES, Changes.NO_CHANGES, Changes.NO_CHANGES, false);
        }
        List<Pair<ElementHandle<TypeElement>, Long>> newState = this.cont.finish();
        List<Pair<ElementHandle<TypeElement>, Long>> oldState = this.loadCRCs(this.cacheRoot);
        boolean preBuildArgs = this.cont.preBuildArgs();
        this.cont = null;
        this.store();
        this.storeCRCs(this.cacheRoot, newState);
        this.storeTimeStamps();
        return BinaryAnalyser.diff(oldState, newState, preBuildArgs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Result start(URL root, @NonNull Context ctx) throws IOException, IllegalArgumentException {
        Parameters.notNull((CharSequence)"ctx", (Object)ctx);
        assert (this.cont == null);
        String mainP = root.getProtocol();
        if ("jar".equals(mainP)) {
            URL innerURL = FileUtil.getArchiveFile((URL)root);
            if (!"file".equals(innerURL.getProtocol())) {
                FileObject rootFo = URLMapper.findFileObject((URL)root);
                if (rootFo == null) return this.deleted();
                if (this.isUpToDate(ROOT, rootFo.lastModified().getTime())) return Result.FINISHED;
                this.writer.clear();
                Enumeration todo = rootFo.getData(true);
                this.cont = new FileObjectContinuation(todo, rootFo, ctx);
                return this.cont.execute();
            }
            File archive = Utilities.toFile((URI)URI.create(innerURL.toExternalForm()));
            if (!archive.canRead()) return this.deleted();
            if (this.isUpToDate(ROOT, archive.lastModified())) return Result.FINISHED;
            this.writer.clear();
            try {
                ZipFile zipFile = new ZipFile(archive);
                Enumeration<? extends ZipEntry> e = zipFile.entries();
                this.cont = new ZipContinuation(zipFile, e, ctx);
                return this.cont.execute();
            }
            catch (ZipException e) {
                LOGGER.log(Level.WARNING, "Broken zip file: {0}", archive.getAbsolutePath());
                return Result.FINISHED;
            }
        }
        if (!"file".equals(mainP)) {
            FileObject rootFo = URLMapper.findFileObject((URL)root);
            if (rootFo == null) return this.deleted();
            this.writer.clear();
            Enumeration todo = rootFo.getData(true);
            this.cont = new FileObjectContinuation(todo, rootFo, ctx);
            return this.cont.execute();
        }
        File rootFile = Utilities.toFile((URI)URI.create(root.toExternalForm()));
        if (!rootFile.isDirectory()) return Result.FINISHED;
        String path = rootFile.getAbsolutePath();
        if (path.charAt(path.length() - 1) != File.separatorChar) {
            path = path + File.separatorChar;
        }
        LinkedList<File> todo = new LinkedList<File>();
        File[] children = rootFile.listFiles();
        if (children != null) {
            todo.addAll(Arrays.asList(children));
        }
        this.cont = new FolderContinuation(todo, path, ctx);
        return this.cont.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Pair<ElementHandle<TypeElement>, Long>> loadCRCs(File indexFolder) throws IOException {
        LinkedList<Pair<ElementHandle<TypeElement>, Long>> result;
        block8: {
            result = new LinkedList<Pair<ElementHandle<TypeElement>, Long>>();
            File file = new File(indexFolder, CRC);
            if (file.canRead()) {
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                block5: while (true) {
                    String line;
                    while ((line = in.readLine()) != null) {
                        String[] parts = line.split("=");
                        if (parts.length != 2) continue;
                        try {
                            ElementHandle<TypeElement> handle = ElementHandle.createTypeElementHandle(ElementKind.CLASS, parts[0]);
                            Long crc = Long.parseLong(parts[1]);
                            result.add(Pair.of(handle, crc));
                            continue block5;
                        }
                        catch (NumberFormatException e) {
                        }
                    }
                    break block8;
                    {
                        continue block5;
                        break;
                    }
                    break;
                }
                finally {
                    in.close();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeCRCs(File indexFolder, List<Pair<ElementHandle<TypeElement>, Long>> state) throws IOException {
        File file = new File(indexFolder, CRC);
        if (state.isEmpty()) {
            file.delete();
        } else {
            PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            try {
                for (Pair<ElementHandle<TypeElement>, Long> pair : state) {
                    StringBuilder sb = new StringBuilder(((ElementHandle)pair.first).getBinaryName());
                    sb.append('=');
                    sb.append((Long)pair.second);
                    out.println(sb.toString());
                }
            }
            finally {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private Pair<LongHashMap<String>, Set<String>> getTimeStamps() throws IOException {
        if (this.timeStamps == null) {
            LongHashMap<String> map;
            block9: {
                map = new LongHashMap<String>();
                File f = new File(this.cacheRoot, TIME_STAMPS);
                if (f.exists()) {
                    BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
                    block5: while (true) {
                        String line;
                        while (null != (line = in.readLine())) {
                            int idx = line.indexOf(61);
                            if (idx == -1) continue;
                            try {
                                long ts = Long.parseLong(line.substring(idx + 1));
                                map.put(line.substring(0, idx), ts);
                                continue block5;
                            }
                            catch (NumberFormatException nfe) {
                                LOGGER.log(Level.FINE, "Invalid timestamp: line={0}, timestamps={1}, exception={2}", new Object[]{line, f.getPath(), nfe});
                            }
                        }
                        break block9;
                        {
                            continue block5;
                            break;
                        }
                        break;
                    }
                    finally {
                        in.close();
                    }
                }
            }
            this.timeStamps = Pair.of(map, new HashSet(map.keySet()));
        }
        return this.timeStamps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeTimeStamps() throws IOException {
        File f = new File(this.cacheRoot, TIME_STAMPS);
        if (this.timeStamps == null) {
            f.delete();
        } else {
            ((LongHashMap)this.timeStamps.first).keySet().removeAll((Collection)this.timeStamps.second);
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8"));
            try {
                for (LongHashMap.Entry entry : ((LongHashMap)this.timeStamps.first).entrySet()) {
                    out.write((String)entry.getKey());
                    out.write(61);
                    out.write(Long.toString(entry.getValue()));
                    out.newLine();
                }
                out.flush();
            }
            finally {
                this.timeStamps = null;
                out.close();
            }
        }
    }

    private boolean timeStampsEmpty() {
        return this.timeStamps == null || ((Set)this.timeStamps.second).isEmpty();
    }

    private boolean isUpToDate(String resourceName, long timeStamp) throws IOException {
        Pair<LongHashMap<String>, Set<String>> ts = this.getTimeStamps();
        long oldTime = ((LongHashMap)ts.first).put(resourceName, timeStamp);
        ((Set)ts.second).remove(resourceName);
        return oldTime == timeStamp;
    }

    static Changes diff(List<Pair<ElementHandle<TypeElement>, Long>> oldState, List<Pair<ElementHandle<TypeElement>, Long>> newState, boolean preBuildArgs) {
        LinkedList changed = new LinkedList();
        LinkedList removed = new LinkedList();
        LinkedList added = new LinkedList();
        Iterator<Pair<ElementHandle<TypeElement>, Long>> oldIt = oldState.iterator();
        Iterator<Pair<ElementHandle<TypeElement>, Long>> newIt = newState.iterator();
        Pair<ElementHandle<TypeElement>, Long> oldE = null;
        Pair<ElementHandle<TypeElement>, Long> newE = null;
        while (oldIt.hasNext() && newIt.hasNext()) {
            int ni;
            if (oldE == null) {
                oldE = oldIt.next();
            }
            if (newE == null) {
                newE = newIt.next();
            }
            if ((ni = ((ElementHandle)oldE.first).getBinaryName().compareTo(((ElementHandle)newE.first).getBinaryName())) == 0) {
                if ((Long)oldE.second == 0L || ((Long)oldE.second).longValue() != ((Long)newE.second).longValue()) {
                    changed.add(oldE.first);
                }
                newE = null;
                oldE = null;
                continue;
            }
            if (ni < 0) {
                removed.add(oldE.first);
                oldE = null;
                continue;
            }
            if (ni <= 0) continue;
            added.add(newE.first);
            newE = null;
        }
        if (oldE != null) {
            removed.add(oldE.first);
        }
        while (oldIt.hasNext()) {
            removed.add(oldIt.next().first);
        }
        if (newE != null) {
            added.add(newE.first);
        }
        while (newIt.hasNext()) {
            added.add(newIt.next().first);
        }
        return new Changes(added, removed, changed, preBuildArgs);
    }

    private static String nameToString(ClassName name) {
        return name.getInternalName().replace('/', '.');
    }

    private static void addUsage(Map<ClassName, Set<ClassIndexImpl.UsageType>> usages, ClassName name, ClassIndexImpl.UsageType usage) {
        if (OBJECT.equals(name.getExternalName())) {
            return;
        }
        Set<ClassIndexImpl.UsageType> uset = usages.get(name);
        if (uset == null) {
            uset = EnumSet.noneOf(ClassIndexImpl.UsageType.class);
            usages.put(name, uset);
        }
        uset.add(usage);
    }

    private void releaseData() {
        this.refs.clear();
        this.toDelete.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() throws IOException {
        try {
            if (this.refs.size() > 0 || this.toDelete.size() > 0) {
                this.writer.deleteAndFlush(this.refs, this.toDelete);
            }
        }
        finally {
            this.releaseData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store() throws IOException {
        try {
            this.writer.deleteAndStore(this.refs, this.toDelete);
        }
        finally {
            this.releaseData();
        }
    }

    private Result deleted() throws IOException {
        this.cont = new DeletedContinuation();
        return this.cont.execute();
    }

    private void delete(String className) throws IOException {
        assert (className != null);
        this.toDelete.add(Pair.of(className, null));
    }

    private boolean accepts(String name) {
        int index = name.lastIndexOf(46);
        if (index == -1 || index + 1 == name.length()) {
            return false;
        }
        return "CLASS".equalsIgnoreCase(name.substring(index + 1));
    }

    private void analyse(InputStream inputStream) throws IOException {
        ClassFile classFile = new ClassFile(inputStream);
        ClassName className = classFile.getName();
        String classNameStr = BinaryAnalyser.nameToString(className);
        this.delete(classNameStr);
        Map<ClassName, Set<ClassIndexImpl.UsageType>> usages = this.performAnalyse(classFile, classNameStr);
        ElementKind kind = ElementKind.CLASS;
        if (classFile.isEnum()) {
            kind = ElementKind.ENUM;
        } else if (classFile.isAnnotation()) {
            kind = ElementKind.ANNOTATION_TYPE;
        } else if ((classFile.getAccess() & 0x200) == 512) {
            kind = ElementKind.INTERFACE;
        }
        String classNameType = classNameStr + DocumentUtil.encodeKind(kind);
        Pair<String, Object> pair = Pair.of(classNameType, null);
        List<String> references = this.getClassReferences(pair);
        for (Map.Entry<ClassName, Set<ClassIndexImpl.UsageType>> entry : usages.entrySet()) {
            ClassName name = entry.getKey();
            Set<ClassIndexImpl.UsageType> usage = entry.getValue();
            references.add(DocumentUtil.encodeUsage(BinaryAnalyser.nameToString(name), usage));
        }
    }

    /*
     * WARNING - void declaration
     */
    private Map<ClassName, Set<ClassIndexImpl.UsageType>> performAnalyse(ClassFile classFile, String className) throws IOException {
        ClassName scName;
        HashMap<ClassName, Set<ClassIndexImpl.UsageType>> usages = new HashMap<ClassName, Set<ClassIndexImpl.UsageType>>();
        String signature = classFile.getTypeSignature();
        if (signature != null) {
            try {
                ClassName[] typeSigNames;
                for (ClassName typeSigName : typeSigNames = ClassFileUtil.getTypesFromClassTypeSignature(signature)) {
                    BinaryAnalyser.addUsage(usages, typeSigName, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                }
            }
            catch (RuntimeException re) {
                StackTraceElement[] elements;
                StringBuilder message = new StringBuilder("BinaryAnalyser: Cannot read type: " + signature + " cause: " + re.getLocalizedMessage() + '\n');
                for (StackTraceElement e : elements = re.getStackTrace()) {
                    message.append(e.toString());
                    message.append('\n');
                }
                LOGGER.warning(message.toString());
            }
        }
        if ((scName = classFile.getSuperClass()) != null) {
            BinaryAnalyser.addUsage(usages, scName, ClassIndexImpl.UsageType.SUPER_CLASS);
        }
        Collection interfaces = classFile.getInterfaces();
        for (ClassName ifaceName : interfaces) {
            BinaryAnalyser.addUsage(usages, ifaceName, ClassIndexImpl.UsageType.SUPER_INTERFACE);
        }
        if (!FULL_INDEX) {
            this.handleAnnotations(usages, classFile.getAnnotations(), true);
        }
        if (FULL_INDEX) {
            ClassName name;
            this.handleAnnotations(usages, classFile.getAnnotations(), false);
            ConstantPool constantPool = classFile.getConstantPool();
            Collection fields = constantPool.getAllConstants(CPFieldInfo.class);
            for (CPFieldInfo field : fields) {
                ClassName name2 = ClassFileUtil.getType(constantPool.getClass(field.getClassID()));
                if (name2 == null) continue;
                BinaryAnalyser.addUsage(usages, name2, ClassIndexImpl.UsageType.FIELD_REFERENCE);
            }
            Collection methodCalls = constantPool.getAllConstants(CPMethodInfo.class);
            for (CPMethodInfo method : methodCalls) {
                name = ClassFileUtil.getType(constantPool.getClass(method.getClassID()));
                if (name == null) continue;
                BinaryAnalyser.addUsage(usages, name, ClassIndexImpl.UsageType.METHOD_REFERENCE);
            }
            methodCalls = constantPool.getAllConstants(CPInterfaceMethodInfo.class);
            for (CPMethodInfo method : methodCalls) {
                name = ClassFileUtil.getType(constantPool.getClass(method.getClassID()));
                if (name == null) continue;
                BinaryAnalyser.addUsage(usages, name, ClassIndexImpl.UsageType.METHOD_REFERENCE);
            }
            Collection methods = classFile.getMethods();
            for (Method method : methods) {
                LocalVariableTypeTableEntry[] varTypes;
                LocalVariableTableEntry[] vars;
                Code code;
                CPClassInfo[] classInfos;
                this.handleAnnotations(usages, method.getAnnotations(), false);
                String jvmTypeId = method.getReturnType();
                ClassName type = ClassFileUtil.getType(jvmTypeId);
                if (type != null) {
                    BinaryAnalyser.addUsage(usages, type, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                }
                List params = method.getParameters();
                for (Parameter param : params) {
                    jvmTypeId = param.getDescriptor();
                    type = ClassFileUtil.getType(jvmTypeId);
                    if (type == null) continue;
                    BinaryAnalyser.addUsage(usages, type, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                }
                for (CPClassInfo cPClassInfo : classInfos = method.getExceptionClasses()) {
                    type = cPClassInfo.getClassName();
                    if (type == null) continue;
                    BinaryAnalyser.addUsage(usages, type, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                }
                jvmTypeId = method.getTypeSignature();
                if (jvmTypeId != null) {
                    try {
                        void var20_38;
                        ClassName[] typeSigNames;
                        ClassName[] arr$ = typeSigNames = ClassFileUtil.getTypesFromMethodTypeSignature(jvmTypeId);
                        int len$ = arr$.length;
                        boolean bl = false;
                        while (var20_38 < len$) {
                            ClassName typeSigName = arr$[var20_38];
                            BinaryAnalyser.addUsage(usages, typeSigName, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                            ++var20_38;
                        }
                    }
                    catch (IllegalStateException is) {
                        LOGGER.log(Level.WARNING, "Invalid method signature: {0}::{1} signature is:{2}", new Object[]{className, method.getName(), jvmTypeId});
                    }
                }
                if ((code = method.getCode()) == null) continue;
                for (LocalVariableTableEntry var : vars = code.getLocalVariableTable()) {
                    type = ClassFileUtil.getType(var.getDescription());
                    if (type == null) continue;
                    BinaryAnalyser.addUsage(usages, type, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                }
                for (LocalVariableTypeTableEntry varType : varTypes = method.getCode().getLocalVariableTypeTable()) {
                    try {
                        ClassName[] typeSigNames;
                        for (ClassName typeSigName : typeSigNames = ClassFileUtil.getTypesFromFiledTypeSignature(varType.getSignature())) {
                            BinaryAnalyser.addUsage(usages, typeSigName, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                        }
                    }
                    catch (IllegalStateException is) {
                        LOGGER.log(Level.WARNING, "Invalid local variable signature: {0}::{1}", new Object[]{className, method.getName()});
                    }
                }
            }
            Collection vars = classFile.getVariables();
            for (Variable var : vars) {
                this.handleAnnotations(usages, var.getAnnotations(), false);
                String jvmTypeId = var.getDescriptor();
                ClassName type = ClassFileUtil.getType(jvmTypeId);
                if (type != null) {
                    BinaryAnalyser.addUsage(usages, type, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                }
                if ((jvmTypeId = var.getTypeSignature()) == null) continue;
                try {
                    ClassName[] typeSigNames = ClassFileUtil.getTypesFromFiledTypeSignature(jvmTypeId);
                    for (CPClassInfo cPClassInfo : typeSigNames) {
                        BinaryAnalyser.addUsage(usages, (ClassName)cPClassInfo, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                    }
                }
                catch (IllegalStateException is) {
                    LOGGER.log(Level.WARNING, "Invalid field signature: {0}::{1} signature is: {2}", new Object[]{className, var.getName(), jvmTypeId});
                }
            }
            Collection cis = constantPool.getAllConstants(CPClassInfo.class);
            for (CPClassInfo ci : cis) {
                ClassName ciName = ClassFileUtil.getType(ci);
                if (ciName == null || usages.keySet().contains(ciName)) continue;
                BinaryAnalyser.addUsage(usages, ciName, ClassIndexImpl.UsageType.TYPE_REFERENCE);
            }
        }
        return usages;
    }

    private List<String> getClassReferences(Pair<String, String> name) {
        assert (name != null);
        Object[] cr = new Object[]{new ArrayList(), null, null};
        this.refs.add(Pair.of(name, cr));
        return (ArrayList)cr[0];
    }

    private void handleAnnotations(Map<ClassName, Set<ClassIndexImpl.UsageType>> usages, Iterable<? extends Annotation> annotations, boolean onlyTopLevel) {
        for (Annotation annotation : annotations) {
            BinaryAnalyser.addUsage(usages, annotation.getType(), ClassIndexImpl.UsageType.TYPE_REFERENCE);
            if (onlyTopLevel) continue;
            LinkedList<ElementValue> toProcess = new LinkedList<ElementValue>();
            for (AnnotationComponent ac : annotation.getComponents()) {
                toProcess.add(ac.getValue());
            }
            while (!toProcess.isEmpty()) {
                String type;
                ClassName className;
                ElementValue ev = (ElementValue)toProcess.remove(0);
                if (ev instanceof ArrayElementValue) {
                    toProcess.addAll(Arrays.asList(((ArrayElementValue)ev).getValues()));
                }
                if (ev instanceof NestedElementValue) {
                    Annotation nested = ((NestedElementValue)ev).getNestedValue();
                    BinaryAnalyser.addUsage(usages, nested.getType(), ClassIndexImpl.UsageType.TYPE_REFERENCE);
                    for (AnnotationComponent ac : nested.getComponents()) {
                        toProcess.add(ac.getValue());
                    }
                }
                if (ev instanceof ClassElementValue) {
                    BinaryAnalyser.addUsage(usages, ((ClassElementValue)ev).getClassName(), ClassIndexImpl.UsageType.TYPE_REFERENCE);
                }
                if (!(ev instanceof EnumElementValue) || (className = ClassFileUtil.getType(type = ((EnumElementValue)ev).getEnumType())) == null) continue;
                BinaryAnalyser.addUsage(usages, className, ClassIndexImpl.UsageType.TYPE_REFERENCE);
            }
        }
    }

    public static final class Changes {
        static final List<ElementHandle<TypeElement>> NO_CHANGES = Collections.emptyList();
        public final List<ElementHandle<TypeElement>> added;
        public final List<ElementHandle<TypeElement>> removed;
        public final List<ElementHandle<TypeElement>> changed;
        public final boolean preBuildArgs;

        private Changes(List<ElementHandle<TypeElement>> added, List<ElementHandle<TypeElement>> removed, List<ElementHandle<TypeElement>> changed, boolean preBuildArgs) {
            this.added = added;
            this.removed = removed;
            this.changed = changed;
            this.preBuildArgs = preBuildArgs;
        }
    }

    private static abstract class Continuation {
        private List<Pair<ElementHandle<TypeElement>, Long>> result = new ArrayList<Pair<ElementHandle<TypeElement>, Long>>();
        private boolean changed;
        private byte preBuildArgsState;

        protected Continuation() {
        }

        protected abstract Result doExecute() throws IOException;

        protected abstract void doFinish() throws IOException;

        protected final void report(ElementHandle<TypeElement> te, long crc) {
            this.result.add(Pair.of(te, crc));
            String binName = te.getBinaryName();
            if (OBJECT.equals(binName)) {
                this.preBuildArgsState = (byte)(this.preBuildArgsState | 1);
            } else if (JCOMPONENT.equals(binName)) {
                this.preBuildArgsState = (byte)(this.preBuildArgsState | 2);
            }
        }

        protected final void markChanged() {
            this.changed = true;
        }

        public final Result execute() throws IOException {
            return this.doExecute();
        }

        public final List<Pair<ElementHandle<TypeElement>, Long>> finish() throws IOException {
            this.doFinish();
            Collections.sort(this.result, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Pair p1 = (Pair)o1;
                    Pair p2 = (Pair)o2;
                    return ((ElementHandle)p1.first).getBinaryName().compareTo(((ElementHandle)p2.first).getBinaryName());
                }
            });
            return this.result;
        }

        public final boolean hasChanges() {
            return this.changed;
        }

        public final boolean preBuildArgs() {
            return this.preBuildArgsState == 3;
        }
    }

    private class DeletedContinuation
    extends Continuation {
        public DeletedContinuation() throws IOException {
            Pair ts = BinaryAnalyser.this.getTimeStamps();
            if (!((LongHashMap)ts.first).isEmpty()) {
                this.markChanged();
            }
        }

        @Override
        protected Result doExecute() throws IOException {
            if (this.hasChanges()) {
                BinaryAnalyser.this.writer.clear();
            }
            return Result.FINISHED;
        }

        @Override
        protected void doFinish() throws IOException {
        }
    }

    private class FileObjectContinuation
    extends Continuation {
        private final Enumeration<? extends FileObject> todo;
        private final FileObject root;
        private final Context ctx;

        public FileObjectContinuation(@NonNull Enumeration<? extends FileObject> todo, @NonNull FileObject root, Context ctx) {
            assert (todo != null);
            assert (ctx != null);
            this.todo = todo;
            this.root = root;
            this.ctx = ctx;
            this.markChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Result doExecute() throws IOException {
            while (this.todo.hasMoreElements()) {
                FileObject fo = this.todo.nextElement();
                if (BinaryAnalyser.this.accepts(fo.getName())) {
                    String rp = FileObjects.stripExtension(FileUtil.getRelativePath((FileObject)this.root, (FileObject)fo));
                    BinaryAnalyser.this.cont.report(ElementHandle.createTypeElementHandle(ElementKind.CLASS, FileObjects.convertFolder2Package(rp)), 0L);
                    BufferedInputStream in = new BufferedInputStream(fo.getInputStream());
                    try {
                        BinaryAnalyser.this.analyse(in);
                    }
                    catch (InvalidClassFormatException icf) {
                        LOGGER.log(Level.WARNING, "Invalid class file format: {0}", FileUtil.getFileDisplayName((FileObject)fo));
                    }
                    finally {
                        ((InputStream)in).close();
                    }
                    if (BinaryAnalyser.this.lmListener.isLowMemory()) {
                        BinaryAnalyser.this.flush();
                    }
                }
                if (!this.ctx.isCancelled()) continue;
                return Result.CLOSED;
            }
            return Result.FINISHED;
        }

        @Override
        public void doFinish() throws IOException {
        }
    }

    private class FolderContinuation
    extends Continuation {
        private final LinkedList<File> todo;
        private final String rootPath;
        private final Context ctx;

        public FolderContinuation(@NonNull LinkedList<File> todo, @NonNull String rootPath, Context ctx) {
            assert (todo != null);
            assert (rootPath != null);
            assert (ctx != null);
            this.todo = todo;
            this.rootPath = rootPath;
            this.ctx = ctx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Result doExecute() throws IOException {
            while (!this.todo.isEmpty()) {
                File file = this.todo.removeFirst();
                if (file.isDirectory()) {
                    File[] c = file.listFiles();
                    if (c != null) {
                        this.todo.addAll(Arrays.asList(c));
                    }
                } else if (BinaryAnalyser.this.accepts(file.getName())) {
                    int slashIndex;
                    String filePath = file.getAbsolutePath();
                    long fileMTime = file.lastModified();
                    int dotIndex = filePath.lastIndexOf(46);
                    int endPos = dotIndex > (slashIndex = filePath.lastIndexOf(47)) ? dotIndex : filePath.length();
                    String relativePath = FileObjects.convertFolder2Package(filePath.substring(this.rootPath.length(), endPos));
                    BinaryAnalyser.this.cont.report(ElementHandle.createTypeElementHandle(ElementKind.CLASS, relativePath), fileMTime);
                    if (!BinaryAnalyser.this.isUpToDate(relativePath, fileMTime)) {
                        this.markChanged();
                        BinaryAnalyser.this.toDelete.add(Pair.of(relativePath, null));
                        try {
                            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
                            try {
                                BinaryAnalyser.this.analyse(in);
                            }
                            catch (InvalidClassFormatException icf) {
                                LOGGER.log(Level.WARNING, "Invalid class file format: {0}", file.getAbsolutePath());
                            }
                            finally {
                                ((InputStream)in).close();
                            }
                        }
                        catch (IOException ex) {
                            LOGGER.log(Level.WARNING, "Cannot read file: {0}", file.getAbsolutePath());
                            LOGGER.log(Level.FINE, null, ex);
                        }
                        if (BinaryAnalyser.this.lmListener.isLowMemory()) {
                            BinaryAnalyser.this.flush();
                        }
                    }
                }
                if (!this.ctx.isCancelled()) continue;
                return Result.CLOSED;
            }
            return Result.FINISHED;
        }

        @Override
        public void doFinish() throws IOException {
        }
    }

    public static enum Result {
        FINISHED,
        CANCELED,
        CLOSED;

    }

    private class ZipContinuation
    extends Continuation {
        private final ZipFile zipFile;
        private final Enumeration<? extends ZipEntry> entries;
        private final Context ctx;

        public ZipContinuation(@NonNull ZipFile zipFile, @NonNull Enumeration<? extends ZipEntry> entries, Context ctx) {
            assert (zipFile != null);
            assert (entries != null);
            assert (ctx != null);
            this.zipFile = zipFile;
            this.entries = entries;
            this.ctx = ctx;
            this.markChanged();
        }

        @Override
        protected Result doExecute() throws IOException {
            while (this.entries.hasMoreElements()) {
                ZipEntry ze;
                try {
                    ze = this.entries.nextElement();
                }
                catch (InternalError err) {
                    LOGGER.log(Level.INFO, "Broken zip file: " + this.zipFile.getName(), err);
                    return Result.FINISHED;
                }
                if (!ze.isDirectory() && BinaryAnalyser.this.accepts(ze.getName())) {
                    BinaryAnalyser.this.cont.report(ElementHandle.createTypeElementHandle(ElementKind.CLASS, FileObjects.convertFolder2Package(FileObjects.stripExtension(ze.getName()))), ze.getCrc());
                    BufferedInputStream in = new BufferedInputStream(this.zipFile.getInputStream(ze));
                    try {
                        BinaryAnalyser.this.analyse(in);
                    }
                    catch (InvalidClassFormatException icf) {
                        LOGGER.log(Level.WARNING, "Invalid class file format: {0}!/{1}", new Object[]{Utilities.toURI((File)new File(this.zipFile.getName())), ze.getName()});
                    }
                    catch (IOException x) {
                        Exceptions.attachMessage((Throwable)x, (String)("While scanning: " + ze.getName()));
                        throw x;
                    }
                    finally {
                        ((InputStream)in).close();
                    }
                    if (BinaryAnalyser.this.lmListener.isLowMemory()) {
                        BinaryAnalyser.this.flush();
                    }
                }
                if (!this.ctx.isCancelled()) continue;
                return Result.CLOSED;
            }
            return Result.FINISHED;
        }

        @Override
        protected void doFinish() throws IOException {
            this.zipFile.close();
        }
    }
}

