/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.indexing;

import java.io.IOException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.parsing.FileManagerTransaction;
import org.netbeans.modules.java.source.parsing.ProcessorGenerated;
import org.netbeans.modules.java.source.usages.ClassIndexEventsTransaction;
import org.netbeans.modules.java.source.usages.PersistentIndexTransaction;

public final class TransactionContext {
    private static final ThreadLocal<TransactionContext> ctx = new ThreadLocal();
    private final Map<Class<? extends Service>, Service> services = new LinkedHashMap<Class<? extends Service>, Service>();

    private TransactionContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commit() throws IOException, IllegalStateException {
        if (ctx.get() != this) {
            throw new IllegalStateException();
        }
        try {
            Throwable cause = null;
            for (Service s : this.services.values()) {
                try {
                    s.commit();
                }
                catch (Throwable t) {
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    if (cause != null) continue;
                    cause = t;
                }
            }
            if (cause != null) {
                throw new IOException(cause);
            }
        }
        finally {
            this.services.clear();
            ctx.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rollBack() throws IOException, IllegalStateException {
        if (ctx.get() != this) {
            throw new IllegalStateException();
        }
        try {
            Throwable cause = null;
            for (Service s : this.services.values()) {
                try {
                    s.rollBack();
                }
                catch (Throwable t) {
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    if (cause != null) continue;
                    cause = t;
                }
            }
            if (cause != null) {
                throw new IOException(cause);
            }
        }
        finally {
            this.services.clear();
            ctx.remove();
        }
    }

    public TransactionContext register(@NonNull Class<? extends Service> type, @NonNull Service service) throws IllegalStateException {
        assert (type != null);
        assert (service != null);
        if (this.services.containsKey(type)) {
            throw new IllegalStateException("Service already registered.");
        }
        this.services.put(type, service);
        return this;
    }

    @CheckForNull
    public <T extends Service> T get(@NonNull Class<T> type) {
        return (T)this.services.get(type);
    }

    @NonNull
    public static TransactionContext beginTrans() throws IllegalStateException {
        if (ctx.get() != null) {
            throw new IllegalStateException();
        }
        TransactionContext res = new TransactionContext();
        ctx.set(res);
        return res;
    }

    @NonNull
    public static TransactionContext get() throws IllegalStateException {
        TransactionContext res = ctx.get();
        if (res == null) {
            throw new IllegalStateException();
        }
        return res;
    }

    public static TransactionContext beginStandardTransaction(boolean srcIndex, URL root) throws IllegalStateException {
        boolean hasCache = srcIndex ? JavaIndex.hasSourceCache(root, false) : JavaIndex.hasBinaryCache(root, false);
        return TransactionContext.beginTrans().register(FileManagerTransaction.class, hasCache ? FileManagerTransaction.writeBack(root) : FileManagerTransaction.writeThrough()).register(ProcessorGenerated.class, ProcessorGenerated.create()).register(PersistentIndexTransaction.class, PersistentIndexTransaction.create()).register(ClassIndexEventsTransaction.class, ClassIndexEventsTransaction.create(srcIndex));
    }

    public static abstract class Service {
        protected abstract void commit() throws IOException;

        protected abstract void rollBack() throws IOException;
    }
}

