/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.indexing;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.parsing.impl.indexing.CacheFolder;
import org.netbeans.modules.parsing.impl.indexing.SPIAccessor;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Utilities;

public final class JavaIndex {
    public static final String NAME = "java";
    public static final int VERSION = 14;
    static final Logger LOG = Logger.getLogger(JavaIndex.class.getName());
    private static final String CLASSES = "classes";
    private static final String APT_SOURCES = "sources";
    private static final String ATTR_FILE_NAME = "attributes.properties";
    private static final Object cacheLock = new Object();
    private static URL cacheRoot;
    private static Reference<Properties> cacheValue;

    public static File getIndex(Context c) {
        return FileUtil.toFile((FileObject)c.getIndexFolder());
    }

    public static File getIndex(URL url) throws IOException {
        FileObject indexBaseFolder = CacheFolder.getDataFolder((URL)url);
        String path = SPIAccessor.getInstance().getIndexerPath(NAME, 14);
        FileObject indexFolder = FileUtil.createFolder((FileObject)indexBaseFolder, (String)path);
        return FileUtil.toFile((FileObject)indexFolder);
    }

    public static File getClassFolder(Context c) {
        return JavaIndex.getClassFolder(c, false);
    }

    public static File getClassFolder(Context c, boolean onlyIfExists) {
        return JavaIndex.processCandidate(new File(JavaIndex.getIndex(c), CLASSES), onlyIfExists, true);
    }

    public static File getClassFolder(File root) throws IOException {
        return JavaIndex.getClassFolder(Utilities.toURI((File)root).toURL());
    }

    public static File getClassFolder(URL url) throws IOException {
        return JavaIndex.getClassFolder(url, false, true);
    }

    public static File getClassFolder(URL url, boolean onlyIfExists) throws IOException {
        return JavaIndex.getClassFolder(url, onlyIfExists, true);
    }

    public static File getClassFolder(URL url, boolean onlyIfExists, boolean create) throws IOException {
        return JavaIndex.processCandidate(new File(JavaIndex.getIndex(url), CLASSES), onlyIfExists, create);
    }

    public static File getAptFolder(URL sourceRoot, boolean create) throws IOException {
        File aptSources = new File(JavaIndex.getIndex(sourceRoot), APT_SOURCES);
        if (create) {
            aptSources.mkdirs();
        }
        return aptSources;
    }

    public static URL getSourceRootForClassFolder(URL binaryRoot) {
        FileObject folder = URLMapper.findFileObject((URL)binaryRoot);
        if (folder == null || !CLASSES.equals(folder.getName())) {
            return null;
        }
        if ((folder = folder.getParent()) == null || !String.valueOf(14).equals(folder.getName())) {
            return null;
        }
        if ((folder = folder.getParent()) == null || !NAME.equals(folder.getName())) {
            return null;
        }
        if ((folder = folder.getParent()) == null) {
            return null;
        }
        return CacheFolder.getSourceRootForDataFolder((FileObject)folder);
    }

    public static boolean ensureAttributeValue(URL root, String attributeName, String attributeValue) throws IOException {
        return JavaIndex.ensureAttributeValue(root, attributeName, attributeValue, false);
    }

    public static boolean ensureAttributeValue(URL root, String attributeName, String attributeValue, boolean checkOnly) throws IOException {
        Properties p = JavaIndex.loadProperties(root);
        String current = p.getProperty(attributeName);
        if (current == null) {
            if (attributeValue != null) {
                if (!checkOnly) {
                    p.setProperty(attributeName, attributeValue);
                    JavaIndex.storeProperties(root, p);
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "ensureAttributeValue attr: {0} current: {1} new: {2} checkOnly: {3}", new Object[]{attributeName, current, attributeValue, checkOnly});
                }
                return true;
            }
            return false;
        }
        if (current.equals(attributeValue)) {
            return false;
        }
        if (!checkOnly) {
            if (attributeValue != null) {
                p.setProperty(attributeName, attributeValue);
            } else {
                p.remove(attributeName);
            }
            JavaIndex.storeProperties(root, p);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "ensureAttributeValue attr: {0} current: {1} new: {2} checkOnly: {3}", new Object[]{attributeName, current, attributeValue, checkOnly});
        }
        return true;
    }

    public static void setAttribute(URL root, String attributeName, String attributeValue) throws IOException {
        Properties p = JavaIndex.loadProperties(root);
        if (attributeValue != null) {
            p.setProperty(attributeName, attributeValue);
        } else {
            p.remove(attributeName);
        }
        JavaIndex.storeProperties(root, p);
    }

    public static String getAttribute(URL root, String attributeName, String defaultValue) throws IOException {
        Properties p = JavaIndex.loadProperties(root);
        return p.getProperty(attributeName, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(URL root) throws IOException {
        Object object = cacheLock;
        synchronized (object) {
            Properties result;
            if (cacheRoot != null && cacheRoot.equals(root)) {
                Properties properties = result = cacheValue == null ? null : cacheValue.get();
                if (result != null) {
                    return result;
                }
            }
            File f = JavaIndex.getAttributeFile(root);
            result = new Properties();
            if (!f.exists()) {
                return result;
            }
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
            try {
                result.load(in);
            }
            catch (IllegalArgumentException iae) {
                LOG.log(Level.WARNING, "Broken attribute file: {0}", f.getAbsolutePath());
                result = new Properties();
            }
            finally {
                ((InputStream)in).close();
            }
            cacheRoot = root;
            cacheValue = new SoftReference<Properties>(result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeProperties(URL root, Properties p) throws IOException {
        Object object = cacheLock;
        synchronized (object) {
            File f = JavaIndex.getAttributeFile(root);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
            try {
                p.store(out, "");
            }
            finally {
                ((OutputStream)out).close();
            }
            cacheRoot = root;
            cacheValue = new SoftReference<Properties>(p);
        }
    }

    private static File getAttributeFile(URL root) throws IOException {
        return new File(JavaIndex.getIndex(root), ATTR_FILE_NAME);
    }

    private static File processCandidate(File result, boolean onlyIfExists, boolean create) {
        if (onlyIfExists) {
            if (!result.exists()) {
                return null;
            }
            return result;
        }
        if (create) {
            result.mkdirs();
        }
        return result;
    }

    public static boolean hasSourceCache(@NonNull URL root, boolean testForInitialized) {
        assert (root != null);
        ClassIndexImpl uq = ClassIndexManager.getDefault().getUsagesQuery(root, !testForInitialized);
        return uq != null && (!testForInitialized || uq.getState() == ClassIndexImpl.State.INITIALIZED) && uq.getType() == ClassIndexImpl.Type.SOURCE;
    }

    public static boolean hasBinaryCache(@NonNull URL root, boolean testForInitialized) {
        assert (root != null);
        ClassIndexImpl uq = ClassIndexManager.getDefault().getUsagesQuery(root, !testForInitialized);
        return uq != null && (!testForInitialized || uq.getState() == ClassIndexImpl.State.INITIALIZED) && uq.getType() == ClassIndexImpl.Type.BINARY;
    }

    public static boolean isIndexed(@NonNull URL root) {
        return ClassIndexManager.getDefault().getUsagesQuery(root, false) != null;
    }

    private JavaIndex() {
    }
}

