/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.source.builder.CommentHandlerService;

class TranslateIdentifier
implements TreeVisitor<Tree, Boolean> {
    @NonNull
    private final CompilationInfo info;
    @NonNull
    private final TreeMaker make;
    @NullAllowed
    private final CompilationUnitTree unit;
    private final CommentHandlerService commentService;
    private Element rootElement;

    public TranslateIdentifier(@NonNull WorkingCopy copy) {
        this.info = copy;
        this.make = copy.getTreeMaker();
        this.unit = copy.getFileObject() != null ? copy.getCompilationUnit() : null;
        this.commentService = CommentHandlerService.instance(this.info.impl.getJavacTask().getContext());
    }

    @Override
    public Tree visitAnnotation(AnnotationTree node, Boolean p) {
        Tree annotationType = this.translateTree(node.getAnnotationType());
        List<? extends ExpressionTree> arguments = this.translateTree(node.getArguments());
        if (this.make == null) {
            return node;
        }
        if (annotationType != node.getAnnotationType() || arguments != node.getArguments()) {
            node = this.make.Annotation(annotationType, arguments);
        }
        return node;
    }

    @Override
    public Tree visitMethodInvocation(MethodInvocationTree node, Boolean p) {
        List<? extends ExpressionTree> arguments = this.translateTree(node.getArguments());
        ExpressionTree methodSelect = (ExpressionTree)this.translateTree(node.getMethodSelect());
        List<? extends Tree> typeArguments = this.translateTree(node.getTypeArguments());
        if (this.make == null) {
            return node;
        }
        if (arguments != node.getArguments() || methodSelect != node.getMethodSelect() || typeArguments != node.getTypeArguments()) {
            node = this.make.MethodInvocation(typeArguments, methodSelect, arguments);
        }
        return node;
    }

    @Override
    public Tree visitAssert(AssertTree node, Boolean p) {
        ExpressionTree condition = (ExpressionTree)this.translateTree(node.getCondition());
        ExpressionTree detail = (ExpressionTree)this.translateTree(node.getDetail());
        if (this.make == null) {
            return node;
        }
        if (condition != node.getCondition() || detail != node.getDetail()) {
            node = this.make.Assert(condition, detail);
        }
        return node;
    }

    @Override
    public Tree visitAssignment(AssignmentTree node, Boolean p) {
        ExpressionTree expression = (ExpressionTree)this.translateTree(node.getExpression());
        ExpressionTree variable = (ExpressionTree)this.translateTree(node.getVariable());
        if (this.make == null) {
            return node;
        }
        if (expression != node.getExpression() || variable != node.getVariable()) {
            node = this.make.Assignment(variable, expression);
        }
        return node;
    }

    @Override
    public Tree visitCompoundAssignment(CompoundAssignmentTree node, Boolean p) {
        ExpressionTree expression = (ExpressionTree)this.translateTree(node.getExpression());
        ExpressionTree variable = (ExpressionTree)this.translateTree(node.getVariable());
        if (this.make == null) {
            return node;
        }
        if (expression != node.getExpression() || variable != node.getVariable()) {
            node = this.make.CompoundAssignment(node.getKind(), variable, expression);
        }
        return node;
    }

    @Override
    public Tree visitBinary(BinaryTree node, Boolean p) {
        ExpressionTree leftOperand = (ExpressionTree)this.translateTree(node.getLeftOperand());
        ExpressionTree rightOperand = (ExpressionTree)this.translateTree(node.getRightOperand());
        if (this.make == null) {
            return node;
        }
        if (leftOperand != node.getLeftOperand() || rightOperand != node.getRightOperand()) {
            node = this.make.Binary(node.getKind(), leftOperand, rightOperand);
        }
        return node;
    }

    @Override
    public Tree visitBlock(BlockTree node, Boolean p) {
        List<? extends StatementTree> statements = this.translateTree(node.getStatements());
        if (this.make == null) {
            return node;
        }
        if (statements != node.getStatements()) {
            node = this.make.Block(statements, node.isStatic());
        }
        return node;
    }

    @Override
    public Tree visitBreak(BreakTree node, Boolean p) {
        return node;
    }

    @Override
    public Tree visitCase(CaseTree node, Boolean p) {
        ExpressionTree expression = (ExpressionTree)this.translateTree(node.getExpression(), true);
        List<? extends StatementTree> statements = this.translateTree(node.getStatements());
        if (this.make == null) {
            return node;
        }
        if (expression != node.getExpression() || statements != node.getStatements()) {
            node = this.make.Case(expression, statements);
        }
        return node;
    }

    @Override
    public Tree visitCatch(CatchTree node, Boolean p) {
        BlockTree block = (BlockTree)this.translateTree(node.getBlock());
        VariableTree parameter = (VariableTree)this.translateTree(node.getParameter());
        if (this.make == null) {
            return node;
        }
        if (block != node.getBlock() || parameter != node.getParameter()) {
            node = this.make.Catch(parameter, block);
        }
        return node;
    }

    @Override
    public Tree visitClass(ClassTree node, Boolean p) {
        Tree extendsClause = this.translateTree(node.getExtendsClause());
        List<? extends Tree> implementsClause = this.translateTree(node.getImplementsClause());
        List<? extends Tree> members = this.translateTree(node.getMembers());
        ModifiersTree modifiers = (ModifiersTree)this.translateTree(node.getModifiers());
        List<? extends TypeParameterTree> typeParameters = this.translateTree(node.getTypeParameters());
        if (this.make == null) {
            return node;
        }
        if (extendsClause != node.getExtendsClause() || implementsClause != node.getImplementsClause() || members != node.getMembers() || modifiers != node.getModifiers() || typeParameters != node.getTypeParameters()) {
            node = this.make.Class(modifiers, node.getSimpleName(), typeParameters, extendsClause, implementsClause, members);
        }
        return node;
    }

    @Override
    public Tree visitConditionalExpression(ConditionalExpressionTree node, Boolean p) {
        ExpressionTree condition = (ExpressionTree)this.translateTree(node.getCondition());
        ExpressionTree falseExpression = (ExpressionTree)this.translateTree(node.getFalseExpression());
        ExpressionTree trueExpression = (ExpressionTree)this.translateTree(node.getTrueExpression());
        if (this.make == null) {
            return node;
        }
        if (condition != node.getCondition() || falseExpression != node.getFalseExpression() || trueExpression != node.getTrueExpression()) {
            node = this.make.ConditionalExpression(condition, trueExpression, falseExpression);
        }
        return node;
    }

    @Override
    public Tree visitContinue(ContinueTree node, Boolean p) {
        return node;
    }

    @Override
    public Tree visitUnionType(UnionTypeTree node, Boolean p) {
        List<? extends Tree> typeComponents = this.translateTree(node.getTypeAlternatives());
        if (this.make == null) {
            return node;
        }
        if (typeComponents != node.getTypeAlternatives()) {
            node = this.make.UnionType(typeComponents);
        }
        return node;
    }

    @Override
    public Tree visitDoWhileLoop(DoWhileLoopTree node, Boolean p) {
        StatementTree statement = (StatementTree)this.translateTree(node.getStatement());
        ExpressionTree condition = (ExpressionTree)this.translateTree(node.getCondition());
        if (this.make == null) {
            return node;
        }
        if (condition != node.getCondition() || statement != node.getStatement()) {
            node = this.make.DoWhileLoop(condition, statement);
        }
        return node;
    }

    @Override
    public Tree visitErroneous(ErroneousTree node, Boolean p) {
        List<? extends Tree> errorTrees = this.translateTree(node.getErrorTrees());
        if (this.make == null) {
            return node;
        }
        if (errorTrees != node.getErrorTrees()) {
            node = this.make.Erroneous(errorTrees);
        }
        return node;
    }

    @Override
    public Tree visitExpressionStatement(ExpressionStatementTree node, Boolean p) {
        ExpressionTree expression = (ExpressionTree)this.translateTree(node.getExpression());
        if (this.make == null) {
            return node;
        }
        if (expression != node.getExpression()) {
            node = this.make.ExpressionStatement(expression);
        }
        return node;
    }

    @Override
    public Tree visitEnhancedForLoop(EnhancedForLoopTree node, Boolean p) {
        StatementTree statement = (StatementTree)this.translateTree(node.getStatement());
        ExpressionTree expression = (ExpressionTree)this.translateTree(node.getExpression());
        VariableTree variable = (VariableTree)this.translateTree(node.getVariable());
        if (this.make == null) {
            return node;
        }
        if (statement != node.getStatement() || expression != node.getExpression() || variable != node.getVariable()) {
            node = this.make.EnhancedForLoop(variable, expression, statement);
        }
        return node;
    }

    @Override
    public Tree visitForLoop(ForLoopTree node, Boolean p) {
        StatementTree statement = (StatementTree)this.translateTree(node.getStatement());
        ExpressionTree condition = (ExpressionTree)this.translateTree(node.getCondition());
        List<? extends StatementTree> initializer = this.translateTree(node.getInitializer());
        List<? extends ExpressionStatementTree> update = this.translateTree(node.getUpdate());
        if (this.make == null) {
            return node;
        }
        if (statement != node.getStatement() || condition != node.getCondition() || initializer != node.getInitializer() || update != node.getUpdate()) {
            node = this.make.ForLoop(initializer, condition, update, statement);
        }
        return node;
    }

    @Override
    public Tree visitIdentifier(IdentifierTree node, Boolean p) {
        if (this.make == null) {
            return node;
        }
        TreePath path = this.unit != null ? this.info.getTrees().getPath(this.unit, node) : null;
        Element element = path == null ? ((JCTree.JCIdent)node).sym : this.info.getTrees().getElement(path);
        if (element != null && (element.getKind().isClass() || element.getKind().isInterface() || element.getKind().isField() && ((Symbol)element).isStatic())) {
            boolean en;
            boolean bl = en = p == Boolean.TRUE && element.getKind() == ElementKind.ENUM_CONSTANT;
            if (path == null && element == this.rootElement || path != null && path.getCompilationUnit().getSourceFile() == ((Symbol)element).enclClass().sourcefile || en) {
                return this.make.Identifier(element.getSimpleName());
            }
            return this.make.QualIdent(element);
        }
        return node;
    }

    @Override
    public Tree visitIf(IfTree node, Boolean p) {
        ExpressionTree condition = (ExpressionTree)this.translateTree(node.getCondition());
        StatementTree elseStatement = (StatementTree)this.translateTree(node.getElseStatement());
        StatementTree thenStatement = (StatementTree)this.translateTree(node.getThenStatement());
        if (this.make == null) {
            return node;
        }
        if (condition != node.getCondition() || elseStatement != node.getElseStatement() || thenStatement != node.getThenStatement()) {
            node = this.make.If(condition, thenStatement, elseStatement);
        }
        return node;
    }

    @Override
    public Tree visitImport(ImportTree node, Boolean p) {
        return node;
    }

    @Override
    public Tree visitArrayAccess(ArrayAccessTree node, Boolean p) {
        ExpressionTree expression = (ExpressionTree)this.translateTree(node.getExpression());
        ExpressionTree index = (ExpressionTree)this.translateTree(node.getIndex());
        if (this.make == null) {
            return node;
        }
        if (expression != node.getExpression() || index != node.getIndex()) {
            node = this.make.ArrayAccess(expression, index);
        }
        return node;
    }

    @Override
    public Tree visitLabeledStatement(LabeledStatementTree node, Boolean p) {
        StatementTree statement = (StatementTree)this.translateTree(node.getStatement());
        if (this.make == null) {
            return node;
        }
        if (statement != node.getStatement()) {
            node = this.make.LabeledStatement(node.getLabel(), statement);
        }
        return node;
    }

    @Override
    public Tree visitLiteral(LiteralTree node, Boolean p) {
        return node;
    }

    @Override
    public Tree visitMethod(MethodTree node, Boolean p) {
        if (this.unit != null && this.info.getTreeUtilities().isSynthetic(this.unit, node)) {
            return node;
        }
        BlockTree body = (BlockTree)this.translateTree(node.getBody());
        Tree defaultValue = this.translateTree(node.getDefaultValue());
        List<? extends VariableTree> parameters = this.translateTree(node.getParameters());
        ModifiersTree modifiers = (ModifiersTree)this.translateTree(node.getModifiers());
        Tree returnType = this.translateTree(node.getReturnType());
        List<? extends ExpressionTree> aThrows = this.translateTree(node.getThrows());
        List<? extends TypeParameterTree> typeParameters = this.translateTree(node.getTypeParameters());
        if (this.make == null) {
            return node;
        }
        if (body != node.getBody() || defaultValue != node.getDefaultValue() || parameters != node.getParameters() || modifiers != node.getModifiers() || returnType != node.getReturnType() || aThrows != node.getThrows() || typeParameters != node.getTypeParameters()) {
            node = this.make.Method(modifiers, (CharSequence)node.getName(), returnType, typeParameters, parameters, aThrows, body, (ExpressionTree)defaultValue);
        }
        return node;
    }

    @Override
    public Tree visitModifiers(ModifiersTree node, Boolean p) {
        List<? extends AnnotationTree> annotations = this.translateTree(node.getAnnotations());
        if (this.make == null) {
            return node;
        }
        if (annotations != node.getAnnotations()) {
            node = this.make.Modifiers(node.getFlags(), annotations);
        }
        return node;
    }

    @Override
    public Tree visitNewArray(NewArrayTree node, Boolean p) {
        List<? extends ExpressionTree> initializers = this.translateTree(node.getInitializers());
        List<? extends ExpressionTree> dimensions = this.translateTree(node.getDimensions());
        Tree type = this.translateTree(node.getType());
        if (this.make == null) {
            return node;
        }
        if (initializers != node.getInitializers() || dimensions != node.getDimensions() || type != node.getType()) {
            node = this.make.NewArray(type, dimensions, initializers);
        }
        return node;
    }

    @Override
    public Tree visitNewClass(NewClassTree node, Boolean p) {
        List<? extends ExpressionTree> arguments = this.translateTree(node.getArguments());
        ClassTree classBody = (ClassTree)this.translateTree(node.getClassBody());
        ExpressionTree enclosingExpression = (ExpressionTree)this.translateTree(node.getEnclosingExpression());
        ExpressionTree identifier = (ExpressionTree)this.translateTree(node.getIdentifier());
        List<? extends Tree> typeArguments = this.translateTree(node.getTypeArguments());
        if (this.make == null) {
            return node;
        }
        if (arguments != node.getArguments() || classBody != node.getClassBody() || enclosingExpression != node.getEnclosingExpression() || identifier != node.getIdentifier() || typeArguments != node.getTypeArguments()) {
            node = this.make.NewClass(enclosingExpression, typeArguments, identifier, arguments, classBody);
        }
        return node;
    }

    @Override
    public Tree visitParenthesized(ParenthesizedTree node, Boolean p) {
        ExpressionTree expression = (ExpressionTree)this.translateTree(node.getExpression());
        if (this.make == null) {
            return node;
        }
        if (expression != node.getExpression()) {
            node = this.make.Parenthesized(expression);
        }
        return node;
    }

    @Override
    public Tree visitReturn(ReturnTree node, Boolean p) {
        ExpressionTree expression = (ExpressionTree)this.translateTree(node.getExpression());
        if (this.make == null) {
            return node;
        }
        if (expression != node.getExpression()) {
            node = this.make.Return(expression);
        }
        return node;
    }

    @Override
    public Tree visitMemberSelect(MemberSelectTree node, Boolean p) {
        if (this.make == null) {
            return node;
        }
        TypeElement e = this.info.getElements().getTypeElement(node.toString());
        if (e != null) {
            return this.make.QualIdent(e);
        }
        ExpressionTree expression = (ExpressionTree)this.translateTree(node.getExpression());
        if (expression != node.getExpression()) {
            node = this.make.MemberSelect(expression, node.getIdentifier());
        }
        return node;
    }

    @Override
    public Tree visitEmptyStatement(EmptyStatementTree node, Boolean p) {
        return node;
    }

    @Override
    public Tree visitSwitch(SwitchTree node, Boolean p) {
        List<? extends CaseTree> cases = this.translateTree(node.getCases());
        ExpressionTree expression = (ExpressionTree)this.translateTree(node.getExpression());
        if (this.make == null) {
            return node;
        }
        if (cases != node.getCases() || expression != node.getExpression()) {
            node = this.make.Switch(expression, cases);
        }
        return node;
    }

    @Override
    public Tree visitSynchronized(SynchronizedTree node, Boolean p) {
        BlockTree block = (BlockTree)this.translateTree(node.getBlock());
        ExpressionTree expression = (ExpressionTree)this.translateTree(node.getExpression());
        if (this.make == null) {
            return node;
        }
        if (block != node.getBlock() || expression != node.getExpression()) {
            node = this.make.Synchronized(expression, block);
        }
        return node;
    }

    @Override
    public Tree visitThrow(ThrowTree node, Boolean p) {
        ExpressionTree expression = (ExpressionTree)this.translateTree(node.getExpression());
        if (this.make == null) {
            return node;
        }
        if (expression != node.getExpression()) {
            node = this.make.Throw(expression);
        }
        return node;
    }

    @Override
    public Tree visitCompilationUnit(CompilationUnitTree node, Boolean p) {
        List<? extends Tree> typeDecls = this.translateTree(node.getTypeDecls());
        if (this.make == null) {
            return node;
        }
        if (typeDecls != node.getTypeDecls()) {
            node = this.make.CompilationUnit(node.getPackageAnnotations(), node.getPackageName(), node.getImports(), typeDecls, node.getSourceFile());
        }
        return node;
    }

    @Override
    public Tree visitTry(TryTree node, Boolean p) {
        List<? extends Tree> resources = this.translateTree(node.getResources());
        BlockTree block = (BlockTree)this.translateTree(node.getBlock());
        List<? extends CatchTree> catches = this.translateTree(node.getCatches());
        BlockTree finallyBlock = (BlockTree)this.translateTree(node.getFinallyBlock());
        if (this.make == null) {
            return node;
        }
        if (resources != node.getResources() || block != node.getBlock() || catches != node.getCatches() || finallyBlock != node.getFinallyBlock()) {
            node = this.make.Try(block, catches, finallyBlock);
        }
        return node;
    }

    @Override
    public Tree visitParameterizedType(ParameterizedTypeTree node, Boolean p) {
        Tree type = this.translateTree(node.getType());
        List<? extends Tree> typeArguments = this.translateTree(node.getTypeArguments());
        if (this.make == null) {
            return node;
        }
        if (type != node.getType() || typeArguments != node.getTypeArguments()) {
            node = this.make.ParameterizedType(type, typeArguments);
        }
        return node;
    }

    @Override
    public Tree visitArrayType(ArrayTypeTree node, Boolean p) {
        Tree type = this.translateTree(node.getType());
        if (this.make == null) {
            return node;
        }
        if (type != node.getType()) {
            node = this.make.ArrayType(type);
        }
        return node;
    }

    @Override
    public Tree visitTypeCast(TypeCastTree node, Boolean p) {
        ExpressionTree expression = (ExpressionTree)this.translateTree(node.getExpression());
        Tree type = this.translateTree(node.getType());
        if (this.make == null) {
            return node;
        }
        if (expression != node.getExpression() || type != node.getType()) {
            node = this.make.TypeCast(type, expression);
        }
        return node;
    }

    @Override
    public Tree visitPrimitiveType(PrimitiveTypeTree node, Boolean p) {
        return node;
    }

    @Override
    public Tree visitTypeParameter(TypeParameterTree node, Boolean p) {
        List<? extends Tree> bounds = this.translateTree(node.getBounds());
        if (this.make == null) {
            return node;
        }
        if (bounds != node.getBounds()) {
            node = this.make.TypeParameter(node.getName(), bounds);
        }
        return node;
    }

    @Override
    public Tree visitInstanceOf(InstanceOfTree node, Boolean p) {
        ExpressionTree expression = (ExpressionTree)this.translateTree(node.getExpression());
        Tree type = this.translateTree(node.getType());
        if (this.make == null) {
            return node;
        }
        if (expression != node.getExpression() || type != node.getType()) {
            node = this.make.InstanceOf(expression, type);
        }
        return node;
    }

    @Override
    public Tree visitUnary(UnaryTree node, Boolean p) {
        ExpressionTree expression = (ExpressionTree)this.translateTree(node.getExpression());
        if (this.make == null) {
            return node;
        }
        if (expression != node.getExpression()) {
            node = this.make.Unary(node.getKind(), expression);
        }
        return node;
    }

    @Override
    public Tree visitVariable(VariableTree node, Boolean p) {
        ModifiersTree modifiers = (ModifiersTree)this.translateTree(node.getModifiers());
        Tree type = this.translateTree(node.getType());
        ExpressionTree initializer = (ExpressionTree)this.translateTree(node.getInitializer());
        if (this.make == null) {
            return node;
        }
        if (modifiers != node.getModifiers() || type != node.getType() || initializer != node.getInitializer()) {
            node = this.make.Variable(modifiers, node.getName(), type, initializer);
        }
        return node;
    }

    @Override
    public Tree visitWhileLoop(WhileLoopTree node, Boolean p) {
        StatementTree statement = (StatementTree)this.translateTree(node.getStatement());
        ExpressionTree condition = (ExpressionTree)this.translateTree(node.getCondition());
        if (this.make == null) {
            return node;
        }
        if (condition != node.getCondition() || statement != node.getStatement()) {
            node = this.make.WhileLoop(condition, statement);
        }
        return node;
    }

    @Override
    public Tree visitWildcard(WildcardTree node, Boolean p) {
        Tree tree = this.translateTree(node.getBound());
        if (this.make == null) {
            return node;
        }
        if (tree != node.getBound()) {
            node = this.make.Wildcard(node.getKind(), tree);
        }
        return node;
    }

    @Override
    public Tree visitOther(Tree node, Boolean p) {
        return node;
    }

    public Tree translate(Tree tree) {
        TreePath path;
        if (tree == null) {
            return null;
        }
        TreePath treePath = path = this.unit != null ? this.info.getTrees().getPath(this.unit, tree) : null;
        if (path == null) {
            if (tree instanceof JCTree.JCClassDecl) {
                this.rootElement = ((JCTree.JCClassDecl)tree).sym;
            }
        } else {
            this.rootElement = this.info.getTrees().getElement(path);
        }
        Tree res = tree.accept(this, null);
        this.commentService.copyComments(tree, res);
        return res;
    }

    private <T extends Tree> List<T> translateTree(List<T> trees) {
        if (trees == null || trees.isEmpty()) {
            return trees;
        }
        ArrayList<Tree> newTrees = new ArrayList<Tree>();
        boolean changed = false;
        for (Tree t : trees) {
            Tree newT = this.translateTree(t);
            if (newT != t) {
                changed = true;
            }
            if (newT == null) continue;
            newTrees.add(newT);
        }
        return changed ? newTrees : trees;
    }

    private Tree translateTree(Tree tree) {
        return this.translateTree(tree, null);
    }

    private Tree translateTree(Tree tree, Boolean p) {
        if (tree == null) {
            return null;
        }
        Tree newTree = tree.accept(this, p);
        this.commentService.copyComments(tree, newTree);
        return newTree;
    }
}

