/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.typinghooks;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib2.typinghooks.TypingHooksSpiAccessor;
import org.netbeans.spi.editor.typinghooks.TypedTextInterceptor;

public final class TypedTextInterceptorsManager {
    private static final Logger LOG = Logger.getLogger(TypedTextInterceptorsManager.class.getName());
    private static TypedTextInterceptorsManager instance;
    private Transaction transaction = null;
    private final Map<MimePath, Reference<Collection<TypedTextInterceptor>>> cache = new WeakHashMap<MimePath, Reference<Collection<TypedTextInterceptor>>>();

    public static TypedTextInterceptorsManager getInstance() {
        if (instance == null) {
            instance = new TypedTextInterceptorsManager();
        }
        return instance;
    }

    public Transaction openTransaction(JTextComponent c, Position offset, String typedText) {
        TypedTextInterceptorsManager typedTextInterceptorsManager = this;
        synchronized (typedTextInterceptorsManager) {
            if (this.transaction == null) {
                this.transaction = new Transaction(c, offset, typedText);
                return this.transaction;
            }
            throw new IllegalStateException("Too many transactions; only one at a time is allowed!");
        }
    }

    private TypedTextInterceptorsManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<? extends TypedTextInterceptor> getInterceptors(Document doc, Position offset) {
        List seqs = TokenHierarchy.get((Document)doc).embeddedTokenSequences(offset.getOffset(), true);
        TokenSequence seq = seqs.isEmpty() ? null : (TokenSequence)seqs.get(seqs.size() - 1);
        seq = seq == null ? TokenHierarchy.get((Document)doc).tokenSequence() : seq;
        MimePath mimePath = seq == null ? MimePath.parse((String)DocumentUtilities.getMimeType((Document)doc)) : MimePath.parse((String)seq.languagePath().mimePath());
        Map<MimePath, Reference<Collection<TypedTextInterceptor>>> map = this.cache;
        synchronized (map) {
            Collection<TypedTextInterceptor> interceptors;
            Reference<Collection<TypedTextInterceptor>> ref = this.cache.get(mimePath);
            Collection<TypedTextInterceptor> collection = interceptors = ref == null ? null : ref.get();
            if (interceptors == null) {
                Collection factories = MimeLookup.getLookup((MimePath)mimePath).lookupAll(TypedTextInterceptor.Factory.class);
                interceptors = new HashSet<TypedTextInterceptor>(factories.size());
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "TypedTextInterceptor.Factory instances for {0}:", mimePath.getPath());
                }
                for (TypedTextInterceptor.Factory f : factories) {
                    TypedTextInterceptor interceptor = f.createTypedTextInterceptor(mimePath);
                    if (interceptor != null) {
                        interceptors.add(interceptor);
                    }
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.log(Level.FINE, "    {0} created: {1}", new Object[]{f, interceptor});
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("");
                }
                this.cache.put(mimePath, new SoftReference<Collection<TypedTextInterceptor>>(interceptors));
            }
            return interceptors;
        }
    }

    public final class Transaction {
        private final TypedTextInterceptor.MutableContext context;
        private final Collection<? extends TypedTextInterceptor> interceptors;
        private int phase = 0;

        public boolean beforeInsertion() {
            for (TypedTextInterceptor typedTextInterceptor : this.interceptors) {
                try {
                    if (!typedTextInterceptor.beforeInsert(this.context)) continue;
                    return true;
                }
                catch (Exception e) {
                    LOG.log(Level.INFO, "TypedTextInterceptor crashed in beforeInsert(): " + typedTextInterceptor, e);
                }
            }
            ++this.phase;
            return false;
        }

        public Object[] textTyped() {
            Object[] data = null;
            for (TypedTextInterceptor typedTextInterceptor : this.interceptors) {
                try {
                    typedTextInterceptor.insert(this.context);
                }
                catch (Exception e) {
                    LOG.log(Level.INFO, "TypedTextInterceptor crashed in insert(): " + typedTextInterceptor, e);
                    TypingHooksSpiAccessor.get().resetTtiContextData(this.context);
                    continue;
                }
                data = TypingHooksSpiAccessor.get().getTtiContextData(this.context);
                if (data == null) continue;
                break;
            }
            ++this.phase;
            return data;
        }

        public void afterInsertion() {
            for (TypedTextInterceptor typedTextInterceptor : this.interceptors) {
                try {
                    typedTextInterceptor.afterInsert(this.context);
                }
                catch (Exception e) {
                    LOG.log(Level.INFO, "TypedTextInterceptor crashed in afterInsert(): " + typedTextInterceptor, e);
                }
            }
            ++this.phase;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            if (this.phase < 3) {
                for (TypedTextInterceptor typedTextInterceptor : this.interceptors) {
                    try {
                        typedTextInterceptor.cancelled(this.context);
                    }
                    catch (Exception e) {
                        LOG.log(Level.INFO, "TypedTextInterceptor crashed in cancelled(): " + typedTextInterceptor, e);
                    }
                }
            }
            TypedTextInterceptorsManager typedTextInterceptorsManager = TypedTextInterceptorsManager.this;
            synchronized (typedTextInterceptorsManager) {
                TypedTextInterceptorsManager.this.transaction = null;
            }
        }

        private Transaction(JTextComponent c, Position offset, String typedText) {
            this.context = TypingHooksSpiAccessor.get().createTtiContext(c, offset, typedText);
            this.interceptors = TypedTextInterceptorsManager.this.getInterceptors(c.getDocument(), offset);
        }
    }
}

