/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.highlighting;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.editor.lib2.highlighting.BlockHighlighting;
import org.netbeans.modules.editor.lib2.search.EditorFindSupport;
import org.netbeans.spi.editor.highlighting.HighlightsChangeEvent;
import org.netbeans.spi.editor.highlighting.HighlightsChangeListener;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class TextSearchHighlighting
extends AbstractHighlightsContainer
implements PropertyChangeListener,
HighlightsChangeListener,
DocumentListener {
    private static final Logger LOG = Logger.getLogger(TextSearchHighlighting.class.getName());
    public static final String LAYER_TYPE_ID = "org.netbeans.modules.editor.lib2.highlighting.TextSearchHighlighting";
    private static final RequestProcessor RP = new RequestProcessor("org.netbeans.modules.editor.lib2.highlighting.TextSearchHighlighting", 1, false, false);
    private final MimePath mimePath;
    private final JTextComponent component;
    private final Document document;
    private final OffsetsBag bag;

    public TextSearchHighlighting(JTextComponent component) {
        String mimeType = BlockHighlighting.getMimeType(component);
        this.mimePath = mimeType == null ? MimePath.EMPTY : MimePath.parse((String)mimeType);
        this.component = component;
        this.document = component.getDocument();
        this.document.addDocumentListener(WeakListeners.document((DocumentListener)this, (Object)this.document));
        this.bag = new OffsetsBag(this.document);
        this.bag.addHighlightsChangeListener(this);
        EditorFindSupport.getInstance().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)EditorFindSupport.getInstance()));
        this.fillInTheBag();
    }

    @Override
    public HighlightsSequence getHighlights(int startOffset, int endOffset) {
        return this.bag.getHighlights(startOffset, endOffset);
    }

    @Override
    public void highlightChanged(HighlightsChangeEvent event) {
        this.fireHighlightsChange(event.getStartOffset(), event.getEndOffset());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == null || "find-what".equals(evt.getPropertyName()) || "find-highlight-search".equals(evt.getPropertyName())) {
            this.fillInTheBag();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.bag.removeHighlights(Math.max(e.getOffset() - 1, 0), Math.min(e.getOffset() + 1, this.document.getLength()), false);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.bag.removeHighlights(e.getOffset(), e.getOffset() + e.getLength(), false);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private void fillInTheBag() {
        final Document d = this.document;
        final OffsetsBag b = this.bag;
        RP.post(new Runnable(){
            private boolean documentLocked = false;

            @Override
            public void run() {
                if (!this.documentLocked) {
                    this.documentLocked = true;
                    d.render(this);
                    return;
                }
                OffsetsBag newBag = new OffsetsBag(d);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("TSH: filling the bag; enabled = " + TextSearchHighlighting.this.isEnabled());
                }
                if (TextSearchHighlighting.this.isEnabled() && TextSearchHighlighting.this.component.equals(EditorFindSupport.getInstance().getFocusedTextComponent())) {
                    try {
                        int[] blocks = EditorFindSupport.getInstance().getBlocks(new int[]{-1, -1}, d, 0, d.getLength());
                        assert (blocks.length % 2 == 0) : "Wrong number of block offsets";
                        AttributeSet attribs = TextSearchHighlighting.this.getAttribs();
                        for (int i = 0; i < blocks.length / 2; ++i) {
                            newBag.addHighlight(blocks[2 * i], blocks[2 * i + 1], attribs);
                        }
                    }
                    catch (BadLocationException e) {
                        LOG.log(Level.WARNING, e.getMessage(), e);
                    }
                }
                b.setHighlights(newBag);
            }
        });
    }

    private boolean isEnabled() {
        Object prop = EditorFindSupport.getInstance().getFindProperty("find-highlight-search");
        return prop instanceof Boolean && (Boolean)prop != false;
    }

    private AttributeSet getAttribs() {
        FontColorSettings fcs = (FontColorSettings)MimeLookup.getLookup((MimePath)this.mimePath).lookup(FontColorSettings.class);
        AttributeSet attribs = fcs.getFontColors("highlight-search");
        return attribs == null ? SimpleAttributeSet.EMPTY : attribs;
    }
}

