/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javap;

import com.sun.tools.classfile.Code_attribute;
import com.sun.tools.classfile.Instruction;
import com.sun.tools.javap.ConstantWriter;
import com.sun.tools.javap.Context;
import com.sun.tools.javap.InstructionDetailWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class TryBlockWriter
extends InstructionDetailWriter {
    private Map<Integer, List<Code_attribute.Exception_data>> pcMap;
    private Map<Code_attribute.Exception_data, Integer> indexMap;
    private ConstantWriter constantWriter;

    static TryBlockWriter instance(Context context) {
        TryBlockWriter instance = context.get(TryBlockWriter.class);
        if (instance == null) {
            instance = new TryBlockWriter(context);
        }
        return instance;
    }

    protected TryBlockWriter(Context context) {
        super(context);
        context.put(TryBlockWriter.class, this);
        this.constantWriter = ConstantWriter.instance(context);
    }

    public void reset(Code_attribute attr) {
        this.indexMap = new HashMap<Code_attribute.Exception_data, Integer>();
        this.pcMap = new HashMap<Integer, List<Code_attribute.Exception_data>>();
        for (int i = 0; i < attr.exception_table.length; ++i) {
            Code_attribute.Exception_data entry = attr.exception_table[i];
            this.indexMap.put(entry, i);
            this.put(entry.start_pc, entry);
            this.put(entry.end_pc, entry);
            this.put(entry.handler_pc, entry);
        }
    }

    public void writeDetails(Instruction instr) {
        this.writeTrys(instr, NoteKind.END);
        this.writeTrys(instr, NoteKind.START);
        this.writeTrys(instr, NoteKind.HANDLER);
    }

    public void writeTrys(Instruction instr, NoteKind kind) {
        String indent = this.space(2);
        int pc = instr.getPC();
        List<Code_attribute.Exception_data> entries = this.pcMap.get(pc);
        if (entries != null) {
            ListIterator<Code_attribute.Exception_data> iter = entries.listIterator(kind == NoteKind.END ? entries.size() : 0);
            while (kind == NoteKind.END ? iter.hasPrevious() : iter.hasNext()) {
                Code_attribute.Exception_data entry = kind == NoteKind.END ? iter.previous() : iter.next();
                if (!kind.match(entry, pc)) continue;
                this.print(indent);
                this.print(kind.text);
                this.print("[");
                this.print(this.indexMap.get(entry));
                this.print("] ");
                if (entry.catch_type == 0) {
                    this.print("finally");
                } else {
                    this.print("#" + entry.catch_type);
                    this.print(" // ");
                    this.constantWriter.write(entry.catch_type);
                }
                this.println();
            }
        }
    }

    private void put(int pc, Code_attribute.Exception_data entry) {
        List<Code_attribute.Exception_data> list = this.pcMap.get(pc);
        if (list == null) {
            list = new ArrayList<Code_attribute.Exception_data>();
            this.pcMap.put(pc, list);
        }
        if (!list.contains(entry)) {
            list.add(entry);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NoteKind {
        START("try"){

            public boolean match(Code_attribute.Exception_data entry, int pc) {
                return pc == entry.start_pc;
            }
        }
        ,
        END("end try"){

            public boolean match(Code_attribute.Exception_data entry, int pc) {
                return pc == entry.end_pc;
            }
        }
        ,
        HANDLER("catch"){

            public boolean match(Code_attribute.Exception_data entry, int pc) {
                return pc == entry.handler_pc;
            }
        };

        public final String text;

        private NoteKind(String text) {
            this.text = text;
        }

        public abstract boolean match(Code_attribute.Exception_data var1, int var2);
    }
}

