/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javap;

import com.sun.tools.classfile.Annotation;
import com.sun.tools.classfile.ConstantPool;
import com.sun.tools.classfile.ConstantPoolException;
import com.sun.tools.classfile.Descriptor;
import com.sun.tools.javap.BasicWriter;
import com.sun.tools.javap.ClassWriter;
import com.sun.tools.javap.ConstantWriter;
import com.sun.tools.javap.Context;

public class AnnotationWriter
extends BasicWriter {
    element_value_Writer ev_writer = new element_value_Writer();
    private ClassWriter classWriter;
    private ConstantWriter constantWriter;

    static AnnotationWriter instance(Context context) {
        AnnotationWriter instance = context.get(AnnotationWriter.class);
        if (instance == null) {
            instance = new AnnotationWriter(context);
        }
        return instance;
    }

    protected AnnotationWriter(Context context) {
        super(context);
        this.classWriter = ClassWriter.instance(context);
        this.constantWriter = ConstantWriter.instance(context);
    }

    public void write(Annotation annot) {
        this.write(annot, false);
    }

    public void write(Annotation annot, boolean resolveIndices) {
        boolean showParens;
        this.writeDescriptor(annot.type_index, resolveIndices);
        boolean bl = showParens = annot.num_element_value_pairs > 0 || !resolveIndices;
        if (showParens) {
            this.print("(");
        }
        for (int i = 0; i < annot.num_element_value_pairs; ++i) {
            if (i > 0) {
                this.print(",");
            }
            this.write(annot.element_value_pairs[i], resolveIndices);
        }
        if (showParens) {
            this.print(")");
        }
    }

    public void write(Annotation.element_value_pair pair) {
        this.write(pair, false);
    }

    public void write(Annotation.element_value_pair pair, boolean resolveIndices) {
        this.writeIndex(pair.element_name_index, resolveIndices);
        this.print("=");
        this.write(pair.value, resolveIndices);
    }

    public void write(Annotation.element_value value) {
        this.write(value, false);
    }

    public void write(Annotation.element_value value, boolean resolveIndices) {
        this.ev_writer.write(value, resolveIndices);
    }

    private void writeDescriptor(int index, boolean resolveIndices) {
        if (resolveIndices) {
            try {
                ConstantPool constant_pool = this.classWriter.getClassFile().constant_pool;
                Descriptor d = new Descriptor(index);
                this.print(d.getFieldType(constant_pool));
                return;
            }
            catch (ConstantPoolException ignore) {
            }
            catch (Descriptor.InvalidDescriptor invalidDescriptor) {
                // empty catch block
            }
        }
        this.print("#" + index);
    }

    private void writeIndex(int index, boolean resolveIndices) {
        if (resolveIndices) {
            this.print(this.constantWriter.stringValue(index));
        } else {
            this.print("#" + index);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class element_value_Writer
    implements Annotation.element_value.Visitor<Void, Boolean> {
        element_value_Writer() {
        }

        public void write(Annotation.element_value value, boolean resolveIndices) {
            value.accept(this, resolveIndices);
        }

        @Override
        public Void visitPrimitive(Annotation.Primitive_element_value ev, Boolean resolveIndices) {
            if (resolveIndices.booleanValue()) {
                AnnotationWriter.this.writeIndex(ev.const_value_index, resolveIndices);
            } else {
                AnnotationWriter.this.print((char)ev.tag + "#" + ev.const_value_index);
            }
            return null;
        }

        @Override
        public Void visitEnum(Annotation.Enum_element_value ev, Boolean resolveIndices) {
            if (resolveIndices.booleanValue()) {
                AnnotationWriter.this.writeIndex(ev.type_name_index, resolveIndices);
                AnnotationWriter.this.print(".");
                AnnotationWriter.this.writeIndex(ev.const_name_index, resolveIndices);
            } else {
                AnnotationWriter.this.print((char)ev.tag + "#" + ev.type_name_index + ".#" + ev.const_name_index);
            }
            return null;
        }

        @Override
        public Void visitClass(Annotation.Class_element_value ev, Boolean resolveIndices) {
            if (resolveIndices.booleanValue()) {
                AnnotationWriter.this.writeIndex(ev.class_info_index, resolveIndices);
                AnnotationWriter.this.print(".class");
            } else {
                AnnotationWriter.this.print((char)ev.tag + "#" + ev.class_info_index);
            }
            return null;
        }

        @Override
        public Void visitAnnotation(Annotation.Annotation_element_value ev, Boolean resolveIndices) {
            AnnotationWriter.this.print(Character.valueOf((char)ev.tag));
            AnnotationWriter.this.write(ev.annotation_value, (boolean)resolveIndices);
            return null;
        }

        @Override
        public Void visitArray(Annotation.Array_element_value ev, Boolean resolveIndices) {
            AnnotationWriter.this.print("[");
            for (int i = 0; i < ev.num_values; ++i) {
                if (i > 0) {
                    AnnotationWriter.this.print(",");
                }
                this.write(ev.values[i], resolveIndices);
            }
            AnnotationWriter.this.print("]");
            return null;
        }
    }
}

