/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.comp.MemberEnter;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Position;
import com.sun.tools.javadoc.ClassDocImpl;
import com.sun.tools.javadoc.DocEnv;

public class JavadocMemberEnter
extends MemberEnter {
    final DocEnv docenv;

    public static JavadocMemberEnter instance0(Context context) {
        MemberEnter instance = (MemberEnter)context.get(memberEnterKey);
        if (instance == null) {
            instance = new JavadocMemberEnter(context);
        }
        return (JavadocMemberEnter)instance;
    }

    public static void preRegister(Context context) {
        context.put(memberEnterKey, new Context.Factory<MemberEnter>(){

            @Override
            public MemberEnter make(Context c) {
                return new JavadocMemberEnter(c);
            }
        });
    }

    protected JavadocMemberEnter(Context context) {
        super(context);
        this.docenv = DocEnv.instance(context);
    }

    public void visitMethodDef(JCTree.JCMethodDecl tree) {
        super.visitMethodDef(tree);
        Symbol.MethodSymbol meth = tree.sym;
        if (meth == null || meth.kind != 16) {
            return;
        }
        String docComment = this.env.toplevel.docComments.get(tree);
        Position.LineMap lineMap = this.env.toplevel.lineMap;
        if (meth.isConstructor()) {
            this.docenv.makeConstructorDoc(meth, docComment, tree, lineMap);
        } else if (JavadocMemberEnter.isAnnotationTypeElement(meth)) {
            this.docenv.makeAnnotationTypeElementDoc(meth, docComment, tree, lineMap);
        } else {
            this.docenv.makeMethodDoc(meth, docComment, tree, lineMap);
        }
    }

    public void visitVarDef(JCTree.JCVariableDecl tree) {
        super.visitVarDef(tree);
        if (tree.sym != null && tree.sym.getKind().isField()) {
            String docComment = this.env.toplevel.docComments.get(tree);
            Position.LineMap lineMap = this.env.toplevel.lineMap;
            this.docenv.makeFieldDoc(tree.sym, docComment, tree, lineMap);
        }
    }

    private static boolean isAnnotationTypeElement(Symbol.MethodSymbol meth) {
        return ClassDocImpl.isAnnotationType(meth.enclClass());
    }

    private static boolean isParameter(Symbol.VarSymbol var) {
        return (var.flags() & 0x200000000L) != 0L;
    }
}

