/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Warner;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransTypes
extends TreeTranslator {
    protected static final Context.Key<TransTypes> transTypesKey = new Context.Key();
    private Names names;
    private Log log;
    private Symtab syms;
    private TreeMaker make;
    private Enter enter;
    private boolean allowEnums;
    private Types types;
    private final Resolve resolve;
    private final boolean addBridges;
    Map<Symbol.MethodSymbol, Symbol.MethodSymbol> overridden;
    Filter<Symbol> overrideBridgeFilter = new Filter<Symbol>(){

        @Override
        public boolean accepts(Symbol s) {
            return (s.flags() & 0x20000001000L) != 4096L;
        }
    };
    private Type pt;
    JCTree.JCMethodDecl currentMethod = null;
    private Env<AttrContext> env;

    public static TransTypes instance(Context context) {
        TransTypes instance = context.get(transTypesKey);
        if (instance == null) {
            instance = new TransTypes(context);
        }
        return instance;
    }

    protected TransTypes(Context context) {
        context.put(transTypesKey, this);
        this.names = Names.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.enter = Enter.instance(context);
        this.overridden = new HashMap<Symbol.MethodSymbol, Symbol.MethodSymbol>();
        Source source = Source.instance(context);
        this.allowEnums = source.allowEnums();
        this.addBridges = source.addBridges();
        this.types = Types.instance(context);
        this.make = TreeMaker.instance(context);
        this.resolve = Resolve.instance(context);
    }

    JCTree.JCExpression cast(JCTree.JCExpression tree, Type target) {
        int oldpos = this.make.pos;
        this.make.at(tree.pos);
        if (!this.types.isSameType(tree.type, target)) {
            if (!this.resolve.isAccessible(this.env, target.tsym)) {
                this.resolve.logAccessError(this.env, tree, target);
            }
            tree = this.make.TypeCast(this.make.Type(target), tree).setType(target);
        }
        this.make.pos = oldpos;
        return tree;
    }

    JCTree.JCExpression coerce(JCTree.JCExpression tree, Type target) {
        Type btarget = target.baseType();
        if (tree.type.isPrimitive() == target.isPrimitive()) {
            return this.types.isAssignable(tree.type, btarget, Warner.noWarnings) ? tree : this.cast(tree, btarget);
        }
        return tree;
    }

    JCTree.JCExpression retype(JCTree.JCExpression tree, Type erasedType, Type target) {
        if (erasedType.tag > 8) {
            if (target != null && target.isPrimitive()) {
                target = this.erasure(tree.type);
            }
            tree.type = erasedType;
            if (target != null) {
                return this.coerce(tree, target);
            }
        }
        return tree;
    }

    <T extends JCTree> List<T> translateArgs(List<T> _args, List<Type> parameters, Type varargsElement) {
        if (parameters.isEmpty()) {
            return _args;
        }
        List<Object> args = _args;
        while (parameters.tail.nonEmpty()) {
            args.head = this.translate((JCTree)args.head, (Type)parameters.head);
            args = args.tail;
            parameters = parameters.tail;
        }
        Type parameter = (Type)parameters.head;
        Assert.check(varargsElement != null || args.length() == 1);
        if (varargsElement != null) {
            while (args.nonEmpty()) {
                args.head = this.translate((JCTree)args.head, varargsElement);
                args = args.tail;
            }
        } else {
            args.head = this.translate((JCTree)args.head, parameter);
        }
        return _args;
    }

    void addBridge(JCDiagnostic.DiagnosticPosition pos, Symbol.MethodSymbol meth, Symbol.MethodSymbol impl, Symbol.ClassSymbol origin, boolean hypothetical, ListBuffer<JCTree> bridges) {
        this.make.at(pos);
        Type origType = this.types.memberType(origin.type, meth);
        Type origErasure = this.erasure(origType);
        Type bridgeType = meth.erasure(this.types);
        long flags = impl.flags() & 7L | 0x1000L | 0x80000000L;
        if (hypothetical) {
            flags |= 0x2000000000L;
        }
        Symbol.MethodSymbol bridge = new Symbol.MethodSymbol(flags, meth.name, bridgeType, origin);
        if (!hypothetical) {
            JCTree.JCMethodDecl md = this.make.MethodDef(bridge, null);
            JCTree.JCExpression receiver = impl.owner == origin ? this.make.This(origin.erasure(this.types)) : this.make.Super(this.types.supertype((Type)origin.type).tsym.erasure(this.types), origin);
            Type calltype = this.erasure(impl.type.getReturnType());
            JCTree.JCMethodInvocation call = this.make.Apply(null, this.make.Select(receiver, impl).setType(calltype), this.translateArgs(this.make.Idents(md.params), origErasure.getParameterTypes(), null)).setType(calltype);
            JCTree.JCExpressionStatement stat = origErasure.getReturnType().tag == 9 ? this.make.Exec(call) : this.make.Return(this.coerce(call, bridgeType.getReturnType()));
            md.body = this.make.Block(0L, List.of(stat));
            bridges.append(md);
        }
        origin.members().enter(bridge);
        this.overridden.put(bridge, meth);
    }

    void addBridgeIfNeeded(JCDiagnostic.DiagnosticPosition pos, Symbol sym, Symbol.ClassSymbol origin, ListBuffer<JCTree> bridges) {
        if (sym.kind == 16 && sym.name != this.names.init && (sym.flags() & 0xAL) == 0L && (sym.flags() & 0x20000001000L) != 4096L && sym.isMemberOf(origin, this.types)) {
            Symbol.MethodSymbol meth = (Symbol.MethodSymbol)sym;
            Symbol.MethodSymbol bridge = meth.binaryImplementation(origin, this.types);
            Symbol.MethodSymbol impl = meth.implementation(origin, this.types, true, this.overrideBridgeFilter);
            if (bridge == null || bridge == meth || impl != null && !bridge.owner.isSubClass(impl.owner, this.types)) {
                if (impl != null && this.isBridgeNeeded(meth, impl, origin.type)) {
                    this.addBridge(pos, meth, impl, origin, bridge == impl, bridges);
                } else if (impl == meth && impl.owner != origin && (impl.flags() & 0x10L) == 0L && (meth.flags() & 0x401L) == 1L && (origin.flags() & 1L) > (impl.owner.flags() & 1L)) {
                    this.addBridge(pos, meth, impl, origin, false, bridges);
                }
            } else if ((bridge.flags() & 0x20000001000L) == 4096L) {
                Symbol.MethodSymbol other = this.overridden.get(bridge);
                if (!(other == null || other == meth || impl != null && impl.overrides(other, origin, this.types, true))) {
                    this.log.error(pos, "name.clash.same.erasure.no.override", other, other.location(origin.type, this.types), meth, meth.location(origin.type, this.types));
                }
            } else if (!(bridge.overrides(meth, origin, this.types, true) || bridge.owner != origin && this.types.asSuper(bridge.owner.type, meth.owner) != null)) {
                this.log.error(pos, "name.clash.same.erasure.no.override", bridge, bridge.location(origin.type, this.types), meth, meth.location(origin.type, this.types));
            }
        }
    }

    private boolean isBridgeNeeded(Symbol.MethodSymbol method, Symbol.MethodSymbol impl, Type dest) {
        if (impl != method) {
            Type method_erasure = method.erasure(this.types);
            if (!this.isSameMemberWhenErased(dest, method, method_erasure)) {
                return true;
            }
            Type impl_erasure = impl.erasure(this.types);
            if (!this.isSameMemberWhenErased(dest, impl, impl_erasure)) {
                return true;
            }
            return !this.types.isSameType(impl_erasure.getReturnType(), method_erasure.getReturnType());
        }
        if ((method.flags() & 0x400L) != 0L) {
            return false;
        }
        return !this.isSameMemberWhenErased(dest, method, method.erasure(this.types));
    }

    private boolean isSameMemberWhenErased(Type type, Symbol.MethodSymbol method, Type erasure) {
        return this.types.isSameType(this.erasure(this.types.memberType(type, method)), erasure);
    }

    void addBridges(JCDiagnostic.DiagnosticPosition pos, Symbol.TypeSymbol i, Symbol.ClassSymbol origin, ListBuffer<JCTree> bridges) {
        Scope.Entry e = i.members().elems;
        while (e != null) {
            this.addBridgeIfNeeded(pos, e.sym, origin, bridges);
            e = e.sibling;
        }
        List<Type> l = this.types.interfaces(i.type);
        while (l.nonEmpty()) {
            this.addBridges(pos, ((Type)l.head).tsym, origin, bridges);
            l = l.tail;
        }
    }

    void addBridges(JCDiagnostic.DiagnosticPosition pos, Symbol.ClassSymbol origin, ListBuffer<JCTree> bridges) {
        Type st = this.types.supertype(origin.type);
        while (st.tag == 10) {
            this.addBridges(pos, st.tsym, origin, bridges);
            st = this.types.supertype(st);
        }
        List<Type> l = this.types.interfaces(origin.type);
        while (l.nonEmpty()) {
            this.addBridges(pos, ((Type)l.head).tsym, origin, bridges);
            l = l.tail;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends JCTree> T translate(T tree, Type pt) {
        Type prevPt = this.pt;
        try {
            this.pt = pt;
            T t = this.translate(tree);
            return t;
        }
        finally {
            this.pt = prevPt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends JCTree> List<T> translate(List<T> trees, Type pt) {
        List<T> res;
        Type prevPt = this.pt;
        try {
            this.pt = pt;
            res = this.translate(trees);
        }
        finally {
            this.pt = prevPt;
        }
        return res;
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl tree) {
        this.translateClass(tree.sym);
        this.result = tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitMethodDef(JCTree.JCMethodDecl tree) {
        JCTree.JCMethodDecl previousMethod = this.currentMethod;
        try {
            this.currentMethod = tree;
            tree.restype = this.translate(tree.restype, null);
            tree.typarams = List.nil();
            tree.params = this.translateVarDefs(tree.params);
            tree.thrown = this.translate(tree.thrown, null);
            tree.body = this.translate(tree.body, tree.sym.erasure(this.types).getReturnType());
            tree.type = this.erasure(tree.type);
            this.result = tree;
        }
        finally {
            this.currentMethod = previousMethod;
        }
        Scope.Entry e = tree.sym.owner.members().lookup(tree.name);
        while (e.sym != null) {
            if (e.sym != tree.sym && this.types.isSameType(this.erasure(e.sym.type), tree.type)) {
                this.log.error(tree.pos(), "name.clash.same.erasure", tree.sym, e.sym);
                return;
            }
            e = e.next();
        }
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl tree) {
        tree.vartype = this.translate(tree.vartype, null);
        tree.init = this.translate(tree.init, tree.sym.erasure(this.types));
        tree.type = this.erasure(tree.type);
        this.result = tree;
    }

    @Override
    public void visitDoLoop(JCTree.JCDoWhileLoop tree) {
        tree.body = this.translate(tree.body);
        tree.cond = this.translate(tree.cond, this.syms.booleanType);
        this.result = tree;
    }

    @Override
    public void visitWhileLoop(JCTree.JCWhileLoop tree) {
        tree.cond = this.translate(tree.cond, this.syms.booleanType);
        tree.body = this.translate(tree.body);
        this.result = tree;
    }

    @Override
    public void visitForLoop(JCTree.JCForLoop tree) {
        tree.init = this.translate(tree.init, null);
        if (tree.cond != null) {
            tree.cond = this.translate(tree.cond, this.syms.booleanType);
        }
        tree.step = this.translate(tree.step, null);
        tree.body = this.translate(tree.body);
        this.result = tree;
    }

    @Override
    public void visitForeachLoop(JCTree.JCEnhancedForLoop tree) {
        tree.var = this.translate(tree.var, null);
        Type iterableType = tree.expr.type;
        tree.expr = this.translate(tree.expr, this.erasure(tree.expr.type));
        if (this.types.elemtype(tree.expr.type) == null) {
            tree.expr.type = iterableType;
        }
        tree.body = this.translate(tree.body);
        this.result = tree;
    }

    @Override
    public void visitSwitch(JCTree.JCSwitch tree) {
        Type selsuper = this.types.supertype(tree.selector.type);
        boolean enumSwitch = selsuper != null && selsuper.tsym == this.syms.enumSym;
        Type target = enumSwitch ? this.erasure(tree.selector.type) : this.syms.intType;
        tree.selector = this.translate(tree.selector, target);
        tree.cases = this.translateCases(tree.cases);
        this.result = tree;
    }

    @Override
    public void visitCase(JCTree.JCCase tree) {
        tree.pat = this.translate(tree.pat, null);
        tree.stats = this.translate(tree.stats);
        this.result = tree;
    }

    @Override
    public void visitSynchronized(JCTree.JCSynchronized tree) {
        tree.lock = this.translate(tree.lock, this.erasure(tree.lock.type));
        tree.body = this.translate(tree.body);
        this.result = tree;
    }

    @Override
    public void visitTry(JCTree.JCTry tree) {
        tree.resources = this.translate(tree.resources, this.syms.autoCloseableType);
        tree.body = this.translate(tree.body);
        tree.catchers = this.translateCatchers(tree.catchers);
        tree.finalizer = this.translate(tree.finalizer);
        this.result = tree;
    }

    @Override
    public void visitConditional(JCTree.JCConditional tree) {
        tree.cond = this.translate(tree.cond, this.syms.booleanType);
        tree.truepart = this.translate(tree.truepart, this.erasure(tree.type));
        tree.falsepart = this.translate(tree.falsepart, this.erasure(tree.type));
        tree.type = this.erasure(tree.type);
        this.result = this.retype(tree, tree.type, this.pt);
    }

    @Override
    public void visitIf(JCTree.JCIf tree) {
        tree.cond = this.translate(tree.cond, this.syms.booleanType);
        tree.thenpart = this.translate(tree.thenpart);
        tree.elsepart = this.translate(tree.elsepart);
        this.result = tree;
    }

    @Override
    public void visitExec(JCTree.JCExpressionStatement tree) {
        tree.expr = this.translate(tree.expr, null);
        this.result = tree;
    }

    @Override
    public void visitReturn(JCTree.JCReturn tree) {
        tree.expr = this.translate(tree.expr, this.currentMethod.sym.erasure(this.types).getReturnType());
        this.result = tree;
    }

    @Override
    public void visitThrow(JCTree.JCThrow tree) {
        tree.expr = this.translate(tree.expr, this.erasure(tree.expr.type));
        this.result = tree;
    }

    @Override
    public void visitAssert(JCTree.JCAssert tree) {
        tree.cond = this.translate(tree.cond, this.syms.booleanType);
        if (tree.detail != null) {
            tree.detail = this.translate(tree.detail, this.erasure(tree.detail.type));
        }
        this.result = tree;
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation tree) {
        tree.meth = this.translate(tree.meth, null);
        Symbol meth = TreeInfo.symbol(tree.meth);
        Type mt = meth.erasure(this.types);
        List<Type> argtypes = mt.getParameterTypes();
        if (this.allowEnums && meth.name == this.names.init && meth.owner == this.syms.enumSym) {
            argtypes = argtypes.tail.tail;
        }
        if (tree.varargsElement != null) {
            tree.varargsElement = this.types.erasure(tree.varargsElement);
        } else {
            Assert.check(tree.args.length() == argtypes.length());
        }
        tree.args = this.translateArgs(tree.args, argtypes, tree.varargsElement);
        this.result = this.retype(tree, mt.getReturnType(), this.pt);
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass tree) {
        if (tree.encl != null) {
            tree.encl = this.translate(tree.encl, this.erasure(tree.encl.type));
        }
        tree.clazz = this.translate(tree.clazz, null);
        if (tree.varargsElement != null) {
            tree.varargsElement = this.types.erasure(tree.varargsElement);
        }
        tree.args = this.translateArgs(tree.args, tree.constructor.erasure(this.types).getParameterTypes(), tree.varargsElement);
        tree.def = this.translate(tree.def, null);
        tree.type = this.erasure(tree.type);
        this.result = tree;
    }

    @Override
    public void visitNewArray(JCTree.JCNewArray tree) {
        tree.elemtype = this.translate(tree.elemtype, null);
        this.translate(tree.dims, this.syms.intType);
        if (tree.type != null) {
            tree.elems = this.translate(tree.elems, this.erasure(this.types.elemtype(tree.type)));
            tree.type = this.erasure(tree.type);
        } else {
            tree.elems = this.translate(tree.elems, null);
        }
        this.result = tree;
    }

    @Override
    public void visitParens(JCTree.JCParens tree) {
        tree.expr = this.translate(tree.expr, this.pt);
        tree.type = this.erasure(tree.type);
        this.result = tree;
    }

    @Override
    public void visitAssign(JCTree.JCAssign tree) {
        tree.lhs = this.translate(tree.lhs, null);
        tree.rhs = this.translate(tree.rhs, this.erasure(tree.lhs.type));
        tree.type = this.erasure(tree.type);
        this.result = tree;
    }

    @Override
    public void visitAssignop(JCTree.JCAssignOp tree) {
        tree.lhs = this.translate(tree.lhs, null);
        tree.rhs = this.translate(tree.rhs, (Type)tree.operator.type.getParameterTypes().tail.head);
        tree.type = this.erasure(tree.type);
        this.result = tree;
    }

    @Override
    public void visitUnary(JCTree.JCUnary tree) {
        tree.arg = this.translate(tree.arg, (Type)tree.operator.type.getParameterTypes().head);
        this.result = tree;
    }

    @Override
    public void visitBinary(JCTree.JCBinary tree) {
        tree.lhs = this.translate(tree.lhs, (Type)tree.operator.type.getParameterTypes().head);
        tree.rhs = this.translate(tree.rhs, (Type)tree.operator.type.getParameterTypes().tail.head);
        this.result = tree;
    }

    @Override
    public void visitTypeCast(JCTree.JCTypeCast tree) {
        tree.clazz = this.translate(tree.clazz, null);
        tree.type = this.erasure(tree.type);
        tree.expr = this.translate(tree.expr, tree.type);
        this.result = tree;
    }

    @Override
    public void visitTypeTest(JCTree.JCInstanceOf tree) {
        tree.expr = this.translate(tree.expr, null);
        tree.clazz = this.translate(tree.clazz, null);
        this.result = tree;
    }

    @Override
    public void visitIndexed(JCTree.JCArrayAccess tree) {
        tree.indexed = this.translate(tree.indexed, this.erasure(tree.indexed.type));
        tree.index = this.translate(tree.index, this.syms.intType);
        this.result = this.retype(tree, this.types.elemtype(tree.indexed.type), this.pt);
    }

    @Override
    public void visitAnnotation(JCTree.JCAnnotation tree) {
        this.result = tree;
    }

    @Override
    public void visitIdent(JCTree.JCIdent tree) {
        Type et = tree.sym.erasure(this.types);
        if (tree.sym.kind == 2 && tree.sym.type.tag == 14) {
            this.result = this.make.at(tree.pos).Type(et);
        } else if (tree.type.constValue() != null) {
            this.result = tree;
        } else if (tree.sym.kind == 4) {
            this.result = this.retype(tree, et, this.pt);
        } else {
            tree.type = this.erasure(tree.type);
            this.result = tree;
        }
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess tree) {
        Type t = tree.selected.type;
        while (t.tag == 14) {
            t = t.getUpperBound();
        }
        if (t.isCompound()) {
            if ((tree.sym.flags() & 0x200000L) != 0L) {
                tree.sym = ((Symbol.MethodSymbol)tree.sym).implemented((Symbol.TypeSymbol)tree.sym.owner, this.types);
            }
            tree.selected = this.coerce(this.translate(tree.selected, this.erasure(tree.selected.type)), this.erasure(tree.sym.owner.type));
        } else {
            tree.selected = this.translate(tree.selected, this.erasure(t));
        }
        if (tree.type.constValue() != null) {
            this.result = tree;
        } else if (tree.sym.kind == 4) {
            this.result = this.retype(tree, tree.sym.erasure(this.types), this.pt);
        } else {
            tree.type = this.erasure(tree.type);
            this.result = tree;
        }
    }

    @Override
    public void visitTypeArray(JCTree.JCArrayTypeTree tree) {
        tree.elemtype = this.translate(tree.elemtype, null);
        tree.type = this.erasure(tree.type);
        this.result = tree;
    }

    @Override
    public void visitTypeApply(JCTree.JCTypeApply tree) {
        JCTree.JCExpression clazz = this.translate(tree.clazz, null);
        this.result = clazz;
    }

    private Type erasure(Type t) {
        return this.types.erasure(t);
    }

    private boolean boundsRestricted(Symbol.ClassSymbol c) {
        Type st = this.types.supertype(c.type);
        if (st.isParameterized()) {
            List<Type> actuals = st.allparams();
            List<Type> formals = st.tsym.type.allparams();
            while (!actuals.isEmpty() && !formals.isEmpty()) {
                Type actual = (Type)actuals.head;
                Type formal = (Type)formals.head;
                if (!this.types.isSameType(this.types.erasure(actual), this.types.erasure(formal))) {
                    return true;
                }
                actuals = actuals.tail;
                formals = formals.tail;
            }
        }
        return false;
    }

    private List<JCTree> addOverrideBridgesIfNeeded(JCDiagnostic.DiagnosticPosition pos, Symbol.ClassSymbol c) {
        ListBuffer<JCTree> buf = ListBuffer.lb();
        if (c.isInterface() || !this.boundsRestricted(c)) {
            return buf.toList();
        }
        Type t = this.types.supertype(c.type);
        Scope s = t.tsym.members();
        if (s.elems != null) {
            for (Symbol sym : s.getElements(new NeedsOverridBridgeFilter(c))) {
                Symbol.MethodSymbol m = (Symbol.MethodSymbol)sym;
                Symbol.MethodSymbol member = (Symbol.MethodSymbol)m.asMemberOf(c.type, this.types);
                Symbol.MethodSymbol impl = m.implementation(c, this.types, false);
                if (impl != null && impl.owner == c || this.types.isSameType(member.erasure(this.types), m.erasure(this.types))) continue;
                this.addOverrideBridges(pos, m, member, c, buf);
            }
        }
        return buf.toList();
    }

    private void addOverrideBridges(JCDiagnostic.DiagnosticPosition pos, Symbol.MethodSymbol impl, Symbol.MethodSymbol member, Symbol.ClassSymbol c, ListBuffer<JCTree> bridges) {
        Type implErasure = impl.erasure(this.types);
        long flags = impl.flags() & 7L | 0x1000L | 0x80000000L | 0x20000000000L;
        member = new Symbol.MethodSymbol(flags, member.name, member.type, c);
        JCTree.JCMethodDecl md = this.make.MethodDef(member, null);
        JCTree.JCIdent receiver = this.make.Super(this.types.supertype((Type)c.type).tsym.erasure(this.types), c);
        Type calltype = this.erasure(impl.type.getReturnType());
        JCTree.JCMethodInvocation call = this.make.Apply(null, this.make.Select((JCTree.JCExpression)receiver, impl).setType(calltype), this.translateArgs(this.make.Idents(md.params), implErasure.getParameterTypes(), null)).setType(calltype);
        JCTree.JCExpressionStatement stat = member.getReturnType().tag == 9 ? this.make.Exec(call) : this.make.Return(this.coerce(call, member.erasure(this.types).getReturnType()));
        md.body = this.make.Block(0L, List.of(stat));
        c.members().enter(member);
        bridges.append(md);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void translateClass(Symbol.ClassSymbol c) {
        Env<AttrContext> myEnv;
        Type st = this.types.supertype(c.type);
        if (st.tag == 10) {
            this.translateClass((Symbol.ClassSymbol)st.tsym);
        }
        if ((myEnv = this.enter.typeEnvs.remove(c)) == null) {
            return;
        }
        Env<AttrContext> oldEnv = this.env;
        try {
            this.env = myEnv;
            TreeMaker savedMake = this.make;
            Type savedPt = this.pt;
            this.make = this.make.forToplevel(this.env.toplevel);
            this.pt = null;
            try {
                JCTree.JCClassDecl tree = (JCTree.JCClassDecl)this.env.tree;
                tree.typarams = List.nil();
                super.visitClassDef(tree);
                this.make.at(tree.pos);
                if (this.addBridges) {
                    ListBuffer<JCTree> bridges = new ListBuffer<JCTree>();
                    if ((tree.sym.flags() & 0x200L) == 0L) {
                        this.addBridges(tree.pos(), tree.sym, bridges);
                    }
                    tree.defs = bridges.toList().prependList(tree.defs);
                }
                tree.type = this.erasure(tree.type);
            }
            finally {
                this.make = savedMake;
                this.pt = savedPt;
            }
        }
        finally {
            this.env = oldEnv;
        }
    }

    public JCTree translateTopLevelClass(JCTree cdef, TreeMaker make) {
        this.make = make;
        this.pt = null;
        return this.translate(cdef, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NeedsOverridBridgeFilter
    implements Filter<Symbol> {
        Symbol.ClassSymbol c;

        NeedsOverridBridgeFilter(Symbol.ClassSymbol c) {
            this.c = c;
        }

        @Override
        public boolean accepts(Symbol s) {
            return s.kind == 16 && !s.isConstructor() && s.isInheritedIn(this.c, TransTypes.this.types) && (s.flags() & 0x10L) == 0L && (s.flags() & 0x20000001000L) != 4096L;
        }
    }
}

