/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.domain.values.transdelay;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TransmissionDelayDistribution
implements Serializable {
    public static final int OUT_OF_RANGE = Integer.MAX_VALUE;
    private final int totalAmountOfEvents;
    private final Map<Integer, Number> distribution;
    private final int miniumDelay;
    private final int maximumDelay;

    public static TransmissionDelayDistribution reduceCategories(TransmissionDelayDistribution distribution, List<Integer> reducedCategories) {
        ArrayList<Integer> sortedNewCategories = new ArrayList<Integer>(reducedCategories);
        if (!sortedNewCategories.contains(Integer.MAX_VALUE)) {
            sortedNewCategories.add(Integer.MAX_VALUE);
        }
        Collections.sort(sortedNewCategories);
        ArrayList<Integer> sortedOldCategories = new ArrayList<Integer>(distribution.getDistribution().keySet());
        Collections.sort(sortedOldCategories);
        HashMap<Integer, Number> newDistribution = new HashMap<Integer, Number>();
        for (Integer newCategory : sortedNewCategories) {
            Integer oldCategory;
            int value = 0;
            Iterator i$ = sortedOldCategories.iterator();
            while (i$.hasNext() && (oldCategory = (Integer)i$.next()) <= newCategory) {
                value += distribution.getDistribution().get(oldCategory).intValue();
            }
            newDistribution.put(newCategory, value);
        }
        return new TransmissionDelayDistribution(newDistribution, distribution.getMiniumDelay(), distribution.getMaximumDelay());
    }

    public TransmissionDelayDistribution(Map<Integer, Number> distribution, int miniumDelay, int maximumDelay) {
        if (!distribution.containsKey(Integer.MAX_VALUE)) {
            distribution = new HashMap<Integer, Number>(distribution);
            distribution.put(Integer.MAX_VALUE, 0);
        }
        this.distribution = Collections.unmodifiableMap(distribution);
        int events = 0;
        for (Number value : distribution.values()) {
            events += value.intValue();
        }
        this.totalAmountOfEvents = events;
        this.miniumDelay = miniumDelay;
        this.maximumDelay = maximumDelay;
    }

    public int getMaximumDelay() {
        return this.maximumDelay;
    }

    public int getMiniumDelay() {
        return this.miniumDelay;
    }

    public Map<Integer, Number> getDistribution() {
        return this.distribution;
    }

    public int getTotalAmountOfEvents() {
        return this.totalAmountOfEvents;
    }

    protected void appendField(StringBuilder builder, String name, String value) {
        builder.append(name);
        builder.append("\t");
        builder.append(value);
        builder.append("\n");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.appendField(builder, "Total", Integer.toString(this.totalAmountOfEvents));
        this.appendField(builder, "Min", Integer.toString(this.totalAmountOfEvents));
        this.appendField(builder, "Max", Integer.toString(this.totalAmountOfEvents));
        this.appendField(builder, "Average", Integer.toString(this.totalAmountOfEvents));
        builder.append("\n");
        ArrayList<Integer> categories = new ArrayList<Integer>(this.distribution.keySet());
        Collections.sort(categories);
        for (Integer category : categories) {
            String categoryStr = category == Integer.MAX_VALUE ? "OUT_OF_RANGE" : category.toString();
            this.appendField(builder, categoryStr, this.distribution.get(category).toString());
        }
        return builder.toString();
    }
}

