/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.domain.values.datasync.xml;

import de.proveo.domain.values.datasync.DatasyncMetainfoValue;
import de.proveo.domain.values.datasync.DatasyncResourceValue;
import de.proveo.domain.values.datasync.DatasyncStatusValue;
import de.proveo.domain.values.datasync.DatasyncTaskValue;
import de.proveo.domain.values.datasync.xml.DatasyncXMLMetainfoValue;
import de.proveo.domain.values.datasync.xml.DatasyncXMLResourceValue;
import de.proveo.domain.values.datasync.xml.DatasyncXMLStatusValue;
import de.proveo.domain.values.datasync.xml.DatasyncXMLTaskValue;
import java.util.ArrayList;
import java.util.List;

public class DatasyncXMLConverter {
    public static DatasyncXMLMetainfoValue convertDatasyncMetaInfoValue(DatasyncMetainfoValue value) {
        DatasyncXMLMetainfoValue xmlValue = new DatasyncXMLMetainfoValue();
        xmlValue.setKey(value.getKey());
        xmlValue.setValue(value.getValue());
        return xmlValue;
    }

    public static DatasyncXMLResourceValue convertDatasyncResourceValue(DatasyncResourceValue value) {
        DatasyncXMLResourceValue xmlValue = DatasyncXMLConverter.convertDatasyncResourceValueWithoutPayload(value);
        xmlValue.setResource(value.getResource());
        return xmlValue;
    }

    public static DatasyncXMLResourceValue convertDatasyncResourceValueWithoutPayload(DatasyncResourceValue value) {
        DatasyncXMLResourceValue xmlValue = new DatasyncXMLResourceValue();
        xmlValue.setChecksum(value.getChecksum());
        List<DatasyncMetainfoValue> metaInfos = value.getMetainfos();
        if (metaInfos != null) {
            ArrayList<DatasyncXMLMetainfoValue> xmlMetaInfos = new ArrayList<DatasyncXMLMetainfoValue>();
            for (DatasyncMetainfoValue info : metaInfos) {
                xmlMetaInfos.add(DatasyncXMLConverter.convertDatasyncMetaInfoValue(info));
            }
            xmlValue.setMetainfos(xmlMetaInfos);
        }
        xmlValue.setResourceId(value.getResourceId());
        xmlValue.setResourceName(value.getResourceName());
        xmlValue.setValidFrom(value.getValidFrom());
        xmlValue.setValidTill(value.getValidTill());
        return xmlValue;
    }

    public static DatasyncXMLStatusValue convertDatasyncStatusValue(DatasyncStatusValue value) {
        DatasyncXMLStatusValue xmlValue = new DatasyncXMLStatusValue();
        xmlValue.setClientId(value.getClientId());
        xmlValue.setErrorMessage(value.getErrorMessage());
        xmlValue.setFinishedTime(value.getFinishedTime());
        xmlValue.setIdentifier(value.getIdentifier());
        xmlValue.setLastRetryTime(value.getLastRetryTime());
        xmlValue.setRemark(value.getRemark());
        xmlValue.setRetryCount(value.getRetryCount());
        xmlValue.setSerialNumber(value.getSerialNumber());
        xmlValue.setStartedTime(value.getStartedTime());
        xmlValue.setStatus(value.getStatus());
        xmlValue.setTaskId(value.getTaskId());
        xmlValue.setTaskInfo(value.getTaskInfo());
        xmlValue.setValidFrom(value.getValidFrom());
        xmlValue.setValidTill(value.getValidTill());
        xmlValue.setResourceIds(value.getResourceIds());
        return xmlValue;
    }

    public static DatasyncXMLTaskValue convertDatasyncTaskValue(DatasyncTaskValue value) {
        return DatasyncXMLConverter.convertDatasyncTaskValue(value, true);
    }

    public static DatasyncXMLTaskValue convertDatasyncTaskValueWithoutResourcePayload(DatasyncTaskValue value) {
        return DatasyncXMLConverter.convertDatasyncTaskValue(value, false);
    }

    private static DatasyncXMLTaskValue convertDatasyncTaskValue(DatasyncTaskValue value, boolean includingResourcePayload) {
        List<DatasyncResourceValue> resources;
        DatasyncXMLTaskValue xmlValue = new DatasyncXMLTaskValue();
        xmlValue.setClientId(value.getClientId());
        xmlValue.setClientSerialNumber(value.getClientSerialNumber());
        xmlValue.setIdentifier(value.getIdentifier());
        xmlValue.setMaxRetry(value.getMaxRetry());
        List<DatasyncMetainfoValue> metaInfos = value.getMetainfos();
        if (metaInfos != null) {
            ArrayList<DatasyncXMLMetainfoValue> xmlMetaInfos = new ArrayList<DatasyncXMLMetainfoValue>();
            for (DatasyncMetainfoValue info : metaInfos) {
                xmlMetaInfos.add(DatasyncXMLConverter.convertDatasyncMetaInfoValue(info));
            }
            xmlValue.setMetainfos(xmlMetaInfos);
        }
        if ((resources = value.getResources()) != null) {
            ArrayList<DatasyncXMLResourceValue> xmlResources = new ArrayList<DatasyncXMLResourceValue>();
            for (DatasyncResourceValue resource : resources) {
                if (includingResourcePayload) {
                    xmlResources.add(DatasyncXMLConverter.convertDatasyncResourceValue(resource));
                    continue;
                }
                xmlResources.add(DatasyncXMLConverter.convertDatasyncResourceValueWithoutPayload(resource));
            }
            xmlValue.setResources(xmlResources);
        }
        xmlValue.setTaskId(value.getTaskId());
        xmlValue.setTaskInfo(value.getTaskInfo());
        xmlValue.setValidFrom(value.getValidFrom());
        xmlValue.setValidTill(value.getValidTill());
        return xmlValue;
    }
}

