/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.efm4.impl;

import de.proveo.idm.core.gui.navigation.api.Capability;
import de.proveo.idm.core.gui.navigation.api.Credentials;
import de.proveo.idm.core.gui.navigation.api.Device;
import de.proveo.idm.core.gui.util.DialogUtil;
import de.proveo.idm.remote.server.api.EFMServerUnitAdministration;
import de.proveo.idm.remote.server.api.IDMLoginResponse;
import de.proveo.idm.remote.server.api.RemoteOperatorAdapter;
import de.proveo.idm.remote.server.api.RemotePathAdapter;
import de.proveo.idm.remote.server.api.RemoteUpdateAdapter;
import de.proveo.idm.remote.server.api.UnitTreeElement;
import de.proveo.idm.remote.server.api.ZeroConfUnit;
import de.proveo.idm.remote.server.api.impl.AbstractEFMServer;
import de.proveo.idm.remote.server.api.impl.HttpClientFactory;
import de.proveo.idm.remote.server.efm4.impl.LoginResponseAdapter;
import de.proveo.idm.remote.server.efm4.impl.RemoteInfomanImpl;
import de.proveo.idm.remote.server.efm4.impl.RemoteUpdateAdapterImpl;
import de.proveo.idm.remote.server.services.ShaSumGenerator;
import de.proveo.idm.ssh.service.SSHConnection;
import de.proveo.util.connection.LoginResponse;
import de.proveo.util.unit.tree.UnitTreeNodeBean;
import de.proveo.wwt.logic.ejb.general.infoman.setup.CurrentInfomanSetupValue;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleXMLRPCCall;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleXMLRPCCallFactory;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleXMLRPCClient;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.openide.util.NbBundle;

public class EFMServer4
extends AbstractEFMServer {
    private static final Logger log = Logger.getLogger(EFMServer4.class.getName());
    private RemoteUpdateAdapterImpl remoteUpdateAdapter;
    protected char[] passwordHash;
    private URL connectionURL;

    public EFMServer4() {
        this.capabilities.add(Capability.EDIT_CONFIGURATION);
        this.capabilities.add(Capability.UPDATE_SOFTWARE_FOR_DEVICE);
        this.capabilities.add(Capability.UNIT_OVERVIEW);
        this.capabilities.add(Capability.SOFTWARE_OVERVIEW);
        this.connectionURL = this.serverURL;
    }

    public SortedMap<String, String> getEnv() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public UnitTreeElement getUnits() throws Exception {
        UnitTreeNodeBean unitTreeNode;
        if (this.loginCredentials == null) {
            throw new IllegalStateException("There is no user logged in!");
        }
        HashMap<String, Object> callValues = new HashMap<String, Object>();
        callValues.put("username", this.loginCredentials.getUsername());
        callValues.put("password", this.passwordHash);
        try {
            unitTreeNode = (UnitTreeNodeBean)this.executeCall("GetUnitTree", callValues);
        }
        catch (NullPointerException ex) {
            log.log(Level.SEVERE, "runs into", ex);
            String msg = NbBundle.getMessage(EFMServer4.class, (String)"EFMServer4.warn.noUnitTree", (Object)this.loginCredentials.getUsername());
            DialogUtil.showWarnDialog((Object)msg);
            return null;
        }
        return this.createUnitTree(unitTreeNode);
    }

    public String getTimeZoneID() {
        return TimeZone.getDefault().getID();
    }

    private UnitTreeElement createUnitTree(UnitTreeNodeBean unitNode) {
        UnitTreeElement parent;
        String unitName = unitNode.getUnitName();
        List children = unitNode.getChildren();
        if (!unitNode.isBasic()) {
            parent = new UnitTreeElement((Object)unitName);
            if (children != null) {
                ArrayList<UnitTreeElement> group = new ArrayList<UnitTreeElement>();
                for (UnitTreeNodeBean childUnitNode : children) {
                    UnitTreeElement childTreeNode = this.createUnitTree(childUnitNode);
                    group.add(childTreeNode);
                }
                parent.setChildren(group);
            }
        } else {
            RemoteInfomanImpl infoman = new RemoteInfomanImpl(this, unitNode.getUnitId(), unitNode.getUnitName());
            String icon = UnitTreeElement.lookupIconBase(EFMServer4.class, (String)unitNode.getImageName(), (Device.DeviceType)infoman.getDeviceType());
            parent = new UnitTreeElement((Object)infoman, icon);
            this.units.add(infoman);
        }
        return parent;
    }

    public List<ZeroConfUnit> getNotInstalledUnits() throws SocketTimeoutException {
        throw new UnsupportedOperationException("Not supported by this server version");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteUpdateAdapter getRemoteUpdateAdapter() {
        EFMServer4 eFMServer4 = this;
        synchronized (eFMServer4) {
            if (this.remoteUpdateAdapter == null) {
                this.remoteUpdateAdapter = new RemoteUpdateAdapterImpl(this);
            }
        }
        return this.remoteUpdateAdapter;
    }

    public RemoteOperatorAdapter getRemoteOperatorAdapter() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public RemotePathAdapter getRemotePathAdapter() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public synchronized IDMLoginResponse login(Credentials credentials) throws Exception {
        this.loginCredentials = credentials;
        if (this.loginCredentials == null) {
            return null;
        }
        this.passwordHash = ShaSumGenerator.plainStringToSHA1((String)new String(credentials.getPassword())).toCharArray();
        HashMap<String, Object> callValues = new HashMap<String, Object>();
        callValues.put("username", credentials.getUsername());
        callValues.put("password", this.passwordHash);
        LoginResponse response = (LoginResponse)this.executeCall("Login", callValues);
        if (log.isLoggable(Level.FINE)) {
            ToStringBuilder dump = new ToStringBuilder((Object)response);
            dump.append("accessPermitted", response.isAccessPermitted());
            dump.append("firstName", (Object)response.getFirstName());
            dump.append("lastName", (Object)response.getLastName());
            dump.append("username", (Object)response.getUsername());
            dump.append("portalPermissions", (Object)response.getPortalPermissions());
            log.log(Level.FINE, "login() {0}", dump.toString());
        }
        this.loginResponse = new LoginResponseAdapter(response);
        if (!this.loginResponse.isAccessPermitted()) {
            String msg = NbBundle.getMessage(EFMServer4.class, (String)"EFMServer4.error.login", (Object)this.loginCredentials.getUsername());
            DialogUtil.showErrorDialog((Object)msg);
        }
        return this.loginResponse;
    }

    protected CurrentInfomanSetupValue getSetupForInfoman(long unitId) throws Exception {
        if (this.loginCredentials == null) {
            throw new IllegalStateException("There is no user logged in!");
        }
        HashMap<String, Object> callValues = new HashMap<String, Object>();
        callValues.put("unitId", unitId);
        callValues.put("username", this.loginCredentials.getUsername());
        callValues.put("password", this.passwordHash);
        return (CurrentInfomanSetupValue)this.executeCall("GetCurrentInfomanSetup", callValues);
    }

    public synchronized void logoff() {
        super.logoff();
        this.passwordHash = null;
    }

    private SimpleXMLRPCClient createSimpleXMLRCPClient() throws Exception {
        if (this.tunnel != null && !this.tunnel.isEmpty()) {
            this.connection = new SSHConnection();
            this.connection.addTunnel(this.tunnel);
            this.connection.establishTunnel(this.serverURL.toString());
            this.connectionPort = this.connection.getConnectionPort();
            this.connectionURL = new URL(this.serverURL.getProtocol(), "localhost", this.connectionPort, this.serverURL.getFile());
        } else {
            this.connectionURL = this.serverURL;
        }
        String uriPath = "datain/simpleXML-RPC";
        String uriString = (this.connectionURL.toString().endsWith("/") ? this.connectionURL.toString() : this.connectionURL.toString() + "/") + uriPath;
        SimpleXMLRPCClient newClient = new SimpleXMLRPCClient(uriString);
        HttpClient httpClient = newClient.getHttpClient();
        HttpClientFactory.configureHttpClient((HttpClient)httpClient, (String)this.connectionURL.getProtocol(), (String)this.connectionURL.getHost(), (int)this.connectionURL.getPort(), (int)this.serverURL.getPort(), (String)uriPath, (int)60000, (int)60000);
        newClient.setRequestCompression(false);
        newClient.setAcceptCompression(false);
        return newClient;
    }

    protected Object executeCall(String method, Map<String, Object> callValues) throws Exception {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        SSHConnection tmpConnection = null;
        Object value = null;
        try {
            URL tmpConnectionURL;
            ClassLoader thisLoader = ((Object)((Object)this)).getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(thisLoader);
            if (this.tunnel != null && !this.tunnel.isEmpty()) {
                tmpConnection = new SSHConnection();
                tmpConnection.addTunnel(this.tunnel);
                tmpConnection.establishTunnel(this.serverURL.toString());
                int tmpConnectionPort = tmpConnection.getConnectionPort();
                tmpConnectionURL = new URL(this.serverURL.getProtocol(), "localhost", tmpConnectionPort, this.serverURL.getFile());
            } else {
                tmpConnectionURL = this.serverURL;
            }
            String uriPath = "datain/simpleXML-RPC";
            String uriString = (tmpConnectionURL.toString().endsWith("/") ? tmpConnectionURL.toString() : tmpConnectionURL.toString() + "/") + uriPath;
            SimpleXMLRPCClient client = new SimpleXMLRPCClient(uriString);
            HttpClient httpClient = client.getHttpClient();
            HttpClientFactory.configureHttpClient((HttpClient)httpClient, (String)tmpConnectionURL.getProtocol(), (String)tmpConnectionURL.getHost(), (int)tmpConnectionURL.getPort(), (int)this.serverURL.getPort(), (String)uriPath, (int)60000, (int)60000);
            client.setRequestCompression(false);
            client.setAcceptCompression(false);
            SimpleXMLRPCCall call = SimpleXMLRPCCallFactory.createCall();
            call.setMethod(method);
            for (String key : callValues.keySet()) {
                call.addParameter(key, callValues.get(key));
            }
            value = client.execute(call);
        }
        catch (ConnectTimeoutException ex) {
            ConnectException e = new ConnectException(ex.getMessage());
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
        finally {
            if (tmpConnection != null) {
                tmpConnection.disconnect();
            }
            if (original != null) {
                Thread.currentThread().setContextClassLoader(original);
            }
        }
        return value;
    }

    public String getURL() {
        URL url;
        URL uRL = url = this.connectionURL == null ? this.serverURL : this.connectionURL;
        if (url != null) {
            return url.toString();
        }
        return "";
    }

    public EFMServerUnitAdministration getUnitAdministration() {
        return null;
    }
}

