/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.file.utilities.dialogs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import de.proveo.idm.file.utilities.IDMOpenFileImpl;
import de.proveo.idm.file.utilities.interfaces.OpenFileHandler;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import org.openide.util.NbBundle;

public class FileHandlerChooser
extends PanelBuilder {
    private final CellConstraints cc = new CellConstraints();
    private final ButtonGroup btnGroup = new ButtonGroup();
    private List<OpenFileHandler> possibleHandlers;

    public FileHandlerChooser(List<OpenFileHandler> possibleHandlers) {
        super(new FormLayout("3dlu, fill:default:grow, 3dlu", "3dlu, p, 3dlu, p, 3dlu"));
        this.possibleHandlers = possibleHandlers;
        this.init();
    }

    private void init() {
        this.addLabel(NbBundle.getMessage(IDMOpenFileImpl.class, (String)"MoreThanOneFile"), this.cc.xy(2, 2));
        this.addLabel(NbBundle.getMessage(IDMOpenFileImpl.class, (String)"PleaseChooseHanlder"), this.cc.xy(2, 4));
        int rowOffset = 6;
        for (OpenFileHandler ofh : this.possibleHandlers) {
            this.getLayout().appendRow(RowSpec.decode((String)"p"));
            this.getLayout().appendRow(RowSpec.decode((String)"3dlu"));
            JRadioButton rdBtn = new JRadioButton(ofh.getName());
            this.btnGroup.add(rdBtn);
            if (rowOffset == 6) {
                rdBtn.setSelected(true);
            }
            this.add(rdBtn, this.cc.xy(2, rowOffset));
            rowOffset += 2;
        }
    }

    public OpenFileHandler getSelectedHandler() {
        Enumeration<AbstractButton> rdButtons = this.btnGroup.getElements();
        while (rdButtons.hasMoreElements()) {
            AbstractButton btn = rdButtons.nextElement();
            if (!btn.isSelected()) continue;
            String chosenHandler = btn.getText();
            for (OpenFileHandler ofh : this.possibleHandlers) {
                if (!ofh.getName().equals(chosenHandler)) continue;
                return ofh;
            }
        }
        return null;
    }
}

