/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.file.utilities;

import de.proveo.idm.core.gui.util.DialogUtil;
import de.proveo.idm.file.utilities.dialogs.FileHandlerChooser;
import de.proveo.idm.file.utilities.interfaces.OpenFileHandler;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.SwingUtilities;
import org.netbeans.modules.openfile.DefaultOpenFileImpl;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class IDMOpenFileImpl
extends DefaultOpenFileImpl {
    private static final Object lock = new Object();
    private Boolean _returnValue = null;

    public boolean open(FileObject fileObject, int line) {
        boolean ret = false;
        if (fileObject != null) {
            OpenFileHandler ofh;
            ArrayList<OpenFileHandler> possibleHandlers = new ArrayList<OpenFileHandler>();
            Collection handlers = Lookup.getDefault().lookupAll(OpenFileHandler.class);
            for (Object obj : handlers) {
                if (!(obj instanceof OpenFileHandler) || !(ofh = (OpenFileHandler)obj).canHandle(fileObject)) continue;
                possibleHandlers.add(ofh);
            }
            if (!possibleHandlers.isEmpty()) {
                FileHandlerChooser fhc;
                Object option;
                ret = possibleHandlers.size() == 1 ? this._open((OpenFileHandler)possibleHandlers.get(0), fileObject) : (DialogUtil.OK_OPTION.equals(option = DialogUtil.showOkCancelQuestionDialog((Object)(fhc = new FileHandlerChooser(possibleHandlers)).getPanel(), (String)String.format(NbBundle.getMessage(IDMOpenFileImpl.class, (String)"OpenWith"), fileObject.getNameExt()))) ? ((ofh = fhc.getSelectedHandler()) != null ? this._open(ofh, fileObject) : true) : true);
            }
        }
        if (!ret) {
            return super.open(fileObject, line);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _open(final OpenFileHandler ofh, final FileObject fileObject) {
        if (SwingUtilities.isEventDispatchThread()) {
            return ofh.openFile(FileUtil.toFile((FileObject)fileObject));
        }
        this._returnValue = null;
        Runnable run = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = lock;
                synchronized (object) {
                    IDMOpenFileImpl.this._returnValue = ofh.openFile(FileUtil.toFile((FileObject)fileObject));
                    lock.notifyAll();
                }
            }
        };
        SwingUtilities.invokeLater(run);
        Object object = lock;
        synchronized (object) {
            while (this._returnValue == null) {
                try {
                    lock.wait(100L);
                }
                catch (Throwable ex) {}
            }
            return this._returnValue;
        }
    }
}

