/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.event.util.raw.tcp;

import de.proveo.event.util.raw.MonitoringListener;
import de.proveo.event.util.raw.Worker;
import de.proveo.event.util.raw.WorkerMonitoring;
import de.proveo.event.util.raw.WorkerStatusInfo;
import de.proveo.event.util.raw.tcp.StreamConnectionHandler;
import de.proveo.rts.configuration.interfaces.event.EventInterfaceMBean;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Date;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StreamWorker
implements Worker,
Runnable,
Thread.UncaughtExceptionHandler {
    private static final Log log = LogFactory.getLog(StreamWorker.class);
    final Thread thread;
    final ServerSocket serverSocket;
    StreamConnectionHandler connectionHandler;
    private int socketTimeout;
    private EventInterfaceMBean eventInterfaceMBean;
    volatile boolean stoped;
    volatile long connectedTime;
    volatile WorkerMonitoring.TransportLayerStatus status = WorkerMonitoring.TransportLayerStatus.DISCONNECTED;
    volatile SocketAddress remoteSocketAddress;
    volatile MonitoringListener listener;
    private final WorkerMonitoring monitoringWrapper = new WorkerMonitoring(){

        public WorkerStatusInfo getWorkerStatusInfo() {
            return new WorkerStatusInfo(StreamWorker.this.status, new Date(StreamWorker.this.connectedTime), StreamWorker.this.remoteSocketAddress, StreamWorker.this.connectionHandler != null ? StreamWorker.this.connectionHandler.getBytesRX() : 0, StreamWorker.this.connectionHandler != null ? StreamWorker.this.connectionHandler.getBytesTX() : 0, StreamWorker.this.connectionHandler.getIdentification(), StreamWorker.this.connectionHandler.getUnitIDs(), new Long(System.currentTimeMillis() - StreamWorker.this.connectedTime).toString(), StreamWorker.this.connectionHandler != null ? StreamWorker.this.connectionHandler.getApplicationLayerStatus() : null, StreamWorker.this.thread.getName());
        }
    };

    public void setEventInterfaceMBean(EventInterfaceMBean eventInterfaceMBean) {
        this.eventInterfaceMBean = eventInterfaceMBean;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void setConnectionHandler(StreamConnectionHandler connectionHandler) {
        if (connectionHandler == null) {
            throw new IllegalArgumentException("connectionHandler cannot be null");
        }
        this.connectionHandler = connectionHandler;
    }

    public StreamWorker(ThreadGroup group, String name, ServerSocket serverSocket) {
        if (group == null || name == null || serverSocket == null) {
            throw new IllegalArgumentException("parameter cannot be null. group:" + group + " name:" + name + " serverSocket:" + serverSocket);
        }
        this.thread = new Thread(group, this, name);
        this.thread.setUncaughtExceptionHandler(this);
        this.serverSocket = serverSocket;
    }

    public void stop() {
        this.stoped = true;
    }

    public void start() {
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.stoped) {
            Socket socket = null;
            if (this.eventInterfaceMBean != null && this.eventInterfaceMBean.isEventInterfaceDisabled()) {
                this.eventInterfaceMBean.waitUntilEventInterfaceBecomesEnabled();
            }
            try {
                socket = this.waitForConnection();
                this.processConnection(socket);
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) continue;
                String id = null;
                if (this.connectionHandler != null) {
                    id = this.connectionHandler.getIdentification();
                }
                log.debug((Object)(socket + " (" + id + ") runs into"), (Throwable)ex);
            }
            finally {
                this.closeConnection(socket);
            }
        }
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("thread", (Object)this.thread);
        builder.append("serverSocket", (Object)this.serverSocket);
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnection(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception ex) {
                log.error((Object)"runs during close socket into", (Throwable)ex);
            }
            finally {
                this.remoteSocketAddress = null;
                this.status = WorkerMonitoring.TransportLayerStatus.DISCONNECTED;
                this.connectedTime = 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Socket waitForConnection() throws IOException {
        Socket socket;
        this.status = WorkerMonitoring.TransportLayerStatus.WAITING;
        ServerSocket serverSocket = this.serverSocket;
        synchronized (serverSocket) {
            socket = this.serverSocket.accept();
        }
        this.connectedTime = System.currentTimeMillis();
        this.remoteSocketAddress = socket.getRemoteSocketAddress();
        this.status = WorkerMonitoring.TransportLayerStatus.CONNECTED;
        socket.setSoTimeout(this.socketTimeout);
        this.fireWorkerConnected(this.remoteSocketAddress);
        return socket;
    }

    void fireWorkerConnected(SocketAddress remoteSocketAddress) {
        MonitoringListener localListener = this.listener;
        if (localListener != null) {
            localListener.workerConnected(this, remoteSocketAddress);
        }
    }

    void fireWorkerUncaughtException(Throwable e) {
        MonitoringListener localListener = this.listener;
        if (localListener != null) {
            localListener.workerUncaughtException(this, e);
        }
    }

    private void processConnection(Socket socket) throws IOException {
        if (this.connectionHandler != null) {
            this.connectionHandler.processConnection(socket);
        }
    }

    public void uncaughtException(Thread t, Throwable e) {
        this.fireWorkerUncaughtException(e);
    }

    public void setMonitoringListener(MonitoringListener listener) {
        this.listener = listener;
    }

    public WorkerMonitoring getMonitoring() {
        return this.monitoringWrapper;
    }
}

