/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.event.util.raw.tcp;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ProgressMonitorOutputStream
extends FilterOutputStream {
    volatile int bytesWrite;

    public int getBytesWrite() {
        return this.bytesWrite;
    }

    public ProgressMonitorOutputStream(OutputStream out) {
        super(out);
        if (out == null) {
            throw new NullPointerException();
        }
    }

    public void write(int b) throws IOException {
        super.write(b);
        ++this.bytesWrite;
    }

    public void write(byte[] b) throws IOException {
        super.write(b);
        this.bytesWrite += b.length;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        this.bytesWrite += len;
    }
}

