/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.event.util.raw;

import de.proveo.event.util.raw.MonitoringListener;
import de.proveo.event.util.raw.Worker;
import de.proveo.event.util.raw.WorkerMonitoring;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WorkerPool
implements MonitoringListener {
    private final Collection<Worker> workers = new ArrayList<Worker>();
    protected final Log log;
    private int poolSize;
    private MonitoringListener monitoringListener;
    private boolean started;

    protected WorkerPool(Log log) {
        this.log = log;
    }

    public MonitoringListener getMonitoringListener() {
        return this.monitoringListener;
    }

    public void setMonitoringListener(MonitoringListener monitoringListener) {
        this.monitoringListener = monitoringListener;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public synchronized void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
        if (this.started) {
            this.poolSizeUpdate();
        }
    }

    public synchronized void stop() {
        Iterator<Worker> it = this.workers.iterator();
        while (it.hasNext()) {
            it.next().stop();
        }
        this.workers.clear();
        this.started = false;
        this.log.trace((Object)"worker pool stopped");
    }

    public synchronized void start() {
        this.poolSizeUpdate();
        this.started = true;
        this.log.trace((Object)"worker pool started");
    }

    @Override
    public void workerConnected(Worker worker, SocketAddress remoteSocketAdderss) {
    }

    @Override
    public synchronized void workerUncaughtException(Worker worker, Throwable e) {
        if (this.log.isErrorEnabled()) {
            this.log.error((Object)("workerUncaughtException() " + worker), e);
        }
        if (this.workers.remove(worker)) {
            try {
                this.poolSizeUpdate();
            }
            catch (Exception ex) {
                this.log.error((Object)"workerUncaughtException() runs into", (Throwable)ex);
            }
        }
    }

    protected synchronized void poolSizeUpdate() {
        int diff = this.poolSize - this.workers.size();
        if (diff > 0) {
            for (int index = 0; index < diff; ++index) {
                Worker worker = this.createWorker();
                worker.setMonitoringListener(this.monitoringListener);
                worker.start();
                this.workers.add(worker);
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace((Object)("poolSizeUpdate() worker started " + worker));
            }
        }
    }

    public synchronized Collection<WorkerMonitoring> getWorkerMonitoring() {
        ArrayList<WorkerMonitoring> monitoring = new ArrayList<WorkerMonitoring>();
        for (Worker worker : this.workers) {
            monitoring.add(worker.getMonitoring());
        }
        return monitoring;
    }

    protected abstract Worker createWorker();
}

