/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.event.util.raw;

import de.proveo.event.util.raw.ByteArrayParser;
import de.proveo.event.util.raw.ByteUtil;
import java.nio.charset.Charset;

public class ByteArrayBigEndianParser
implements ByteArrayParser {
    private final byte[] buffer;

    public byte[] getBuffer() {
        return this.buffer;
    }

    public ByteArrayBigEndianParser(ByteArrayParser byteArrayParser) {
        this.buffer = byteArrayParser.getBuffer();
    }

    public ByteArrayBigEndianParser(byte[] buffer) {
        this.buffer = buffer;
    }

    public int getUnsignedByte(int byteIndex) throws IndexOutOfBoundsException {
        if (byteIndex < 0 || byteIndex >= this.buffer.length) {
            throw new IndexOutOfBoundsException("Index out of bounds (byte[] index = " + byteIndex + " / byte[] size = " + this.buffer.length + ")");
        }
        return ByteUtil.getInteger(this.buffer[byteIndex]);
    }

    public int getUnsignedBytes(int byteIndex, int amountOfBytes) throws IndexOutOfBoundsException, IllegalArgumentException, UnsupportedOperationException {
        int b;
        int length = byteIndex + amountOfBytes - 1;
        if (byteIndex < 0 || length >= this.buffer.length) {
            throw new IndexOutOfBoundsException("Index out of bounds (byte[] index = " + byteIndex + " / amountOfBytes = " + amountOfBytes + " / byte[] size = " + this.buffer.length + ")");
        }
        if (amountOfBytes <= 0) {
            throw new IllegalArgumentException("Amount of bytes cannot be zero or below: " + amountOfBytes);
        }
        if (amountOfBytes > 4) {
            throw new UnsupportedOperationException("Number too large for an Integer!");
        }
        if (amountOfBytes == 4 && (b = this.getUnsignedByte(length)) > 127) {
            throw new UnsupportedOperationException("Number too large for an Integer!");
        }
        if (amountOfBytes == 1) {
            return this.getUnsignedByte(byteIndex);
        }
        int ret = 0;
        for (int i = length; i >= byteIndex; --i) {
            int b2 = this.getUnsignedByte(i);
            ret |= b2;
            if (i <= byteIndex) continue;
            ret <<= 8;
        }
        return ret;
    }

    public int getUnsignedBits(int byteIndex, int bitIndex, int amountOfBits) throws IndexOutOfBoundsException, IllegalArgumentException, UnsupportedOperationException {
        int b;
        int length = byteIndex + (bitIndex + amountOfBits) / 8;
        if ((bitIndex + amountOfBits) % 8 == 0) {
            --length;
        }
        if (byteIndex < 0 || length >= this.buffer.length) {
            throw new IndexOutOfBoundsException("Index out of bounds (byte index = " + byteIndex + " / amountOfBits = " + amountOfBits + " / byte[] size = " + this.buffer.length + ")");
        }
        if (bitIndex < 0 || bitIndex > 7) {
            throw new IllegalArgumentException("Bit index cannot be smaller than 0 or larger than 7, bit index has to be inside given byte index: " + bitIndex);
        }
        if (amountOfBits <= 0) {
            throw new IllegalArgumentException("Amount of bits cannot be zero or below: " + amountOfBits);
        }
        if (amountOfBits / 8 > 4) {
            throw new UnsupportedOperationException("Number too large for an Integer!");
        }
        if (amountOfBits / 8 == 4 && (b = this.getUnsignedByte(length)) > 127) {
            throw new UnsupportedOperationException("Number too large for an Integer!");
        }
        if (bitIndex % 8 == 0 && amountOfBits % 8 == 0) {
            return this.getUnsignedBytes(byteIndex + bitIndex / 8, amountOfBits / 8);
        }
        int ret = 0;
        for (int i = length; i >= byteIndex; --i) {
            int mask;
            int b2 = this.getUnsignedByte(i);
            if (i == length) {
                int j;
                mask = 1;
                int maskLength = amountOfBits % 8 + bitIndex;
                maskLength -= maskLength / 8 * 8;
                if (length == byteIndex) {
                    mask = 0;
                    for (j = bitIndex + amountOfBits - 1; j >= 0; --j) {
                        mask <<= 1;
                        if (j < bitIndex) continue;
                        mask |= 1;
                    }
                    b2 &= mask;
                    b2 >>>= bitIndex;
                } else if (maskLength != 0) {
                    for (j = 0; j < maskLength - 1; ++j) {
                        mask <<= 1;
                        mask |= 1;
                    }
                    b2 &= mask;
                }
                ret |= b2;
                if (i - 1 <= byteIndex) continue;
                ret <<= 8;
                continue;
            }
            if (i == byteIndex) {
                mask = 128;
                for (int j = 0; j < 7 - bitIndex; ++j) {
                    mask >>= 1;
                    mask |= 0x80;
                }
                b2 &= mask;
                ret <<= 8 - bitIndex;
                ret |= (b2 >>>= bitIndex);
                continue;
            }
            ret |= b2;
            if (i - 1 <= byteIndex) continue;
            ret <<= 8;
        }
        return ret;
    }

    public long getUnsignedBytesAsLong(int byteIndex, int amountOfBytes) throws IndexOutOfBoundsException, IllegalArgumentException, UnsupportedOperationException {
        int length = byteIndex + amountOfBytes - 1;
        if (byteIndex < 0 || length >= this.buffer.length) {
            throw new IndexOutOfBoundsException("Index out of bounds (byte[] index = " + byteIndex + " / amountOfBytes = " + amountOfBytes + " / byte[] size = " + this.buffer.length + ")");
        }
        if (amountOfBytes <= 0) {
            throw new IllegalArgumentException("Amount of bytes cannot be zero or below: " + amountOfBytes);
        }
        if (amountOfBytes > 8) {
            throw new UnsupportedOperationException("Number too large for a Long!");
        }
        if (amountOfBytes == 8) {
            int b = this.getUnsignedByte(length);
            if (b > 127) {
                throw new UnsupportedOperationException("Number too large for a Long!");
            }
        } else {
            if (amountOfBytes == 1) {
                return this.getUnsignedByte(byteIndex);
            }
            if (amountOfBytes <= 4) {
                return this.getUnsignedBytes(byteIndex, amountOfBytes);
            }
        }
        long ret = 0L;
        for (int i = length; i >= byteIndex; --i) {
            int b = this.getUnsignedByte(i);
            ret |= (long)b;
            if (i <= byteIndex) continue;
            ret <<= 8;
        }
        return ret;
    }

    public long getUnsignedBitsAsLong(int byteIndex, int bitIndex, int amountOfBits) throws IndexOutOfBoundsException, IllegalArgumentException, UnsupportedOperationException {
        int b;
        int length = byteIndex + (bitIndex + amountOfBits) / 8;
        if ((bitIndex + amountOfBits) % 8 == 0) {
            --length;
        }
        if (byteIndex < 0 || length >= this.buffer.length) {
            throw new IndexOutOfBoundsException("Index out of bounds (byte index = " + byteIndex + " / amountOfBits = " + amountOfBits + " / byte[] size = " + this.buffer.length + ")");
        }
        if (bitIndex < 0 || bitIndex > 7) {
            throw new IllegalArgumentException("Bit index cannot be smaller than 0 or larger than 7, bit index has to be inside given byte index: " + bitIndex);
        }
        if (amountOfBits <= 0) {
            throw new IllegalArgumentException("Amount of bits cannot be zero or below: " + amountOfBits);
        }
        if (amountOfBits / 8 > 8) {
            throw new UnsupportedOperationException("Number too large for a Long!");
        }
        if (amountOfBits / 8 == 8) {
            b = this.getUnsignedByte(length);
            if (b > 127) {
                throw new UnsupportedOperationException("Number too large for a Long!");
            }
        } else if (amountOfBits / 8 <= 4) {
            if (bitIndex % 8 == 0 && amountOfBits % 8 == 0) {
                return this.getUnsignedBytes(byteIndex + bitIndex / 8, amountOfBits / 8);
            }
            b = this.getUnsignedByte(length);
            if (b <= 127) {
                return this.getUnsignedBits(byteIndex, bitIndex, amountOfBits);
            }
        } else if (bitIndex % 8 == 0 && amountOfBits % 8 == 0) {
            return this.getUnsignedBytesAsLong(byteIndex + bitIndex / 8, amountOfBits / 8);
        }
        long ret = 0L;
        for (int i = length; i >= byteIndex; --i) {
            int mask;
            int b2 = this.getUnsignedByte(i);
            if (i == length) {
                int j;
                mask = 1;
                int maskLength = amountOfBits % 8 + bitIndex;
                maskLength -= maskLength / 8 * 8;
                if (length == byteIndex) {
                    mask = 0;
                    for (j = bitIndex + amountOfBits - 1; j >= 0; --j) {
                        mask <<= 1;
                        if (j < bitIndex) continue;
                        mask |= 1;
                    }
                    b2 &= mask;
                    b2 >>>= bitIndex;
                } else if (maskLength != 0) {
                    for (j = 0; j < maskLength - 1; ++j) {
                        mask <<= 1;
                        mask |= 1;
                    }
                    b2 &= mask;
                }
                ret |= (long)b2;
                if (i - 1 <= byteIndex) continue;
                ret <<= 8;
                continue;
            }
            if (i == byteIndex) {
                mask = 128;
                for (int j = 0; j < 7 - bitIndex; ++j) {
                    mask >>= 1;
                    mask |= 0x80;
                }
                b2 &= mask;
                ret <<= 8 - bitIndex;
                ret |= (long)(b2 >>>= bitIndex);
                continue;
            }
            ret |= (long)b2;
            if (i - 1 <= byteIndex) continue;
            ret <<= 8;
        }
        return ret;
    }

    public byte getSignedByte(int byteIndex) throws IndexOutOfBoundsException {
        if (byteIndex < 0 || byteIndex >= this.buffer.length) {
            throw new IndexOutOfBoundsException("Index out of bounds (byte[] index = " + byteIndex + " / byte[] size = " + this.buffer.length + ")");
        }
        return this.buffer[byteIndex];
    }

    public int getSignedBytes(int byteIndex, int amountOfBytes) throws IndexOutOfBoundsException, IllegalArgumentException, UnsupportedOperationException {
        int ret;
        int length = byteIndex + amountOfBytes - 1;
        if (byteIndex < 0 || length >= this.buffer.length) {
            throw new IndexOutOfBoundsException("Index out of bounds (byte[] index = " + byteIndex + " / amountOfBytes = " + amountOfBytes + " / byte[] size = " + this.buffer.length + ")");
        }
        if (amountOfBytes <= 0) {
            throw new IllegalArgumentException("Amount of bytes cannot be zero or below: " + amountOfBytes);
        }
        if (amountOfBytes > 4) {
            throw new UnsupportedOperationException("Number too large for an Integer!");
        }
        if (amountOfBytes == 1) {
            return this.getSignedByte(byteIndex);
        }
        try {
            boolean negative;
            ret = this.getUnsignedBytes(byteIndex, amountOfBytes);
            int signMask = amountOfBytes * 8 - 1;
            int signBit = ret >>> signMask;
            boolean bl = negative = signBit == 1;
            if (negative) {
                ret = this.getNegativeInteger(ret, amountOfBytes * 8);
            }
        }
        catch (UnsupportedOperationException ex) {
            ret = this.getUnsignedBits(byteIndex, 0, amountOfBytes * 8 - 1);
            ret = this.getNegativeInteger(ret, amountOfBytes * 8 - 1);
        }
        return ret;
    }

    public int getSignedBits(int byteIndex, int bitIndex, int amountOfBits) throws IndexOutOfBoundsException, IllegalArgumentException, UnsupportedOperationException {
        int ret;
        int length = byteIndex + (bitIndex + amountOfBits) / 8;
        if ((bitIndex + amountOfBits) % 8 == 0) {
            --length;
        }
        if (byteIndex < 0 || length >= this.buffer.length) {
            throw new IndexOutOfBoundsException("Index out of bounds (byte index = " + byteIndex + " / amountOfBits = " + amountOfBits + " / byte[] size = " + this.buffer.length + ")");
        }
        if (bitIndex < 0 || bitIndex > 7) {
            throw new IllegalArgumentException("Bit index cannot be smaller than 0 or larger than 7, bit index has to be inside given byte index: " + bitIndex);
        }
        if (amountOfBits <= 1) {
            throw new IllegalArgumentException("Amount of bits cannot be one or below: " + amountOfBits);
        }
        if (amountOfBits / 8 > 4) {
            throw new UnsupportedOperationException("Number too large for an Integer!");
        }
        if (bitIndex % 8 == 0 && amountOfBits % 8 == 0) {
            return this.getSignedBytes(byteIndex + bitIndex / 8, amountOfBits / 8);
        }
        try {
            boolean negative;
            ret = this.getUnsignedBits(byteIndex, bitIndex, amountOfBits);
            int signMask = amountOfBits - 1;
            int signBit = ret >>> signMask;
            boolean bl = negative = signBit == 1;
            if (negative) {
                ret = this.getNegativeInteger(ret, amountOfBits);
            }
        }
        catch (UnsupportedOperationException ex) {
            ret = this.getUnsignedBits(byteIndex, bitIndex, amountOfBits - 1);
            ret = this.getNegativeInteger(ret, amountOfBits - 1);
        }
        return ret;
    }

    public long getSignedBytesAsLong(int byteIndex, int amountOfBytes) throws IndexOutOfBoundsException, IllegalArgumentException {
        long ret;
        int length = byteIndex + amountOfBytes - 1;
        if (byteIndex < 0 || length >= this.buffer.length) {
            throw new IndexOutOfBoundsException("Index out of bounds (byte[] index = " + byteIndex + " / amountOfBytes = " + amountOfBytes + " / byte[] size = " + this.buffer.length + ")");
        }
        if (amountOfBytes <= 0) {
            throw new IllegalArgumentException("Amount of bytes cannot be zero or below: " + amountOfBytes);
        }
        if (amountOfBytes == 1) {
            return this.getSignedByte(byteIndex);
        }
        if (amountOfBytes <= 4) {
            this.getSignedBytes(byteIndex, amountOfBytes);
        }
        try {
            boolean negative;
            ret = this.getUnsignedBytesAsLong(byteIndex, amountOfBytes);
            int signMask = amountOfBytes * 8 - 1;
            long signBit = ret >>> signMask;
            boolean bl = negative = signBit == 1L;
            if (negative) {
                ret = this.getNegativeLong(ret, amountOfBytes * 8);
            }
        }
        catch (UnsupportedOperationException ex) {
            ret = this.getUnsignedBitsAsLong(byteIndex, 0, amountOfBytes * 8 - 1);
            ret = this.getNegativeLong(ret, amountOfBytes * 8 - 1);
        }
        return ret;
    }

    public long getSignedBitsAsLong(int byteIndex, int bitIndex, int amountOfBits) throws IndexOutOfBoundsException, IllegalArgumentException {
        long ret;
        int length = byteIndex + (bitIndex + amountOfBits) / 8;
        if ((bitIndex + amountOfBits) % 8 == 0) {
            --length;
        }
        if (byteIndex < 0 || length >= this.buffer.length) {
            throw new IndexOutOfBoundsException("Index out of bounds (byte index = " + byteIndex + " / amountOfBits = " + amountOfBits + " / byte[] size = " + this.buffer.length + ")");
        }
        if (bitIndex < 0 || bitIndex > 7) {
            throw new IllegalArgumentException("Bit index cannot be smaller than 0 or larger than 7, bit index has to be inside given byte index: " + bitIndex);
        }
        if (amountOfBits <= 1) {
            throw new IllegalArgumentException("Amount of bits cannot be one or below: " + amountOfBits);
        }
        if (amountOfBits / 8 <= 4) {
            if (bitIndex % 8 == 0 && amountOfBits % 8 == 0) {
                return this.getSignedBytes(byteIndex + bitIndex / 8, amountOfBits / 8);
            }
            int b = this.getUnsignedByte(length);
            if (b < 127) {
                return this.getSignedBits(byteIndex, bitIndex, amountOfBits);
            }
        } else if (bitIndex % 8 == 0 && amountOfBits % 8 == 0) {
            return this.getSignedBytesAsLong(byteIndex + bitIndex / 8, amountOfBits / 8);
        }
        try {
            boolean negative;
            ret = this.getUnsignedBitsAsLong(byteIndex, bitIndex, amountOfBits);
            int signMask = amountOfBits - 1;
            long signBit = ret >>> signMask;
            boolean bl = negative = signBit == 1L;
            if (negative) {
                ret = this.getNegativeLong(ret, amountOfBits);
            }
        }
        catch (UnsupportedOperationException ex) {
            ret = this.getUnsignedBitsAsLong(byteIndex, bitIndex, amountOfBits - 1);
            ret = this.getNegativeLong(ret, amountOfBits - 1);
        }
        return ret;
    }

    public boolean isSet(int byteIndex, int bitIndex) throws IndexOutOfBoundsException, IllegalArgumentException {
        int length = byteIndex + bitIndex / 8 - 1;
        if (byteIndex < 0 || length >= this.buffer.length) {
            throw new IndexOutOfBoundsException("Index out of bounds (byte index = " + byteIndex + " / bit index = " + bitIndex + " / byte[] size = " + this.buffer.length + ")");
        }
        if (bitIndex < 0 || bitIndex > 7) {
            throw new IllegalArgumentException("Bit index cannot be smaller than 0 or larger than 7, bit index has to be inside given byte index: " + bitIndex);
        }
        int mask = 1;
        for (int j = 0; j < bitIndex; ++j) {
            mask <<= 1;
        }
        return (this.getSignedByte(byteIndex) & mask) > 0;
    }

    public String getString(int byteIndex, int amountOfBytes) throws IndexOutOfBoundsException, IllegalArgumentException {
        int strLength;
        int length = byteIndex + amountOfBytes - 1;
        if (byteIndex < 0 || length >= this.buffer.length) {
            throw new IndexOutOfBoundsException("Index out of bounds (byte[] index = " + byteIndex + " / amountOfBytes = " + amountOfBytes + " / byte[] size = " + this.buffer.length + ")");
        }
        if (amountOfBytes <= 0) {
            throw new IllegalArgumentException("Amount of bytes cannot be zero or below: " + amountOfBytes);
        }
        if (this.buffer[byteIndex + amountOfBytes - 1] == 0) {
            byte b;
            strLength = amountOfBytes;
            while ((b = this.buffer[byteIndex + --strLength - 1]) == 0 && strLength != 0) {
            }
        } else {
            strLength = amountOfBytes;
        }
        return new String(this.buffer, byteIndex, strLength, Charset.forName("UTF-8"));
    }

    public String getBCD(int byteIndex, int bitIndex, int digits) throws IndexOutOfBoundsException, IllegalArgumentException {
        int length = byteIndex + (bitIndex + digits * 4) / 8;
        if ((bitIndex + digits * 4) % 8 == 0) {
            --length;
        }
        if (byteIndex < 0 || length >= this.buffer.length) {
            throw new IndexOutOfBoundsException("Index out of bounds (byte index = " + byteIndex + " / digits = " + digits + " / byte[] size = " + this.buffer.length + ")");
        }
        if (bitIndex < 0 || bitIndex > 7) {
            throw new IllegalArgumentException("Bit index cannot be smaller than 0 or larger than 7, bit index has to be inside given byte index: " + bitIndex);
        }
        if (digits <= 0) {
            throw new IllegalArgumentException("Digits cannot be zero or below: " + digits);
        }
        StringBuilder ret = new StringBuilder();
        byte[] tmp = this.getSubArray(byteIndex, bitIndex, digits * 4);
        for (int i = 0; i < tmp.length; ++i) {
            int b = ByteUtil.getInteger(tmp[i]);
            int b1 = b & 0xF;
            if (b1 > 9 || b1 < 0) {
                throw new UnsupportedOperationException("Number out of range for BCD: " + b1);
            }
            ret.append(b1);
            if (i == tmp.length - 1 && digits % 2 != 0) continue;
            int b2 = b & 0xF0;
            if ((b2 >>>= 4) > 9 || b2 < 0) {
                ret.append(Integer.toString(b2, 16));
                continue;
            }
            ret.append(b2);
        }
        return ret.toString();
    }

    public byte[] getByteArray(int byteIndex, int bitIndex, int amountOfBits) throws IndexOutOfBoundsException, IllegalArgumentException {
        int length = byteIndex + (bitIndex + amountOfBits) / 8;
        if ((bitIndex + amountOfBits) % 8 == 0) {
            --length;
        }
        if (byteIndex < 0 || length >= this.buffer.length) {
            throw new IndexOutOfBoundsException("Index out of bounds (byte index = " + byteIndex + " / amountOfBits = " + amountOfBits + " / byte[] size = " + this.buffer.length + ")");
        }
        if (bitIndex < 0 || bitIndex > 7) {
            throw new IllegalArgumentException("Bit index cannot be smaller than 0 or larger than 7, bit index has to be inside given byte index: " + bitIndex);
        }
        if (amountOfBits <= 0) {
            throw new IllegalArgumentException("Amount of bits cannot be zero or below: " + amountOfBits);
        }
        byte[] b = this.getSubArray(byteIndex, bitIndex, amountOfBits);
        byte[] ret = new byte[b.length];
        System.arraycopy(b, 0, ret, 0, b.length);
        return ret;
    }

    protected byte[] getSubArray(int byteIndex, int bitIndex, int amountOfBits) throws IndexOutOfBoundsException, IllegalArgumentException {
        int length = byteIndex + (bitIndex + amountOfBits) / 8;
        if ((bitIndex + amountOfBits) % 8 == 0) {
            --length;
        }
        if (byteIndex < 0 || length >= this.buffer.length) {
            throw new IndexOutOfBoundsException("Index out of bounds (byte index = " + byteIndex + " / amountOfBits = " + amountOfBits + " / byte[] size = " + this.buffer.length + ")");
        }
        if (bitIndex < 0 || bitIndex > 7) {
            throw new IllegalArgumentException("Bit index cannot be smaller than 0 or larger than 7, bit index has to be inside given byte index: " + bitIndex);
        }
        if (amountOfBits <= 0) {
            throw new IllegalArgumentException("Amount of bits cannot be zero or below: " + amountOfBits);
        }
        int size = amountOfBits / 8;
        if (amountOfBits % 8 != 0) {
            ++size;
        }
        int retIndex = size - 1;
        byte[] ret = new byte[size];
        int bIndex = amountOfBits % 8 + bitIndex;
        if ((bIndex -= bIndex / 8 * 8) == 0) {
            bIndex = 8;
        }
        for (int i = length; i >= byteIndex && retIndex >= 0; --i) {
            byte b = this.getSignedByte(i);
            int mask = 1;
            for (int j = 0; j < bIndex - 1; ++j) {
                mask <<= 1;
                mask |= 1;
            }
            b = (byte)(b & mask);
            if (bIndex < 8 && i > 0) {
                if (i == length && retIndex == size - 1 && amountOfBits / 4 % 2 != 0) {
                    bIndex = bitIndex;
                    if (bIndex >= 0 && bIndex < 4) {
                        b = (byte)(b >> bIndex);
                        ret[retIndex--] = b;
                        ++i;
                        continue;
                    }
                } else if (i == byteIndex) {
                    bIndex = bitIndex;
                }
                byte nb = this.getSignedByte(i - 1);
                mask = 128;
                for (int j = 0; j < 7 - bIndex; ++j) {
                    mask >>= 1;
                    mask |= 0x80;
                }
                nb = (byte)(nb & mask);
                nb = (byte)(nb >>> bIndex);
                b = (byte)(b << 8 - bIndex);
                b = (byte)(b | nb);
            }
            ret[retIndex--] = b;
        }
        return ret;
    }

    protected int getNegativeInteger(int signedInt, int length) {
        int signedMask = 1;
        for (int j = 0; j < length - 2; ++j) {
            signedMask <<= 1;
            signedMask |= 1;
        }
        signedInt &= signedMask;
        return ((signedInt ^= signedMask) + 1) * -1;
    }

    protected long getNegativeLong(long signedLong, int length) {
        long signedMask = 1L;
        for (int j = 0; j < length - 2; ++j) {
            signedMask <<= 1;
            signedMask |= 1L;
        }
        signedLong &= signedMask;
        return ((signedLong ^= signedMask) + 1L) * -1L;
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(super.toString());
        strBuilder.append("\n");
        StringBuilder hexStrBuilder = new StringBuilder();
        StringBuilder binStrBuilder = new StringBuilder();
        StringBuilder decStrBuilder = new StringBuilder();
        hexStrBuilder.append("\tHex: ");
        binStrBuilder.append("\tBin: ");
        decStrBuilder.append("\tDec: ");
        for (int i = 0; i < this.buffer.length; ++i) {
            int b = this.buffer[i];
            if (b < 0) {
                b += 256;
            }
            hexStrBuilder.append(Integer.toHexString(b));
            binStrBuilder.append(Integer.toBinaryString(b));
            decStrBuilder.append(b);
            if (i + 1 < this.buffer.length) {
                hexStrBuilder.append(" ");
                binStrBuilder.append(" ");
                decStrBuilder.append(" ");
                continue;
            }
            hexStrBuilder.append("\n");
            binStrBuilder.append("\n");
            decStrBuilder.append("\n");
        }
        strBuilder.append((CharSequence)hexStrBuilder);
        strBuilder.append((CharSequence)binStrBuilder);
        strBuilder.append((CharSequence)decStrBuilder);
        return strBuilder.toString();
    }
}

