/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.event.util;

import de.proveo.event.util.RawEventResponse;
import de.proveo.event.util.efm.groovy.EventParser;
import de.proveo.event.util.raw.ByteUtil;
import de.proveo.eventbase.EventResponse;
import de.proveo.rts.configuration.interfaces.event.DeviceTemporarilyBlockedException;
import de.proveo.rts.configuration.interfaces.event.EventInterfaceMBean;
import de.proveo.rts.configuration.monitor.MonitoringMBean;
import de.proveo.wwt.datamodel.custom.CustomScript;
import de.proveo.wwt.logic.ejb.dataIn.event.mapper.EventMappingRemote;
import de.proveo.wwt.logic.ejb.general.custom.CustomScriptFacadeRemote;
import de.proveo.wwt.logic.ejb.general.custom.ScriptLoader;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeRemote;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEventHandler {
    public static final String META_EFM_UNITIDS = "efm.unitIds";
    private final Log log;
    private EventInterfaceMBean eventInterfaceMBean;
    private MonitoringMBean groovyFailuresMontoringMBean;
    private volatile List<Long> unitIDs;
    CustomScriptFacadeRemote customScriptFacadeRemote;
    UnitFacadeRemote unitFacadeRemote;
    EventMappingRemote eventMapping;
    private volatile String identification;
    private static final String DEFAULT_EVENT_MAPPER_ENTRY_POINT = "infoman.event.3rdparty.eventMapper";
    private MonitoringMBean rawEventMonitoringMBean;
    private MonitoringMBean efmEventMonitoringMBean;

    public EventInterfaceMBean getEventInterfaceMBean() {
        return this.eventInterfaceMBean;
    }

    public void setEventInterfaceMBean(EventInterfaceMBean eventInterfaceMBean) {
        this.eventInterfaceMBean = eventInterfaceMBean;
    }

    public void setGroovyFailuresMontoringMBean(MonitoringMBean groovyFailuresMontoringMBean) {
        this.groovyFailuresMontoringMBean = groovyFailuresMontoringMBean;
    }

    public String getUnitIDs() {
        if (this.unitIDs == null) {
            return "";
        }
        Iterator<Long> it = this.unitIDs.iterator();
        StringBuilder buffer = new StringBuilder();
        while (it.hasNext()) {
            buffer.append(it.next());
        }
        return buffer.toString();
    }

    protected Log getLog() {
        return this.log;
    }

    public void setCustomScriptFacadeRemote(CustomScriptFacadeRemote customScriptFacadeRemote) {
        this.customScriptFacadeRemote = customScriptFacadeRemote;
    }

    public void setUnitFacadeRemote(UnitFacadeRemote unitFacadeRemote) {
        this.unitFacadeRemote = unitFacadeRemote;
    }

    public CustomScriptFacadeRemote getCustomScriptFacadeRemote() {
        return this.customScriptFacadeRemote;
    }

    public UnitFacadeRemote getUnitFacadeRemote() {
        return this.unitFacadeRemote;
    }

    public void setEventMapping(EventMappingRemote eventMapping) {
        this.eventMapping = eventMapping;
    }

    protected AbstractEventHandler(Log log) {
        this.log = log;
    }

    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    protected void callParseEntryPointForSingleUnit(Long unitId, Object event, Map<String, Object> parsedEventParameters, Map<String, Object> metaInfo) {
        String libEntryPoint = this.getParseEntryPoint() + ".lib";
        List scripts = this.getCustomScriptFacadeRemote().getScriptsByEntryPointForAllUnits(libEntryPoint);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)(libEntryPoint + " scripts: " + scripts.size()));
        }
        for (CustomScript script : scripts) {
            try {
                this.getParseEntryPointLoader().loadLib(script);
            }
            catch (Exception ex) {
                if (this.groovyFailuresMontoringMBean != null) {
                    this.groovyFailuresMontoringMBean.increment();
                }
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("libEntryPoint: " + libEntryPoint + " " + script), (Throwable)ex);
                }
                if (this.eventInterfaceMBean == null || this.eventInterfaceMBean.isAcceptFaultyEvents() != this.eventInterfaceMBean.isAcceptFaultyEventsException(this.getIdentification())) continue;
                throw new IllegalStateException("libEntryPoint: " + libEntryPoint + " " + script, ex);
            }
        }
        scripts = unitId == null ? this.getCustomScriptFacadeRemote().getScriptsByEntryPointForAllUnits(this.getParseEntryPoint()) : this.getCustomScriptFacadeRemote().getActiveScriptsByEntryPointAndUnit(this.getParseEntryPoint(), unitId.longValue());
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)(this.getParseEntryPoint() + " unitId: " + unitId + " scripts: " + scripts.size()));
        }
        for (CustomScript script : scripts) {
            try {
                EventParser parser = (EventParser)this.getParseEntryPointLoader().loadScript(script);
                parser.parseEvent(event, parsedEventParameters, metaInfo);
            }
            catch (Exception ex) {
                if (this.groovyFailuresMontoringMBean != null) {
                    this.groovyFailuresMontoringMBean.increment();
                }
                if (this.eventInterfaceMBean != null && this.eventInterfaceMBean.isAcceptFaultyEvents() == this.eventInterfaceMBean.isAcceptFaultyEventsException(this.getIdentification())) {
                    throw new IllegalStateException("entryPoint: " + this.getParseEntryPoint() + " " + script, ex);
                }
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)("entryPoint: " + this.getParseEntryPoint() + " " + script), (Throwable)ex);
            }
        }
    }

    protected void fillMetaInfo(Map<String, Object> metaInfo, List<Long> efmUnitIds, long eventReceiveTime) {
        if (efmUnitIds != null) {
            metaInfo.put(META_EFM_UNITIDS, efmUnitIds);
        }
        metaInfo.put("efm.receiveTime", eventReceiveTime);
    }

    protected abstract String getParseEntryPoint();

    protected abstract ScriptLoader<EventParser> getParseEntryPointLoader();

    protected String getMapperEntryPoint() {
        return DEFAULT_EVENT_MAPPER_ENTRY_POINT;
    }

    public void setEfmEventmonitoringMBean(MonitoringMBean efmEventmonitoringMBean) {
        this.efmEventMonitoringMBean = efmEventmonitoringMBean;
    }

    public void setRawEventmonitoringMBean(MonitoringMBean rawEventmonitoringMBean) {
        this.rawEventMonitoringMBean = rawEventmonitoringMBean;
    }

    protected RawEventResponse handleRawEvent(Object event, long eventReceiveTime, List<Long> unitIds) throws DeviceTemporarilyBlockedException {
        ArrayList<EventResponse> efmEvents;
        HashMap<String, Object> parsedEventParameters = new HashMap<String, Object>();
        HashMap<String, Object> metaInfo = new HashMap<String, Object>();
        if (this.rawEventMonitoringMBean != null) {
            this.rawEventMonitoringMBean.increment();
        }
        this.fillMetaInfo(metaInfo, unitIds, eventReceiveTime);
        this.callParseEntryPoint(unitIds, event, parsedEventParameters, metaInfo);
        if (this.log.isTraceEnabled()) {
            this.dumpParsedInformation(event, parsedEventParameters, metaInfo);
        }
        if ((unitIds = (List)metaInfo.get(META_EFM_UNITIDS)) == null) {
            this.lookupUnitId(event, parsedEventParameters, metaInfo);
            unitIds = (List)metaInfo.get(META_EFM_UNITIDS);
        }
        if (unitIds != null && !unitIds.isEmpty()) {
            if (this.eventInterfaceMBean != null && this.eventInterfaceMBean.isEventInterfaceDisabled(this.getIdentification())) {
                throw new DeviceTemporarilyBlockedException(this.getIdentification());
            }
            efmEvents = this.eventMapping.handleRawEvent(unitIds, parsedEventParameters, metaInfo);
            this.unitIDs = unitIds;
        } else {
            EventResponse eventResponse;
            block13: {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)("no unitId found for " + event));
                }
                eventResponse = null;
                try {
                    Properties easyInstallEvent = this.createEasyInstallEvent(parsedEventParameters, metaInfo);
                    if (easyInstallEvent != null) {
                        eventResponse = this.eventMapping.processEFMevent(easyInstallEvent, metaInfo);
                    }
                }
                catch (Exception ex) {
                    if (!this.log.isErrorEnabled()) break block13;
                    this.log.error((Object)("runs during create zeroconf event into " + event), (Throwable)ex);
                }
            }
            if (eventResponse == null) {
                efmEvents = Collections.EMPTY_LIST;
            } else {
                efmEvents = new ArrayList<EventResponse>();
                efmEvents.add(eventResponse);
            }
        }
        if (this.efmEventMonitoringMBean != null && efmEvents != null) {
            this.efmEventMonitoringMBean.increment(efmEvents.size());
        }
        return new RawEventResponse(efmEvents, metaInfo, parsedEventParameters);
    }

    protected Properties createEasyInstallEvent(Map<String, Object> parsedEventParameters, Map<String, Object> metaInfo) {
        return null;
    }

    protected void callParseEntryPoint(List<Long> unitIds, Object event, Map<String, Object> parsedEventParameters, Map<String, Object> metaInfo) {
        if (unitIds == null || unitIds.isEmpty()) {
            this.callParseEntryPointForSingleUnit(null, event, parsedEventParameters, metaInfo);
        } else {
            for (Long unitId : unitIds) {
                this.callParseEntryPointForSingleUnit(unitId, event, parsedEventParameters, metaInfo);
            }
        }
    }

    protected String toString(Object obj) {
        String str = null;
        if (obj != null) {
            str = obj instanceof byte[] ? ByteUtil.toHexString((byte[])obj) : obj.toString();
        }
        return str;
    }

    protected void dumpParsedInformation(Object event, Map<String, Object> parsedEventParameters, Map<String, Object> metaInfo) {
        StringBuilder str = new StringBuilder();
        str.append("event:");
        str.append(event);
        str.append("\n\n");
        str.append("eventParameters:\n");
        TreeMap<String, Object> params = new TreeMap<String, Object>(parsedEventParameters);
        for (Map.Entry entry : params.entrySet()) {
            str.append(entry.getKey());
            str.append("=");
            str.append(this.toString(entry.getValue()));
            str.append("\n");
        }
        str.append("\n");
        str.append("metaInfo:\n");
        params = new TreeMap<String, Object>(metaInfo);
        for (Map.Entry entry : params.entrySet()) {
            str.append(entry.getKey());
            str.append("=");
            str.append(this.toString(entry.getValue()));
            str.append("\n");
        }
        this.log.trace((Object)str);
    }

    protected void lookupUnitId(Object event, Map<String, Object> parsedEventParameters, Map<String, Object> metaInfo) {
    }
}

