/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.awt.GridLayout;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.netbeans.modules.openfile.OpenFileDialogFilter;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

class FileChooser
extends JFileChooser {
    FileChooser() {
        this.setFileSelectionMode(0);
        this.setMultiSelectionEnabled(true);
        FileFilter currentFilter = this.getFileFilter();
        this.addChoosableFileFilters();
        this.setFileFilter(currentFilter);
    }

    public void addChoosableFileFilters() {
        for (OpenFileDialogFilter f : Lookup.getDefault().lookupAll(OpenFileDialogFilter.class)) {
            this.addChoosableFileFilter(f);
        }
    }

    @Override
    public void approveSelection() {
        File[] selectedFiles = this.getSelectedFiles();
        ArrayList<String> errorMsgs = null;
        for (int i = 0; i < selectedFiles.length; ++i) {
            String msgPatternRef = null;
            File file = selectedFiles[i];
            if (!file.exists()) {
                msgPatternRef = "MSG_FileDoesNotExist";
            } else if (file.isDirectory()) {
                msgPatternRef = "MSG_FileIsADirectory";
            } else if (!file.isFile()) {
                msgPatternRef = "MSG_FileIsNotPlainFile";
            }
            if (msgPatternRef == null) continue;
            if (errorMsgs == null) {
                errorMsgs = new ArrayList<String>(selectedFiles.length - i);
            }
            errorMsgs.add(NbBundle.getMessage(FileChooser.class, (String)msgPatternRef, (Object)file.getName()));
        }
        if (errorMsgs == null) {
            super.approveSelection();
        } else {
            JPanel panel = new JPanel(new GridLayout(errorMsgs.size(), 0, 0, 2));
            for (String errMsg : errorMsgs) {
                panel.add(new JLabel(errMsg));
            }
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)panel, 2));
        }
    }

    public static class JavaFilesFilter
    extends OpenFileDialogFilter {
        @Override
        public String getDescriptionString() {
            return NbBundle.getMessage(this.getClass(), (String)"OFDFD_Java");
        }

        @Override
        public String[] getSuffixes() {
            return new String[]{".java"};
        }
    }

    public static class TxtFileFilter
    extends OpenFileDialogFilter.ExtensionFilter {
        @Override
        public FileNameExtensionFilter getFilter() {
            return new FileNameExtensionFilter(NbBundle.getMessage(this.getClass(), (String)"OFDFD_Txt"), "txt");
        }
    }
}

