/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing.lucene;

import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.parsing.impl.indexing.Pair;
import org.netbeans.modules.parsing.impl.indexing.TransientUpdateSupport;
import org.netbeans.modules.parsing.lucene.support.DocumentIndex;
import org.netbeans.modules.parsing.lucene.support.Index;
import org.netbeans.modules.parsing.lucene.support.IndexDocument;
import org.netbeans.modules.parsing.lucene.support.IndexManager;
import org.netbeans.modules.parsing.lucene.support.Queries;
import org.openide.util.Exceptions;

public final class LayeredDocumentIndex
implements DocumentIndex {
    private final DocumentIndex base;
    private final Set<String> filter = new HashSet<String>();
    private DocumentIndex overlay;

    LayeredDocumentIndex(@NonNull DocumentIndex base) {
        assert (base != null);
        this.base = base;
    }

    public void addDocument(IndexDocument document) {
        if (TransientUpdateSupport.isTransientUpdate()) {
            try {
                this.getOverlay().addDocument(document);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        } else {
            this.base.addDocument(document);
        }
    }

    public void removeDocument(String primaryKey) {
        if (!TransientUpdateSupport.isTransientUpdate()) {
            this.base.removeDocument(primaryKey);
        }
    }

    public Index.Status getStatus() throws IOException {
        if (TransientUpdateSupport.isTransientUpdate()) {
            return Index.Status.VALID;
        }
        return this.base.getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.base.close();
        }
        finally {
            this.clearOverlay();
        }
    }

    public void store(boolean optimize) throws IOException {
        if (TransientUpdateSupport.isTransientUpdate()) {
            Pair<DocumentIndex, Set<String>> ovl = this.getOverlayIfExists();
            if (ovl.first != null) {
                ((DocumentIndex)ovl.first).store(false);
            }
        } else {
            this.base.store(optimize);
        }
    }

    public Collection<? extends IndexDocument> query(String fieldName, String value, Queries.QueryKind kind, String ... fieldsToLoad) throws IOException, InterruptedException {
        Collection<? extends IndexDocument> br = this.base.query(fieldName, value, kind, fieldsToLoad);
        Pair<DocumentIndex, Set<String>> ovl = this.getOverlayIfExists();
        if (ovl.first == null) {
            return ovl.second == null ? br : LayeredDocumentIndex.filter(br, (Set)ovl.second);
        }
        return new ProxyCollection<IndexDocument>(ovl.second == null ? br : LayeredDocumentIndex.filter(br, (Set)ovl.second), ((DocumentIndex)ovl.first).query(fieldName, value, kind, fieldsToLoad));
    }

    public Collection<? extends IndexDocument> findByPrimaryKey(String primaryKeyValue, Queries.QueryKind kind, String ... fieldsToLoad) throws IOException, InterruptedException {
        Collection<? extends IndexDocument> br = this.base.findByPrimaryKey(primaryKeyValue, kind, fieldsToLoad);
        Pair<DocumentIndex, Set<String>> ovl = this.getOverlayIfExists();
        if (ovl.first == null) {
            return ovl.second == null ? br : LayeredDocumentIndex.filter(br, (Set)ovl.second);
        }
        return new ProxyCollection<IndexDocument>(ovl.second == null ? br : LayeredDocumentIndex.filter(br, (Set)ovl.second), ((DocumentIndex)ovl.first).findByPrimaryKey(primaryKeyValue, kind, fieldsToLoad));
    }

    public void markKeyDirty(String primaryKey) {
        this.addToFilter(primaryKey);
        this.base.markKeyDirty(primaryKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDirtyKeys(Collection<? extends String> dirtyKeys) {
        try {
            this.base.removeDirtyKeys(dirtyKeys);
        }
        finally {
            if (!TransientUpdateSupport.isTransientUpdate()) {
                this.clearOverlay();
            }
        }
    }

    public Collection<? extends String> getDirtyKeys() {
        return this.base.getDirtyKeys();
    }

    public boolean begin() {
        if (!TransientUpdateSupport.isTransientUpdate() && this.base instanceof Runnable) {
            ((Runnable)this.base).run();
            return true;
        }
        return false;
    }

    @NonNull
    private synchronized DocumentIndex getOverlay() throws IOException {
        if (this.overlay == null) {
            this.overlay = IndexManager.createDocumentIndex((Index)IndexManager.createMemoryIndex((Analyzer)new KeywordAnalyzer()));
        }
        return this.overlay;
    }

    @NonNull
    private synchronized Pair<DocumentIndex, Set<String>> getOverlayIfExists() throws IOException {
        HashSet<String> f = this.filter.isEmpty() ? null : new HashSet<String>(this.filter);
        return Pair.of(this.overlay, f);
    }

    private synchronized void addToFilter(@NonNull String primaryKey) {
        this.filter.add(primaryKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void clearOverlay() {
        this.filter.clear();
        if (this.overlay != null) {
            try {
                this.overlay.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                this.overlay = null;
            }
        }
    }

    @NonNull
    private static Collection<? extends IndexDocument> filter(@NonNull Collection<? extends IndexDocument> base, @NonNull Set<String> filter) {
        assert (!filter.isEmpty());
        ArrayList<IndexDocument> res = new ArrayList<IndexDocument>(base.size());
        for (IndexDocument indexDocument : base) {
            if (filter.contains(indexDocument.getPrimaryKey())) continue;
            res.add(indexDocument);
        }
        return res;
    }

    private static class ProxyCollection<E>
    extends AbstractCollection<E> {
        private final Collection<? extends E> base;
        private final Collection<? extends E> overlay;

        ProxyCollection(@NonNull Collection<? extends E> base, @NonNull Collection<? extends E> overlay) {
            this.base = base;
            this.overlay = overlay;
        }

        @Override
        public Iterator<E> iterator() {
            return new ProxyIterator<E>(this.base.iterator(), this.overlay.iterator());
        }

        @Override
        public int size() {
            return this.base.size() + this.overlay.size();
        }
    }

    private static class ProxyIterator<E>
    implements Iterator<E> {
        private final Iterator<? extends E> base;
        private final Iterator<? extends E> overlay;

        ProxyIterator(@NonNull Iterator<? extends E> base, @NonNull Iterator<? extends E> overlay) {
            this.base = base;
            this.overlay = overlay;
        }

        @Override
        public boolean hasNext() {
            return this.base.hasNext() || this.overlay.hasNext();
        }

        @Override
        public E next() {
            return this.base.hasNext() ? this.base.next() : this.overlay.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unmodifiable collection");
        }
    }
}

