/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.parsing.impl.indexing.CacheFolder;
import org.netbeans.modules.parsing.impl.indexing.LongHashMap;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public final class TimeStamps {
    private static final Logger LOG = Logger.getLogger(TimeStamps.class.getName());
    private static final String TIME_STAMPS_FILE = "timestamps.properties";
    private static final String VERSION = "#v2";
    private final Implementation impl;

    private TimeStamps(@NonNull Implementation impl) throws IOException {
        assert (impl != null);
        this.impl = impl;
    }

    public boolean checkAndStoreTimestamp(FileObject f, String relativePath) {
        return this.impl.checkAndStoreTimestamp(f, relativePath);
    }

    public Set<String> getUnseenFiles() {
        return this.impl.getUnseenFiles();
    }

    public void store() throws IOException {
        this.impl.store();
    }

    void resetToNow() {
        long now = System.currentTimeMillis();
        this.impl.reset(now);
    }

    public static TimeStamps forRoot(@NonNull URL root, boolean detectDeletedFiles) throws IOException {
        return new TimeStamps(new RegularImpl(root, detectDeletedFiles));
    }

    public static TimeStamps changedTransient() throws IOException {
        return new TimeStamps(new AllChangedTransientImpl());
    }

    public static boolean existForRoot(URL root) throws IOException {
        assert (root != null);
        FileObject cacheDir = CacheFolder.getDataFolder(root, true);
        if (cacheDir != null) {
            return new File(FileUtil.toFile((FileObject)cacheDir), TIME_STAMPS_FILE).exists();
        }
        return false;
    }

    private static class AllChangedTransientImpl
    implements Implementation {
        private AllChangedTransientImpl() {
        }

        @Override
        public boolean checkAndStoreTimestamp(FileObject root, String relativePath) {
            return false;
        }

        @Override
        public Set<String> getUnseenFiles() {
            return Collections.emptySet();
        }

        @Override
        public void reset(long time) {
        }

        @Override
        public void store() throws IOException {
        }
    }

    private static interface Implementation {
        public boolean checkAndStoreTimestamp(FileObject var1, String var2);

        public Set<String> getUnseenFiles();

        public void reset(long var1);

        public void store() throws IOException;
    }

    private static final class RegularImpl
    implements Implementation {
        private final URL root;
        private final LongHashMap<String> timestamps = new LongHashMap();
        private final Set<String> unseen;
        private FileObject rootFoCache;

        private RegularImpl(@NonNull URL root, boolean detectDeletedFiles) throws IOException {
            assert (root != null);
            this.root = root;
            this.unseen = detectDeletedFiles ? new HashSet() : null;
            this.load();
        }

        @Override
        public boolean checkAndStoreTimestamp(FileObject f, String relativePath) {
            boolean isUpToDate;
            long fts;
            String fileId;
            long lts;
            if (this.rootFoCache == null) {
                this.rootFoCache = URLMapper.findFileObject((URL)this.root);
            }
            if ((lts = this.timestamps.put(fileId = relativePath != null ? relativePath : URLMapper.findURL((FileObject)f, (int)1).toExternalForm(), fts = f.lastModified().getTime())) == Long.MIN_VALUE) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "{0}: lastTimeStamp=null, fileTimeStamp={1} is out of date", new Object[]{f.getPath(), fts});
                }
                return false;
            }
            if (this.unseen != null) {
                this.unseen.remove(fileId);
            }
            boolean bl = isUpToDate = lts == fts;
            if (!isUpToDate && LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "{0}: lastTimeStamp={1}, fileTimeStamp={2} is out of date", new Object[]{f.getPath(), lts, fts});
            }
            return isUpToDate;
        }

        @Override
        public Set<String> getUnseenFiles() {
            return this.unseen;
        }

        @Override
        public void reset(long value) {
            for (LongHashMap.Entry<String> entry : this.timestamps.entrySet()) {
                entry.setValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void store() throws IOException {
            File cacheDir = FileUtil.toFile((FileObject)CacheFolder.getDataFolder(this.root));
            File f = new File(cacheDir, TimeStamps.TIME_STAMPS_FILE);
            assert (f != null);
            try {
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8"));
                try {
                    if (this.unseen != null) {
                        this.timestamps.keySet().removeAll(this.unseen);
                    }
                    out.write(TimeStamps.VERSION);
                    out.newLine();
                    for (LongHashMap.Entry<String> entry : this.timestamps.entrySet()) {
                        out.write(entry.getKey());
                        out.write(61);
                        out.write(Long.toString(entry.getValue()));
                        out.newLine();
                    }
                    out.flush();
                }
                finally {
                    out.close();
                }
            }
            catch (IOException e) {
                LOG.log(Level.FINE, null, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void load() throws IOException {
            File cacheDir = FileUtil.toFile((FileObject)CacheFolder.getDataFolder(this.root));
            File f = new File(cacheDir, TimeStamps.TIME_STAMPS_FILE);
            if (f.exists()) {
                try {
                    boolean readOldPropertiesFormat = false;
                    BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
                    try {
                        String string = in.readLine();
                        if (string != null && string.startsWith(TimeStamps.VERSION)) {
                            String string2;
                            LOG.log(Level.FINE, "{0}: reading {1} timestamps", new Object[]{f.getPath(), TimeStamps.VERSION});
                            while (null != (string2 = in.readLine())) {
                                int idx = string2.indexOf(61);
                                if (idx == -1) continue;
                                try {
                                    long ts = Long.parseLong(string2.substring(idx + 1));
                                    this.timestamps.put(string2.substring(0, idx), ts);
                                }
                                catch (NumberFormatException nfe) {
                                    LOG.log(Level.FINE, "Invalid timestamp: line={0}, timestamps={1}, exception={2}", new Object[]{string2, f.getPath(), nfe});
                                }
                            }
                        } else {
                            readOldPropertiesFormat = true;
                        }
                    }
                    finally {
                        in.close();
                    }
                    if (readOldPropertiesFormat) {
                        LOG.log(Level.FINE, "{0}: reading old Properties timestamps", f.getPath());
                        Properties p = new Properties();
                        FileInputStream fileInputStream = new FileInputStream(f);
                        try {
                            p.load(fileInputStream);
                        }
                        finally {
                            ((InputStream)fileInputStream).close();
                        }
                        for (Map.Entry<Object, Object> entry : p.entrySet()) {
                            try {
                                this.timestamps.put((String)entry.getKey(), Long.parseLong((String)entry.getValue()));
                            }
                            catch (NumberFormatException nfe) {
                                LOG.log(Level.FINE, "Invalid timestamp: key={0}, value={1}, timestamps={2}, exception={3}", new Object[]{entry.getKey(), entry.getValue(), f, nfe});
                            }
                        }
                    }
                    if (this.unseen != null) {
                        for (String string : this.timestamps.keySet()) {
                            this.unseen.add(string);
                        }
                    }
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.log(Level.FINEST, "Timestamps loaded from {0}:", f.getPath());
                        for (LongHashMap.Entry entry : this.timestamps.entrySet()) {
                            LOG.log(Level.FINEST, "{0}={1}", new Object[]{entry.getKey(), Long.toString(entry.getValue())});
                        }
                        LOG.log(Level.FINEST, "---------------------------");
                    }
                }
                catch (Exception e) {
                    this.timestamps.clear();
                    LOG.log(Level.FINE, null, e);
                }
            }
        }
    }
}

