/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.efm4_6.impl;

import de.proveo.domain.values.datasync.DatasyncConverter;
import de.proveo.domain.values.datasync.DatasyncMetainfoValue;
import de.proveo.domain.values.datasync.DatasyncResourceValue;
import de.proveo.domain.values.datasync.DatasyncStatusValue;
import de.proveo.domain.values.datasync.DatasyncTaskValue;
import de.proveo.domain.values.datasync.xml.DatasyncXMLConverter;
import de.proveo.domain.values.datasync.xml.DatasyncXMLResourceValue;
import de.proveo.domain.values.datasync.xml.DatasyncXMLStatusValue;
import de.proveo.domain.values.datasync.xml.DatasyncXMLTaskValue;
import de.proveo.domain.values.datasync.xml.DatasyncXMLTasksResourceValue;
import de.proveo.domain.values.infoman.InfomanSetupValue;
import de.proveo.domain.values.infoman.InfomanSoftwareValue;
import de.proveo.domain.values.infoman.LegacyScheduledUpdateValue;
import de.proveo.domain.values.infoman.MetaInfoKey;
import de.proveo.idm.core.gui.navigation.NavigationTopComponent;
import de.proveo.idm.core.gui.navigation.api.Credentials;
import de.proveo.idm.core.gui.navigation.api.Device;
import de.proveo.idm.core.gui.navigation.api.NavigationItem;
import de.proveo.idm.core.gui.navigation.api.RemoteNavigationItem;
import de.proveo.idm.core.gui.util.DialogUtil;
import de.proveo.idm.core.util.VersionsCompareUtil;
import de.proveo.idm.remote.server.api.EFMServer;
import de.proveo.idm.remote.server.api.IDMLoginResponse;
import de.proveo.idm.remote.server.api.RemoteDeviceId;
import de.proveo.idm.remote.server.api.RemoteUpdateAdapter;
import de.proveo.idm.remote.server.api.ResourceServerFeatureExtension;
import de.proveo.idm.remote.server.api.impl.LoginDataProviderImpl;
import de.proveo.idm.remote.server.api.impl.RemoteDeviceIdImpl;
import de.proveo.idm.remote.server.efm4_6.impl.EFMServer4_6;
import de.proveo.idm.remote.server.efm4_6.impl.InfomanSoftwareValueAdapter;
import de.proveo.idm.remote.server.navigation.EFMServerNavigationItem;
import de.proveo.idm.remote.server.services.ShaSumGenerator;
import de.proveo.idm.remote.server.util.TreeUtil;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class RemoteUpdateAdapterImpl
implements RemoteUpdateAdapter {
    private static final Logger log = Logger.getLogger(RemoteUpdateAdapterImpl.class.getName());
    private final Map<RemoteDeviceId, Collection<DatasyncTaskValue>> taskMap = new HashMap<RemoteDeviceId, Collection<DatasyncTaskValue>>();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private EFMServer4_6 server;
    private Credentials credentials;

    public RemoteUpdateAdapterImpl(EFMServer4_6 server, Credentials credentials) {
        this.server = server;
        this.credentials = credentials;
    }

    public synchronized Collection<DatasyncResourceValue> getAvailableSoftware() throws Exception {
        Collection serverSoftware = this.server.getUnitWebServiceClient().getAvailableSoftware();
        ArrayList<DatasyncResourceValue> softwareList = new ArrayList<DatasyncResourceValue>();
        for (InfomanSoftwareValue value : serverSoftware) {
            softwareList.add(new InfomanSoftwareValueAdapter(value));
        }
        return softwareList;
    }

    public synchronized Collection<DatasyncResourceValue> getAvailableSoftware(Device.DeviceType deviceType) throws Exception {
        if (deviceType == null) {
            return this.getAvailableSoftware();
        }
        return this.getAvailableResources(deviceType, "Software");
    }

    public Collection<DatasyncResourceValue> getAvailableResources(String filter) throws Exception {
        if (filter == null) {
            filter = "";
        }
        return this.convertXMLResourceListToResourceList(this.server.getDatasyncWebServiceClient().getAllResourceInfos(filter));
    }

    public Collection<DatasyncResourceValue> getAvailableResources(Device.DeviceType deviceType, String resourceType) throws Exception {
        if (deviceType == null) {
            return this.getAvailableSoftware();
        }
        if (resourceType == null) {
            resourceType = "";
        }
        return this.convertXMLResourceListToResourceList(this.server.getDatasyncWebServiceClient().getAllResourceInfos(deviceType.toString() + StringUtils.remove((String)resourceType, (String)" ")));
    }

    public Collection<DatasyncResourceValue> getAvailableDatasyncResources() throws Exception {
        return this.convertXMLResourceListToResourceList(this.server.getDatasyncWebServiceClient().getAllResourceInfos());
    }

    private Collection<DatasyncResourceValue> convertXMLResourceListToResourceList(List<DatasyncXMLResourceValue> xmlResourceList) {
        ArrayList<DatasyncResourceValue> resourceList = new ArrayList<DatasyncResourceValue>();
        if (xmlResourceList != null) {
            for (DatasyncXMLResourceValue xmlRes : xmlResourceList) {
                DatasyncResourceValue res = DatasyncConverter.convertXMLDatasyncResourceValue((DatasyncXMLResourceValue)xmlRes);
                String resName = res.getResourceName();
                if (resName == null || resName.trim().length() == 0) continue;
                resourceList.add(res);
            }
        }
        return resourceList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DatasyncTaskValue createTask(Device.DeviceType deviceType, DatasyncTaskValue task) throws Exception {
        long clientId = task.getClientId();
        if (clientId != 0L) {
            if (deviceType != null && deviceType.equals((Object)Device.DeviceType.INFOMAN_EFM)) {
                return this.createDatasyncTask(task);
            }
            if (deviceType != null) {
                if (!deviceType.equals((Object)Device.DeviceType.INFOMAN)) throw new UnsupportedOperationException("Device type '" + deviceType + "' not supported yet.");
            }
            String version = null;
            InfomanSetupValue setup = this.server.getUnitWebServiceClient().getConfiguration(clientId);
            if (setup != null) {
                version = setup.getSoftwareVersion();
            }
            boolean versionGreaterOrEqualToDatasyncVersion = false;
            if (version != null) {
                versionGreaterOrEqualToDatasyncVersion = VersionsCompareUtil.isVersionGreaterOrEqual((String)version, (String)"1.12.0");
            }
            if (!versionGreaterOrEqualToDatasyncVersion) return this.createEFMSTask(task);
            return this.createDatasyncTask(task);
        }
        this.createDatasyncTask(task);
        return task;
    }

    public List<DatasyncTaskValue> createTasks(Device.DeviceType deviceType, List<DatasyncTaskValue> tasks, DatasyncResourceValue resource) throws Exception {
        DatasyncXMLResourceValue xmlResource = null;
        if (resource != null) {
            xmlResource = DatasyncXMLConverter.convertDatasyncResourceValue((DatasyncResourceValue)resource);
        }
        ArrayList<DatasyncXMLTaskValue> xmlTasks = new ArrayList<DatasyncXMLTaskValue>();
        for (DatasyncTaskValue task : tasks) {
            xmlTasks.add(DatasyncXMLConverter.convertDatasyncTaskValue((DatasyncTaskValue)task));
        }
        DatasyncXMLTasksResourceValue xmlTasksAndResource = new DatasyncXMLTasksResourceValue(xmlTasks, xmlResource);
        List createdTasks = this.server.getDatasyncWebServiceClient().createBatchDatasyncTask(xmlTasksAndResource);
        if (createdTasks != null && !createdTasks.isEmpty()) {
            tasks = new ArrayList<DatasyncTaskValue>();
            for (DatasyncXMLTaskValue xmlTask : createdTasks) {
                DatasyncTaskValue task = DatasyncConverter.convertXMLDatasyncTaskValue((DatasyncXMLTaskValue)xmlTask);
                this.addTasksToUnit(task);
                this.pcs.firePropertyChange("RemoteUpdateAdapter.task.create", null, task);
                tasks.add(task);
            }
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        RemoteUpdateAdapterImpl.this.updateTaskNavigationOverview();
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                run.run();
            } else {
                SwingUtilities.invokeLater(run);
            }
            return tasks;
        }
        return null;
    }

    public DatasyncStatusValue cancelTask(DatasyncTaskValue task, String remark) throws Exception {
        DatasyncXMLStatusValue xmlStatus = this.server.getDatasyncWebServiceClient().cancelTask(task.getTaskId(), remark);
        this.pcs.firePropertyChange("RemoteUpdateAdapter.task.cancel", null, task);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    RemoteUpdateAdapterImpl.this.getTasks();
                    RemoteUpdateAdapterImpl.this.updateTaskNavigationOverview();
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
        return DatasyncConverter.convertXMLDatasyncStatusValue((DatasyncXMLStatusValue)xmlStatus);
    }

    public void editTask(DatasyncTaskValue task) throws Exception {
        DatasyncXMLTaskValue xmlTask = DatasyncXMLConverter.convertDatasyncTaskValue((DatasyncTaskValue)task);
        this.server.getDatasyncWebServiceClient().updateTask(xmlTask);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    RemoteUpdateAdapterImpl.this.getTasks();
                    RemoteUpdateAdapterImpl.this.updateTaskNavigationOverview();
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
        this.pcs.firePropertyChange("RemoteUpdateAdapter.task.edit", null, task);
    }

    public Map<RemoteDeviceId, Collection<DatasyncTaskValue>> getTasks() throws Exception {
        List xmlTasks;
        if (!this.taskMap.isEmpty()) {
            Iterator<Collection<DatasyncTaskValue>> ite = new HashSet<Collection<DatasyncTaskValue>>(this.taskMap.values()).iterator();
            this.taskMap.clear();
            while (ite.hasNext()) {
                Collection<DatasyncTaskValue> tasks = ite.next();
                for (DatasyncTaskValue task : tasks) {
                    this.pcs.firePropertyChange("RemoteUpdateAdapter.task.cancel", null, task);
                }
            }
        }
        if ((xmlTasks = this.server.getDatasyncWebServiceClient().getAllOpenTasks()).isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        for (DatasyncXMLTaskValue xmlTask : xmlTasks) {
            DatasyncTaskValue task;
            task = DatasyncConverter.convertXMLDatasyncTaskValue((DatasyncXMLTaskValue)xmlTask);
            this.addTasksToUnit(task);
            this.pcs.firePropertyChange("RemoteUpdateAdapter.task.create", null, task);
        }
        return this.taskMap;
    }

    public Collection<DatasyncTaskValue> getTasks(RemoteDeviceId remoteInfomanId) throws Exception {
        Collection<Object> tasks = null;
        if (this.taskMap != null) {
            tasks = this.taskMap.get(remoteInfomanId);
        }
        return tasks != null ? tasks : Collections.EMPTY_LIST;
    }

    public DatasyncStatusValue getTaskStatus(long taskId) {
        DatasyncXMLStatusValue xmlStatus = this.server.getDatasyncWebServiceClient().getTaskStatus(taskId);
        return DatasyncConverter.convertXMLDatasyncStatusValue((DatasyncXMLStatusValue)xmlStatus);
    }

    public DatasyncTaskValue getTask(long taskId) throws Exception {
        return DatasyncConverter.convertXMLDatasyncTaskValue((DatasyncXMLTaskValue)this.server.getDatasyncWebServiceClient().getTask(taskId));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public synchronized boolean hasTasks() {
        return this.taskMap != null && !this.taskMap.isEmpty();
    }

    private void addTasksToUnit(DatasyncTaskValue task) {
        String serial;
        long unitId = task.getClientId();
        RemoteDeviceIdImpl infomanId = new RemoteDeviceIdImpl(unitId, serial = task.getClientSerialNumber());
        Collection<DatasyncTaskValue> tasksForUnit = this.taskMap.get(infomanId);
        if (tasksForUnit == null) {
            ArrayList<DatasyncTaskValue> taskValues = new ArrayList<DatasyncTaskValue>();
            taskValues.add(task);
            this.taskMap.put((RemoteDeviceId)infomanId, taskValues);
        } else {
            tasksForUnit.add(task);
        }
    }

    private DatasyncTaskValue createEFMSTask(DatasyncTaskValue task) throws Exception {
        LoginDataProviderImpl provider = new LoginDataProviderImpl();
        IDMLoginResponse response = this.server.login(this.credentials);
        while (response == null || !response.isAccessPermitted()) {
            DialogUtil.showErrorDialog((Object)NbBundle.getMessage(EFMServer.class, (String)"EFMServer.login.failed.msg"), (String)NbBundle.getMessage(EFMServer.class, (String)"EFMServer.login.failed.title"));
            this.credentials = provider.getLoginData(this.server.getName(), this.server.getURL());
            if (this.credentials == null) {
                return null;
            }
            response = this.server.login(this.credentials);
        }
        LegacyScheduledUpdateValue update = new LegacyScheduledUpdateValue();
        String password = ShaSumGenerator.plainStringToSHA1((String)new String(this.credentials.getPassword()));
        update.setUnitId(task.getClientId());
        List resources = task.getResources();
        if (resources != null && !resources.isEmpty()) {
            update.setUsername(this.credentials.getUsername());
            update.setPassword(password);
            update.setScheduledTime(task.getValidFrom());
            boolean softwareAdded = false;
            boolean configurationAdded = false;
            for (DatasyncResourceValue resource : resources) {
                if (resource instanceof InfomanSoftwareValueAdapter) {
                    if (softwareAdded) {
                        log.warning("Software was already added to update, overwrite with another software resource!");
                    }
                    InfomanSoftwareValue value = ((InfomanSoftwareValueAdapter)resource).getInfomanSoftwareValue();
                    this.addSoftwareToEFMUpdate(update, value);
                    softwareAdded = true;
                    continue;
                }
                if (configurationAdded) {
                    log.warning("Configuration was already added to update, overwrite with another configuration resource!");
                }
                this.addConfigurationToEFMUpdate(update, resource);
                configurationAdded = true;
            }
            this.server.getUnitWebServiceClient().createLegacyInfomanUpdate(update);
            return task;
        }
        return null;
    }

    private void addSoftwareToEFMUpdate(LegacyScheduledUpdateValue update, InfomanSoftwareValue value) throws Exception {
        update.setSoftwareId(value.getSoftwareId());
    }

    private void addConfigurationToEFMUpdate(LegacyScheduledUpdateValue update, DatasyncResourceValue resource) throws Exception {
        byte[] configuration = resource.getResource();
        update.setConfigurationName(resource.getResourceName());
        update.setConfiguration(configuration);
        update.setConfigurationChecksum(resource.getChecksum());
        if (configuration != null) {
            List metaInfos = resource.getMetainfos();
            if (metaInfos != null) {
                update.setConfigurationContentType(RemoteUpdateAdapterImpl.extractMetaInfo(MetaInfoKey.CONTENT_TYPE.toString(), metaInfos));
                update.setConfigurationChecksumType(RemoteUpdateAdapterImpl.extractMetaInfo(MetaInfoKey.CHECKSUM_TYPE.toString(), metaInfos));
            } else {
                log.warning("Update contains configuration, but meta info is missing!");
            }
        }
    }

    private DatasyncTaskValue createDatasyncTask(DatasyncTaskValue task) throws Exception {
        DatasyncXMLStatusValue result;
        List resources = task.getResources();
        if (resources != null) {
            for (DatasyncResourceValue res : resources) {
                if (!(res instanceof InfomanSoftwareValueAdapter)) continue;
                InfomanSoftwareValueAdapter adapter = (InfomanSoftwareValueAdapter)res;
                InfomanSoftwareValue software = adapter.getInfomanSoftwareValue();
                long id = software.getSoftwareId();
                byte[] payload = this.server.getUnitWebServiceClient().getSoftwareArchive(id);
                res.setResource(payload);
            }
            task.setResources(resources);
        }
        if ((result = this.server.getDatasyncWebServiceClient().createDatasyncTask(DatasyncXMLConverter.convertDatasyncTaskValue((DatasyncTaskValue)task))) != null) {
            task = this.updateTaskWithStatusValue(task, result);
            this.addTasksToUnit(task);
            this.pcs.firePropertyChange("RemoteUpdateAdapter.task.create", null, task);
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        RemoteUpdateAdapterImpl.this.updateTaskNavigationOverview();
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                run.run();
            } else {
                SwingUtilities.invokeLater(run);
            }
            return task;
        }
        return null;
    }

    private void updateTaskNavigationOverview() {
        NavigationTopComponent nav = NavigationTopComponent.findInstance();
        Collection navItems = nav.findNavigationItemsByType(EFMServerNavigationItem.class);
        if (navItems == null) {
            return;
        }
        EFMServerNavigationItem serverItem = null;
        for (EFMServerNavigationItem item : navItems) {
            EFMServerNavigationItem sItem = item;
            EFMServer itemServer = sItem.getServerInstance();
            if (itemServer == null || !itemServer.equals((Object)this.server)) continue;
            serverItem = sItem;
            break;
        }
        if (serverItem == null) {
            return;
        }
        Iterator children = serverItem.getChildren().iterator();
        NavigationItem root = null;
        while (root == null && children.hasNext()) {
            RemoteNavigationItem.Type type;
            NavigationItem child = (NavigationItem)children.next();
            if (!(child instanceof RemoteNavigationItem) || (type = ((RemoteNavigationItem)child).getType()) == null || !type.equals((Object)RemoteNavigationItem.Type.TASKS)) continue;
            root = child;
        }
        NavigationItem navigation = TreeUtil.createTaskNavigation(this.taskMap);
        Node node = nav.findNodeByNavigationItem(serverItem);
        nav.findExpandedNodes(node);
        if (navigation != null && !navigation.getChildren().isEmpty()) {
            if (root != null) {
                root.merge(navigation);
            } else {
                serverItem.addChild(navigation);
            }
        } else if (root != null) {
            serverItem.removeChild(root);
        }
        nav.expandOriginalNodes(node);
    }

    private void updateResourceOverview() {
        NavigationTopComponent nav = NavigationTopComponent.findInstance();
        Collection navItems = nav.findNavigationItemsByType(EFMServerNavigationItem.class);
        if (navItems == null) {
            return;
        }
        EFMServerNavigationItem serverItem = null;
        for (EFMServerNavigationItem item : navItems) {
            EFMServerNavigationItem sItem = item;
            EFMServer itemServer = sItem.getServerInstance();
            if (itemServer == null || !itemServer.equals((Object)this.server)) continue;
            serverItem = sItem;
            break;
        }
        if (serverItem == null) {
            return;
        }
        Iterator children = serverItem.getChildren().iterator();
        NavigationItem root = null;
        while (root == null && children.hasNext()) {
            RemoteNavigationItem.Type type;
            NavigationItem child = (NavigationItem)children.next();
            if (!(child instanceof RemoteNavigationItem) || (type = ((RemoteNavigationItem)child).getType()) == null || !type.equals((Object)RemoteNavigationItem.Type.RESOURCES)) continue;
            root = child;
        }
        HashMap<String, HashMap<String, Collection<DatasyncResourceValue>>> resourcesTree = new HashMap<String, HashMap<String, Collection<DatasyncResourceValue>>>();
        for (Device.DeviceType deviceType : Device.DeviceType.values()) {
            for (String resType : RemoteUpdateAdapter.RESOURCE_TYPES) {
                resType = StringUtils.remove((String)resType, (String)" ");
                Collection<DatasyncResourceValue> resources = null;
                try {
                    resources = this.getAvailableResources(deviceType, resType);
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "Get " + resType + " resources for " + deviceType.toString() + " runs into", ex);
                }
                if (resources == null || resources.isEmpty()) continue;
                HashMap<String, Collection<DatasyncResourceValue>> resourcesForDeviceType = (HashMap<String, Collection<DatasyncResourceValue>>)resourcesTree.get(deviceType.toString());
                if (resourcesForDeviceType == null) {
                    resourcesForDeviceType = new HashMap<String, Collection<DatasyncResourceValue>>();
                }
                resourcesForDeviceType.put(resType, resources);
                resourcesTree.put(deviceType.toString(), resourcesForDeviceType);
            }
        }
        Collection extensions = Lookup.getDefault().lookupAll(ResourceServerFeatureExtension.class);
        if (extensions != null) {
            for (ResourceServerFeatureExtension extension : extensions) {
                try {
                    Map extResourcesTree = extension.createServerNavigationTreeMap((EFMServer)this.server);
                    if (extResourcesTree == null || extResourcesTree.isEmpty()) continue;
                    resourcesTree.putAll(extResourcesTree);
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "Get resources for extension " + extension.getClass().getName() + " runs into", ex);
                }
            }
        }
        NavigationItem navigation = TreeUtil.createResourceNavigation(resourcesTree);
        Node node = nav.findNodeByNavigationItem((NavigationItem)serverItem);
        nav.findExpandedNodes(node);
        if (navigation != null && !navigation.getChildren().isEmpty()) {
            if (root != null) {
                root.merge(navigation);
            } else {
                serverItem.addChild(navigation);
            }
        } else if (root != null) {
            serverItem.removeChild(root);
        }
        nav.expandOriginalNodes(node);
    }

    private DatasyncTaskValue updateTaskWithStatusValue(DatasyncTaskValue task, DatasyncXMLStatusValue status) {
        task.setClientId(status.getClientId());
        task.setIdentifier(status.getIdentifier());
        task.setLastAnnounceTime(status.getLastRetryTime());
        task.setMaxRetry(status.getRetryCount());
        task.setTaskId(status.getTaskId());
        task.setTaskInfo(status.getTaskInfo());
        task.setValidFrom(status.getValidFrom());
        task.setValidTill(status.getValidTill());
        String serialNumber = status.getSerialNumber();
        if (serialNumber != null && serialNumber.trim().length() != 0) {
            task.setClientSerialNumber(serialNumber);
        }
        try {
            ArrayList<DatasyncResourceValue> resources = new ArrayList<DatasyncResourceValue>();
            List resIds = status.getResourceIds();
            for (int i = 0; i < resIds.size(); ++i) {
                DatasyncXMLResourceValue xmlResValue = this.server.getDatasyncWebServiceClient().getResourceById(((Long)resIds.get(i)).longValue());
                DatasyncResourceValue resValue = DatasyncConverter.convertXMLDatasyncResourceValue((DatasyncXMLResourceValue)xmlResValue);
                resources.add(resValue);
            }
            task.setResources(resources);
        }
        catch (Exception ex) {
            List resIds = status.getResourceIds();
            for (int i = 0; i < resIds.size(); ++i) {
                ((DatasyncResourceValue)task.getResources().get(i)).setResourceId(((Long)resIds.get(i)).longValue());
            }
        }
        return task;
    }

    private static String extractMetaInfo(String key, List<DatasyncMetainfoValue> values) throws Exception {
        for (DatasyncMetainfoValue value : values) {
            if (!key.equals(value.getKey())) continue;
            return value.getValue();
        }
        return null;
    }

    public byte[] getResourceContent(long resourceId) throws Exception {
        return this.server.getDatasyncWebServiceClient().getResourceContent(resourceId);
    }

    public DatasyncResourceValue uploadResource(String identifier, DatasyncResourceValue value) throws Exception {
        DatasyncResourceValue ret = DatasyncConverter.convertXMLDatasyncResourceValue((DatasyncXMLResourceValue)this.server.getDatasyncWebServiceClient().createResource(identifier, DatasyncXMLConverter.convertDatasyncResourceValue((DatasyncResourceValue)value)));
        if (ret != null) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        RemoteUpdateAdapterImpl.this.updateResourceOverview();
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                run.run();
            } else {
                SwingUtilities.invokeLater(run);
            }
        }
        return ret;
    }

    public DatasyncResourceValue updateResource(DatasyncResourceValue value) throws Exception {
        DatasyncResourceValue ret = DatasyncConverter.convertXMLDatasyncResourceValue((DatasyncXMLResourceValue)this.server.getDatasyncWebServiceClient().updateResource(DatasyncXMLConverter.convertDatasyncResourceValue((DatasyncResourceValue)value)));
        if (ret != null) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        RemoteUpdateAdapterImpl.this.updateResourceOverview();
                        RemoteUpdateAdapterImpl.this.getTasks();
                        RemoteUpdateAdapterImpl.this.updateTaskNavigationOverview();
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                run.run();
            } else {
                SwingUtilities.invokeLater(run);
            }
        }
        return ret;
    }
}

