/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.efm4_6.impl;

import de.proveo.idm.remote.server.api.RemoteOperatorAdapter;
import de.proveo.idm.remote.server.efm4_6.impl.EFMServer4_6;
import de.proveo.util.useuser.LicenseBean;
import de.proveo.util.useuser.LicenseTypeBean;
import de.proveo.util.useuser.UseUserTreeNodeBean;
import java.util.List;
import java.util.logging.Logger;

public class RemoteOperatorAdapterImpl
implements RemoteOperatorAdapter {
    private static final Logger log = Logger.getLogger(RemoteOperatorAdapterImpl.class.getName());
    private EFMServer4_6 server;

    public RemoteOperatorAdapterImpl(EFMServer4_6 server) {
        this.server = server;
    }

    public UseUserTreeNodeBean getOperators() throws Exception {
        return this.server.getUseUserWebService().getAllUseUsers();
    }

    public UseUserTreeNodeBean getOperatorById(long operatorId) throws Exception {
        return this.server.getUseUserWebService().getUseUserById(operatorId);
    }

    public void deleteLicense(int licenseId) throws Exception {
        this.server.getUseUserWebService().deleteLicense(licenseId);
    }

    public void createLicenseForOperator(long useUserId, LicenseBean licenseBean) throws Exception {
        this.server.getUseUserWebService().createLicenseForUseUser(useUserId, licenseBean);
    }

    public void drawLicense(LicenseBean license) throws Exception {
        license.setRevoked(true);
        this.server.getUseUserWebService().updateLicense(license);
    }

    public List<LicenseTypeBean> getLicenseTypes() throws Exception {
        return this.server.getUseUserWebService().getLicenseTypes();
    }

    public void createOperator(UseUserTreeNodeBean useUser, long useUserGroupId) throws Exception {
        this.server.getUseUserWebService().createUseUser(useUser, useUserGroupId);
    }

    public void deleteOperator(long operatorId) throws Exception {
        this.server.getUseUserWebService().deleteUseUser(operatorId);
    }

    public void createOperatorGroup(UseUserTreeNodeBean useUserGroup) throws Exception {
        this.server.getUseUserWebService().createUseUserGroup(useUserGroup);
    }

    public void deleteOperatorGroup(long useUserGroupId) throws Exception {
        this.server.getUseUserWebService().deleteUseGroup(useUserGroupId);
    }

    public void editOperator(UseUserTreeNodeBean useUser) throws Exception {
        this.server.getUseUserWebService().updateUseUser(useUser);
    }

    public void editOperatorGroup(UseUserTreeNodeBean useUserGroup) throws Exception {
        this.server.getUseUserWebService().updateUseGroup(useUserGroup);
    }

    public void insertOperatorIntoGroup(long useUserId, long groupId) throws Exception {
        this.server.getUseUserWebService().setUseUserIntoGroup(useUserId, groupId);
    }

    public void removeOperatorFromGroup(long useUserId, long groupId) throws Exception {
        this.server.getUseUserWebService().deleteUseUserFromGroup(useUserId, groupId);
    }
}

