/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.efm4_6.impl;

import de.proveo.domain.values.datasync.DatasyncMetainfoValue;
import de.proveo.domain.values.datasync.DatasyncResourceValue;
import de.proveo.domain.values.infoman.InfomanSoftwareValue;
import de.proveo.domain.values.infoman.MetaInfoKey;
import java.util.ArrayList;
import java.util.List;

public class InfomanSoftwareValueAdapter
extends DatasyncResourceValue {
    private final InfomanSoftwareValue value;
    private List<DatasyncMetainfoValue> metaInfo;

    public InfomanSoftwareValueAdapter(InfomanSoftwareValue value) {
        this.value = value;
        this.metaInfo = InfomanSoftwareValueAdapter.createMetaInfo(value);
    }

    public String getChecksum() {
        return this.value.getChecksum();
    }

    public List<DatasyncMetainfoValue> getMetainfos() {
        return this.metaInfo;
    }

    public byte[] getResource() {
        return this.value.getSoftware();
    }

    public String getResourceName() {
        return this.value.getVersionName();
    }

    public boolean isHasMetaInfo() {
        return this.metaInfo != null && !this.metaInfo.isEmpty();
    }

    public void setChecksum(String checksum) {
        this.value.setChecksum(checksum);
    }

    public void setMetainfos(List<DatasyncMetainfoValue> metainfos) {
        this.metaInfo = metainfos;
    }

    public void setResource(byte[] resource) {
        this.value.setSoftware(resource);
    }

    public void setResourceName(String resourceName) {
        this.value.setSoftwareFileName(resourceName);
    }

    public InfomanSoftwareValue getInfomanSoftwareValue() {
        return this.value;
    }

    private static ArrayList<DatasyncMetainfoValue> createMetaInfo(InfomanSoftwareValue software) {
        ArrayList<DatasyncMetainfoValue> infos = new ArrayList<DatasyncMetainfoValue>();
        DatasyncMetainfoValue info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.CHECKSUM_TYPE.toString());
        info.setValue(software.getChecksumType());
        infos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.CHECKSUM.toString());
        info.setValue(software.getChecksum());
        infos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.CONTENT_TYPE.toString());
        info.setValue(software.getSoftwareContentType());
        infos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.FILE_NAME.toString());
        info.setValue(software.getSoftwareFileName());
        infos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.DESCRIPTION.toString());
        info.setValue(software.getDescription());
        infos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.SOFTWARE_VERSION.toString());
        info.setValue(software.getVersionName());
        infos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.TYPE.toString());
        info.setValue("INFOMAN_SOFTWARE");
        infos.add(info);
        return infos;
    }
}

