/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.efm4_6.impl;

import de.proveo.domain.values.datasync.DatasyncMetainfoValue;
import de.proveo.domain.values.datasync.DatasyncResourceValue;
import de.proveo.domain.values.infoman.InfomanSetupValue;
import de.proveo.domain.values.infoman.MetaInfoKey;
import java.util.ArrayList;
import java.util.List;

public class InfomanSetupValueAdapter
extends DatasyncResourceValue {
    private final InfomanSetupValue setup;
    private List<DatasyncMetainfoValue> metainfos;

    public InfomanSetupValueAdapter(InfomanSetupValue setup) {
        this.setup = setup;
        this.metainfos = InfomanSetupValueAdapter.createMetaInfos(setup);
    }

    public String getChecksum() {
        return this.setup.getConfigurationChecksum();
    }

    public List<DatasyncMetainfoValue> getMetainfos() {
        return this.metainfos;
    }

    public byte[] getResource() {
        return this.setup.getConfiguration();
    }

    public String getResourceName() {
        return this.setup.getConfigurationName();
    }

    public boolean isHasMetaInfo() {
        return this.metainfos != null && !this.metainfos.isEmpty();
    }

    public void setChecksum(String checksum) {
        this.setup.setConfigurationChecksum(checksum);
    }

    public void setMetainfos(List<DatasyncMetainfoValue> metainfos) {
        this.metainfos = metainfos;
    }

    public void setResource(byte[] resource) {
        this.setup.setConfiguration(resource);
    }

    public void setResourceName(String resourceName) {
        this.setup.setConfigurationName(resourceName);
    }

    public String toString() {
        return this.setup.toString();
    }

    public InfomanSetupValue getInfomanSetupValueInstance() {
        return this.setup;
    }

    private static ArrayList<DatasyncMetainfoValue> createMetaInfos(InfomanSetupValue value) {
        ArrayList<DatasyncMetainfoValue> infos = new ArrayList<DatasyncMetainfoValue>();
        DatasyncMetainfoValue info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.CONTENT_TYPE.toString());
        info.setValue(value.getConfigurationContentType());
        infos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.CHECKSUM_TYPE.toString());
        info.setValue(value.getConfigurationChecksumType());
        infos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.HARDWARE.toString());
        info.setValue(value.getHardware());
        infos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.HARDWARE_SERIAL.toString());
        info.setValue(value.getHardwareSerial());
        infos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.INFOMAN_SERIAL.toString());
        info.setValue(value.getInfomanSerial());
        infos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.JAVA_VM_VERSION.toString());
        info.setValue(value.getJavaVMVersion());
        infos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.KERNEL_VERSION.toString());
        info.setValue(value.getKernelVersion());
        infos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.PM_VERSION.toString());
        info.setValue(value.getPMVersion());
        infos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.REQUEST_CONFIG_TIME.toString());
        info.setValue(String.valueOf(value.getRequestConfigTime()));
        infos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.ROOTFS_VERSION.toString());
        info.setValue(value.getRootfsVersion());
        infos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.SOFTWARE_REVISION.toString());
        info.setValue(value.getSoftwareRevision());
        infos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.SOFTWARE_VERSION.toString());
        info.setValue(value.getSoftwareVersion());
        infos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.MODEM_FIRMWARE_VERSION.toString());
        info.setValue(value.getModemFirmwareVersion());
        infos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.MODEM_TYPE.toString());
        info.setValue(value.getModemType());
        infos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.BOOTLOADER_VERISON.toString());
        info.setValue(value.getBootloaderVersion());
        infos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.GPS_FIRMWARE.toString());
        info.setValue(value.getGpsFirmware());
        infos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.IMEI.toString());
        info.setValue(value.getImei());
        infos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.IMSI.toString());
        info.setValue(value.getImsi());
        infos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.SIMCARD_NO.toString());
        info.setValue(value.getSimcardNo());
        infos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.VEHICLE_ID.toString());
        info.setValue(value.getVehicleId());
        infos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.WIFI_FIRMWARE.toString());
        info.setValue(value.getWifiFirmware());
        infos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.WIFI_MAC_ADDRESS.toString());
        info.setValue(value.getWifiMacAddress());
        infos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.SYNC_TIME.toString());
        info.setValue(String.valueOf(value.getSyncTime()));
        infos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.UP_TO_DATE.toString());
        info.setValue(String.valueOf(value.isConfigurationUpToDate()));
        infos.add(info);
        return infos;
    }
}

