/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.efm4_6.impl;

import de.proveo.domain.values.admin.ObjectNodeBean;
import de.proveo.domain.values.infoman.InfomanSetupValue;
import de.proveo.idm.core.gui.navigation.api.Capability;
import de.proveo.idm.core.gui.navigation.api.Credentials;
import de.proveo.idm.core.gui.navigation.api.Device;
import de.proveo.idm.core.util.VersionsCompareUtil;
import de.proveo.idm.remote.server.api.EFMServer;
import de.proveo.idm.remote.server.api.EFMServerUnitAdministration;
import de.proveo.idm.remote.server.api.IDMLoginResponse;
import de.proveo.idm.remote.server.api.RemoteDeviceId;
import de.proveo.idm.remote.server.api.RemoteOperatorAdapter;
import de.proveo.idm.remote.server.api.RemotePathAdapter;
import de.proveo.idm.remote.server.api.RemoteUpdateAdapter;
import de.proveo.idm.remote.server.api.UnitTreeElement;
import de.proveo.idm.remote.server.api.ZeroConfUnit;
import de.proveo.idm.remote.server.api.impl.AbstractEFMServer;
import de.proveo.idm.remote.server.api.impl.HttpClient4Factory;
import de.proveo.idm.remote.server.api.impl.HttpClientFactory;
import de.proveo.idm.remote.server.api.impl.RemoteDeviceIdImpl;
import de.proveo.idm.remote.server.api.impl.ZeroConfUnitImpl;
import de.proveo.idm.remote.server.efm4_6.impl.LoginResponseAdapter;
import de.proveo.idm.remote.server.efm4_6.impl.RemoteInfomanImpl;
import de.proveo.idm.remote.server.efm4_6.impl.RemoteOperatorAdapterImpl;
import de.proveo.idm.remote.server.efm4_6.impl.RemotePathAdapterImpl;
import de.proveo.idm.remote.server.efm4_6.impl.RemoteUpdateAdapterImpl;
import de.proveo.idm.remote.server.services.ShaSumGenerator;
import de.proveo.idm.ssh.service.SSHConnection;
import de.proveo.util.connection.LoginResponse;
import de.proveo.util.geo.GPSPosition;
import de.proveo.util.rest.interfaces.ApplicationWebServiceClient;
import de.proveo.util.rest.interfaces.DatasyncWebServiceClient;
import de.proveo.util.rest.interfaces.PathWebServiceClient;
import de.proveo.util.rest.interfaces.UnitWebServiceClient;
import de.proveo.util.rest.interfaces.UseUserWebServiceClient;
import de.proveo.util.unit.tree.UnitTreeNodeBean;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleXMLRPCCall;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleXMLRPCCallFactory;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleXMLRPCClient;
import java.net.ConnectException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.ClientResponseFailure;
import org.jboss.resteasy.client.ProxyFactory;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;

public class EFMServer4_6
extends AbstractEFMServer {
    private static final Logger log = Logger.getLogger(EFMServer4_6.class.getName());
    private static final String ADMIN_INTERFACE = "/admin";
    private static final String DATASYNC_INTERFACE = "/datasync";
    private URL connectionURL;
    private UnitWebServiceClient unitWebService;
    private PathWebServiceClient pathWebService;
    private UseUserWebServiceClient useUserWebService;
    private ApplicationWebServiceClient appWebService;
    private DatasyncWebServiceClient datasyncWebService;
    private RemoteUpdateAdapterImpl updateAdapter;
    private RemoteOperatorAdapterImpl operatorAdapter;
    private RemotePathAdapterImpl pathAdapter;
    private UnitAdminWrapper unitAdminWrapper;

    public EFMServer4_6() {
        this.capabilities.add(Capability.UNIT_OVERVIEW);
        this.capabilities.add(Capability.TASK_OVERVIEW);
        this.capabilities.add(Capability.RESOURCE_OVERVIEW);
        this.capabilities.add(Capability.SOFTWARE_OVERVIEW);
        this.capabilities.add(Capability.ZERO_CONF);
        this.capabilities.add(Capability.EDIT_CONFIGURATION);
        this.capabilities.add(Capability.UPDATE_SOFTWARE_FOR_DEVICE);
        this.capabilities.add(Capability.MANAGE_INFOMAN_CALLBACK);
        this.capabilities.add(Capability.INFOMAN_STATUS_PAGE);
        this.capabilities.add(Capability.MAPPING);
    }

    public SortedMap<String, String> getEnv() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public UnitTreeElement getUnits() throws Exception {
        EFMServer4_6.checkLogin(this.getUnitWebServiceClient());
        UnitTreeNodeBean tree = this.getUnitWebServiceClient().getInstalledUnits();
        if (tree != null) {
            return this.createUnitTree(tree);
        }
        return null;
    }

    public String getTimeZoneID() {
        return this.appWebService.getTimeZoneID();
    }

    public List<ZeroConfUnit> getNotInstalledUnits() throws Exception {
        EFMServer4_6.checkLogin(this.getUnitWebServiceClient());
        ArrayList<ZeroConfUnit> zeroconfUnits = new ArrayList<ZeroConfUnit>();
        List list = this.getUnitWebServiceClient().getNotInstalledDevices();
        for (ObjectNodeBean node : list) {
            TreeMap attributes = new TreeMap(node.getAttributes());
            RemoteDeviceIdImpl id = new RemoteDeviceIdImpl((String)attributes.get("hardwareSerialNumber"));
            ZeroConfUnitImpl unit = new ZeroConfUnitImpl((EFMServer)this, (RemoteDeviceId)id, attributes);
            zeroconfUnits.add((ZeroConfUnit)unit);
        }
        return zeroconfUnits;
    }

    public GPSPosition getZeroConfPositionById(int id) throws Exception {
        EFMServer4_6.checkLogin(this.getUnitWebServiceClient());
        if (this.capabilities != null && this.capabilities.contains(Capability.NOT_INSTALLED_POSITIONS)) {
            ObjectNodeBean node = this.getUnitWebServiceClient().getNotInstalledUnitById(id);
            TreeMap attributes = new TreeMap(node.getAttributes());
            String gga = (String)attributes.get("ggaRec");
            String rmc = (String)attributes.get("rmcRec");
            if (gga != null && gga.startsWith("$GPGGA")) {
                return new GPSPosition(rmc, gga);
            }
        }
        return null;
    }

    public synchronized RemoteUpdateAdapter getRemoteUpdateAdapter() {
        if (this.updateAdapter == null) {
            this.updateAdapter = new RemoteUpdateAdapterImpl(this, this.loginCredentials);
        }
        return this.updateAdapter;
    }

    public RemoteOperatorAdapter getRemoteOperatorAdapter() {
        if (this.operatorAdapter == null) {
            this.operatorAdapter = new RemoteOperatorAdapterImpl(this);
        }
        return this.operatorAdapter;
    }

    public synchronized RemotePathAdapter getRemotePathAdapter() {
        if (this.pathAdapter == null) {
            this.pathAdapter = new RemotePathAdapterImpl(this);
        }
        return this.pathAdapter;
    }

    protected UnitWebServiceClient getUnitWebServiceClient() {
        return this.unitWebService;
    }

    protected UseUserWebServiceClient getUseUserWebService() {
        return this.useUserWebService;
    }

    protected DatasyncWebServiceClient getDatasyncWebServiceClient() {
        return this.datasyncWebService;
    }

    protected PathWebServiceClient getPathWebServiceClient() {
        return this.pathWebService;
    }

    public synchronized IDMLoginResponse login(Credentials credentials) throws Exception {
        this.loginCredentials = credentials;
        if (this.loginCredentials == null) {
            return null;
        }
        if (this.tunnel != null && !this.tunnel.isEmpty()) {
            this.connection = new SSHConnection();
            this.connection.addTunnel(this.tunnel);
            this.connection.establishTunnel(this.serverURL.toString());
            this.connectionPort = this.connection.getConnectionPort();
            this.connectionURL = new URL(this.serverURL.getProtocol(), "localhost", this.connectionPort, this.serverURL.getFile());
        } else {
            this.connectionURL = this.serverURL;
        }
        org.apache.http.client.HttpClient client = HttpClient4Factory.createHttpsClient((URL)this.connectionURL, (Credentials)this.loginCredentials);
        ApacheHttpClient4Executor executor = new ApacheHttpClient4Executor(client);
        this.unitWebService = (UnitWebServiceClient)ProxyFactory.create(UnitWebServiceClient.class, (String)(this.connectionURL.toString() + ADMIN_INTERFACE), (ClientExecutor)executor);
        this.appWebService = (ApplicationWebServiceClient)ProxyFactory.create(ApplicationWebServiceClient.class, (String)(this.connectionURL.toString() + ADMIN_INTERFACE), (ClientExecutor)executor);
        this.datasyncWebService = (DatasyncWebServiceClient)ProxyFactory.create(DatasyncWebServiceClient.class, (String)(this.connectionURL.toString() + DATASYNC_INTERFACE), (ClientExecutor)executor);
        this.useUserWebService = (UseUserWebServiceClient)ProxyFactory.create(UseUserWebServiceClient.class, (String)(this.connectionURL.toString() + ADMIN_INTERFACE), (ClientExecutor)executor);
        this.pathWebService = (PathWebServiceClient)ProxyFactory.create(PathWebServiceClient.class, (String)(this.connectionURL.toString() + ADMIN_INTERFACE), (ClientExecutor)executor);
        if (this.unitWebService != null && this.datasyncWebService != null && this.appWebService != null) {
            boolean accessPermitted = true;
            try {
                this.unitWebService.getAvailableSoftware();
            }
            catch (ClientResponseFailure ex) {
                ClientResponse response = ex.getResponse();
                int status = response.getStatus();
                if (status != 200) {
                    accessPermitted = false;
                }
            }
            catch (Throwable ex) {
                log.log(Level.INFO, "Login runs into", ex);
                accessPermitted = false;
            }
            this.loginResponse = new IDMLoginResponse();
            this.loginResponse.setAccessPermitted(accessPermitted);
            if (accessPermitted) {
                char[] passwordHash = ShaSumGenerator.plainStringToSHA1((String)new String(this.loginCredentials.getPassword())).toCharArray();
                HashMap<String, Object> callValues = new HashMap<String, Object>();
                callValues.put("username", this.loginCredentials.getUsername());
                callValues.put("password", passwordHash);
                LoginResponse response = (LoginResponse)this.executeCall("Login", callValues);
                if (log.isLoggable(Level.FINE)) {
                    ToStringBuilder dump = new ToStringBuilder((Object)response);
                    dump.append("accessPermitted", response.isAccessPermitted());
                    dump.append("firstName", (Object)response.getFirstName());
                    dump.append("lastName", (Object)response.getLastName());
                    dump.append("username", (Object)response.getUsername());
                    dump.append("portalPermissions", (Object)response.getPortalPermissions());
                    log.log(Level.FINE, "login() {0}", dump.toString());
                }
                if (this.loginResponse.isAccessPermitted() != response.isAccessPermitted()) {
                    log.log(Level.WARNING, "Login via REST and XML-RPC differ: REST={0} XML-RPC={1}", new Object[]{this.loginResponse.isAccessPermitted(), response.isAccessPermitted()});
                }
                this.loginResponse = new LoginResponseAdapter(response);
                this.loginResponse.setAccessPermitted(accessPermitted);
                boolean supportsAdditionalFeatures = false;
                if (this.useUserWebService != null) {
                    try {
                        this.useUserWebService.getLicenseTypes();
                        supportsAdditionalFeatures = true;
                    }
                    catch (Exception ex) {
                        supportsAdditionalFeatures = false;
                    }
                }
                if (supportsAdditionalFeatures) {
                    this.capabilities.add(Capability.OPERATOR_OVERVIEW);
                    this.capabilities.add(Capability.CANCEL_TASK);
                    this.capabilities.add(Capability.EDIT_TASK);
                    this.capabilities.add(Capability.CREATE_BATCH_TASK);
                    this.capabilities.add(Capability.UPLOAD_RESOURCE);
                }
                if (this.pathWebService != null) {
                    try {
                        this.pathWebService.getGraphs();
                        this.capabilities.add(Capability.WAY_PATH);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (VersionsCompareUtil.isVersionGreater((String)this.appWebService.getVersion(), (String)"4.8.1")) {
                    this.capabilities.add(Capability.NOT_INSTALLED_POSITIONS);
                }
                if (VersionsCompareUtil.isVersionGreater((String)this.appWebService.getVersion(), (String)"4.8.0-dev")) {
                    this.capabilities.add(Capability.INFOMANEFM_CONFIG_UPDATE);
                }
            }
        }
        this.unitAdminWrapper = new UnitAdminWrapper(this.unitWebService);
        return this.loginResponse;
    }

    @Deprecated
    protected Object executeCall(String method, Map<String, Object> callValues) throws Exception {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        SSHConnection tmpConnection = null;
        Object value = null;
        try {
            URL tmpConnectionURL;
            ClassLoader thisLoader = ((Object)((Object)this)).getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(thisLoader);
            if (this.tunnel != null && !this.tunnel.isEmpty()) {
                tmpConnection = new SSHConnection();
                tmpConnection.addTunnel(this.tunnel);
                tmpConnection.establishTunnel(this.serverURL.toString());
                int tmpConnectionPort = tmpConnection.getConnectionPort();
                tmpConnectionURL = new URL(this.serverURL.getProtocol(), "localhost", tmpConnectionPort, this.serverURL.getFile());
            } else {
                tmpConnectionURL = this.serverURL;
            }
            String uriPath = "datain/simpleXML-RPC";
            String uriString = (tmpConnectionURL.toString().endsWith("/") ? tmpConnectionURL.toString() : tmpConnectionURL.toString() + "/") + uriPath;
            SimpleXMLRPCClient client = new SimpleXMLRPCClient(uriString);
            HttpClient httpClient = client.getHttpClient();
            HttpClientFactory.configureHttpClient((HttpClient)httpClient, (String)tmpConnectionURL.getProtocol(), (String)tmpConnectionURL.getHost(), (int)tmpConnectionURL.getPort(), (int)this.serverURL.getPort(), (String)uriPath, (int)60000, (int)60000);
            client.setRequestCompression(false);
            client.setAcceptCompression(false);
            SimpleXMLRPCCall call = SimpleXMLRPCCallFactory.createCall();
            call.setMethod(method);
            for (String key : callValues.keySet()) {
                call.addParameter(key, callValues.get(key));
            }
            value = client.execute(call);
        }
        catch (ConnectTimeoutException ex) {
            ConnectException e = new ConnectException(ex.getMessage());
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
        finally {
            if (tmpConnection != null) {
                tmpConnection.disconnect();
            }
            if (original != null) {
                Thread.currentThread().setContextClassLoader(original);
            }
        }
        return value;
    }

    public synchronized void logoff() {
        super.logoff();
        this.updateAdapter = null;
        this.datasyncWebService = null;
        this.unitWebService = null;
        this.useUserWebService = null;
        this.appWebService = null;
    }

    private UnitTreeElement createUnitTree(UnitTreeNodeBean unitNode) {
        UnitTreeElement parent;
        if (!unitNode.isBasic()) {
            String unitName = unitNode.getUnitName();
            parent = new UnitTreeElement((Object)unitName);
            List children = unitNode.getChildren();
            if (children != null) {
                ArrayList<UnitTreeElement> group = new ArrayList<UnitTreeElement>();
                for (UnitTreeNodeBean childUnitNode : children) {
                    UnitTreeElement childTreeNode = this.createUnitTree(childUnitNode);
                    group.add(childTreeNode);
                }
                parent.setChildren(group);
            }
        } else {
            String serialNo = unitNode.getSerial();
            serialNo = serialNo == null ? "" : serialNo.trim();
            String devType = unitNode.getDeviceType();
            Device.DeviceType deviceType = Device.DeviceType.nameOf((String)(devType = devType == null ? "" : devType.trim()));
            if (deviceType == null) {
                deviceType = Device.DeviceType.INFOMAN;
            }
            RemoteInfomanImpl infoman = new RemoteInfomanImpl(this, unitNode.getUnitId(), unitNode.getUnitName(), serialNo, deviceType);
            String icon = UnitTreeElement.lookupIconBase(EFMServer4_6.class, (String)unitNode.getImageName(), (Device.DeviceType)deviceType);
            parent = new UnitTreeElement((Object)infoman, icon);
            this.units.add(infoman);
        }
        return parent;
    }

    private static void checkLogin(UnitWebServiceClient client) throws IllegalStateException {
        if (client == null) {
            throw new IllegalStateException("Client is null! Perform a login first");
        }
    }

    public String getURL() {
        URL url;
        URL uRL = url = this.connectionURL == null ? this.serverURL : this.connectionURL;
        if (url != null) {
            return url.toString();
        }
        return "";
    }

    public EFMServerUnitAdministration getUnitAdministration() {
        return this.unitAdminWrapper;
    }

    public String getUnitPosition(long unitId) throws Exception {
        return this.getUnitWebServiceClient().getUnitPosition(unitId);
    }

    public boolean isUnitVisibleOnMap(long unitId) throws Exception {
        return Boolean.parseBoolean(this.getUnitWebServiceClient().isUnitVisibleOnMap(unitId));
    }

    public InfomanSetupValue getConfiguration(long unitId) throws Exception {
        return this.getUnitWebServiceClient().getConfiguration(unitId);
    }

    public String getIpAddress(long unitId) {
        return this.getUnitWebServiceClient().getUnitIpAddress(unitId);
    }

    public void forceAclUpdate(long unitId) throws Exception {
        this.getUnitWebServiceClient().forceACLUpdate(unitId);
    }

    class UnitAdminWrapper
    implements EFMServerUnitAdministration {
        private final UnitWebServiceClient unitWebServiceClient;

        public UnitAdminWrapper(UnitWebServiceClient unitWebServiceClient) {
            this.unitWebServiceClient = unitWebServiceClient;
        }

        public void setIMEI(long unitId, String imei) {
            this.unitWebServiceClient.setIMEI(unitId, imei);
        }

        public void setSerialNumber(long unitId, String serialNumber) {
            this.unitWebServiceClient.setSerialNumber(unitId, serialNumber);
        }

        public void assignToUnit(Device.DeviceType unitType, String serialNumber, long unidId) {
            this.unitWebServiceClient.assignToUnit(unitType.toString(), serialNumber, unidId);
        }

        public void setCallbackFlag(long unitId) {
            this.unitWebServiceClient.setCallbackFlag(unitId);
        }
    }
}

