/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.tools.tftpserver.impl;

import de.proveo.tools.tftpserver.TFTPServerWrapper;
import de.proveo.tools.tftpserver.factory.TFTPServerFactory;
import de.proveo.tools.tftpserver.impl.ControlSocket;
import de.proveo.tools.tftpserver.impl.InProcessWrapper;
import de.proveo.tools.tftpserver.util.LoggerUtil;
import de.proveo.tools.tftpserver.util.PackageUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.telnet.TelnetClient;
import org.apache.log4j.LogManager;
import org.apache.log4j.net.SocketHubAppender;
import org.apache.log4j.net.SocketNode;

public class SudoWrapper
implements TFTPServerWrapper {
    private static final Log log = LogFactory.getLog(SudoWrapper.class);
    private static final int DEFAULT_REMOTE_LOGGING_PORT = 4560;
    private BufferedReader in;
    private PrintWriter out;
    private Process p = null;
    private Socket remoteLoggingSocket = null;
    private TelnetClient tClient;
    private Thread remoteLoggingThread = null;
    private boolean controlSocketConnected = false;
    private int controlSocketPort = 1069;

    public SudoWrapper(String tftpServerDir, int tftpServerPort, int controlSocketPort) throws IOException {
        this.controlSocketPort = controlSocketPort;
        try {
            String jarFileName = PackageUtils.getJarFileName();
            String javaCommandForMacOSX = "";
            Object[] commandArray = new String[]{"konsole", "-e", "sudo", "-i", "java"};
            if (jarFileName != null) {
                javaCommandForMacOSX = "-jar \"" + jarFileName + "\"";
                Object[] jarCommandArray = new String[]{"-jar", jarFileName, tftpServerDir, Integer.toString(tftpServerPort), Integer.toString(controlSocketPort)};
                commandArray = (String[])ArrayUtils.addAll(commandArray, jarCommandArray);
            } else {
                javaCommandForMacOSX = "-cp " + System.getProperty("java.class.path") + " de.proveo.tools.tftpserver.impl.SudoWrapper";
                Object[] cpCommandArray = new String[]{"-cp", System.getProperty("java.class.path"), "de.proveo.tools.tftpserver.impl.SudoWrapper", tftpServerDir, Integer.toString(tftpServerPort), Integer.toString(controlSocketPort)};
                commandArray = (String[])ArrayUtils.addAll(commandArray, cpCommandArray);
            }
            javaCommandForMacOSX = javaCommandForMacOSX + " \"" + tftpServerDir + "\" " + Integer.toString(tftpServerPort) + " " + Integer.toString(controlSocketPort);
            boolean isMacOSX = System.getProperty("os.name").startsWith("Mac");
            if (isMacOSX) {
                File tftpScript;
                File tmpPath = this.getTempFilePath();
                tmpPath.mkdirs();
                File appleScript = new File(tmpPath.getAbsolutePath() + File.separator + "start_tftp_as_root.sh");
                if (appleScript.exists()) {
                    FileUtils.forceDelete(appleScript);
                }
                if (appleScript.createNewFile()) {
                    appleScript.setReadable(true);
                    appleScript.setWritable(true);
                    appleScript.setExecutable(true);
                }
                if ((tftpScript = new File(tmpPath.getAbsolutePath() + File.separator + "start_tftp.sh")).exists()) {
                    FileUtils.forceDelete(tftpScript);
                }
                if (tftpScript.createNewFile()) {
                    tftpScript.setReadable(true);
                    tftpScript.setWritable(true);
                    tftpScript.setExecutable(true);
                }
                FileUtils.writeStringToFile(appleScript, "#!/bin/sh\nosascript -e \"do shell script \\\"$*\\\" with administrator privileges\"");
                FileUtils.writeStringToFile(tftpScript, "#!/bin/sh\njava " + javaCommandForMacOSX);
                String execute = appleScript.getAbsolutePath() + " " + tftpScript.getAbsolutePath();
                if (log.isDebugEnabled()) {
                    log.debug("execute: " + execute);
                }
                this.p = Runtime.getRuntime().exec(execute);
            } else {
                if (log.isDebugEnabled()) {
                    StringBuilder str = new StringBuilder("execute: ");
                    for (Object s : commandArray) {
                        str.append((String)s);
                        str.append(' ');
                    }
                    log.debug(str);
                }
                this.p = Runtime.getRuntime().exec((String[])commandArray);
            }
            this.startRemoteLogging();
            this.connectControlSocketClient();
        }
        catch (Throwable ex) {
            throw new IOException("Could not start TFTP server for UNIX", ex);
        }
    }

    public boolean isControlSocketConnected() {
        return this.controlSocketConnected;
    }

    public static void main(String[] args) throws Exception {
        LoggerUtil.INSTANCE.installSystemAdapters();
        log.info("TFTP Server");
        log.debug("start remote logging");
        SocketHubAppender sha = new SocketHubAppender(4560);
        LogManager.getRootLogger().addAppender(sha);
        log.debug("remote logging started");
        log.debug("Starting TFTP server for UNIX ...");
        String tftpServerDir = System.getProperty("user.home");
        int tftpServerPort = 69;
        int controlSocketPort = 1069;
        if (args.length != 0) {
            if (args.length == 1) {
                tftpServerDir = args[0];
            } else if (args.length == 2) {
                tftpServerDir = args[0];
                tftpServerPort = Integer.parseInt(args[1]);
            } else if (args.length == 3) {
                tftpServerDir = args[0];
                tftpServerPort = Integer.parseInt(args[1]);
                controlSocketPort = Integer.parseInt(args[2]);
            } else {
                log.error("Usage: java -jar TFTPServer.jar tftpServerDirectory [tftpServerPort] [controlSocketPort]");
                System.exit(-1);
            }
        }
        InProcessWrapper tftp = new InProcessWrapper(tftpServerDir, tftpServerPort);
        log.debug("starting control socket");
        ControlSocket cs = new ControlSocket(controlSocketPort, tftp);
        cs.start();
        log.debug("starting tftp service");
        tftp.start();
        log.info("TFTP Server - started");
        cs.blockUntilShutdown();
        log.debug("shutdown");
        tftp.stop();
        log.debug("shutdown - done");
    }

    @Override
    public void addCallback(Object obj) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public TFTPServerFactory.ServerState getState() {
        TFTPServerFactory.ServerState ret = null;
        try {
            ret = TFTPServerFactory.ServerState.valueOf(this.handleCommand("getstate"));
        }
        catch (Throwable ex) {
            log.error("Could not get state over control socket", ex);
        }
        return ret;
    }

    @Override
    public void shutdown() {
        String ret = this.handleCommand("shutdown");
        if (ret != null) {
            log.debug(ret);
        }
        this.stopRemoteLogging();
        if (this.p != null) {
            this.p.destroy();
        }
    }

    @Override
    public void start() {
        String ret;
        if (!this.isControlSocketConnected()) {
            this.connectControlSocketClient();
        }
        if ((ret = this.handleCommand("start")) != null) {
            log.debug(ret);
        }
    }

    @Override
    public void stop() {
        String ret = this.handleCommand("stop");
        if (ret != null) {
            log.debug(ret);
        }
        this.handleCommand("exit");
        this.disconnectControlSocket();
    }

    private void connectControlSocketClient() {
        this.controlSocketConnected = false;
        long start = System.currentTimeMillis();
        while (!this.controlSocketConnected) {
            try {
                this.startControlSocketClient();
                this.controlSocketConnected = true;
                log.debug("Telnet client connected to TFTP control socket");
            }
            catch (ConnectException ex) {
                if (System.currentTimeMillis() - start > 60000L) break;
                log.debug("could not connect control socket, try again in 5s ...");
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.controlSocketConnected = false;
            }
            catch (SocketException ex) {
                log.error("runs into", ex);
            }
            catch (IOException ex) {
                log.error("runs into", ex);
            }
        }
    }

    private void disconnectControlSocket() {
        try {
            this.controlSocketConnected = false;
            this.tClient.disconnect();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        IOUtils.closeQuietly(this.in);
        IOUtils.closeQuietly(this.out);
    }

    private String handleCommand(String command) {
        String ret = null;
        try {
            this.out.write(command + System.getProperty("line.separator"));
            this.out.flush();
            try {
                ret = this.in.readLine();
            }
            catch (Throwable ex) {
                log.error("Could not get return value for command '" + command + "' from control socket", ex);
            }
        }
        catch (Throwable ex) {
            log.error("Could not send command '" + command + "' to control socket", ex);
        }
        return ret;
    }

    private void startControlSocketClient() throws SocketException, IOException {
        this.tClient = new TelnetClient();
        this.tClient.connect("localhost", this.controlSocketPort);
        this.out = new PrintWriter(this.tClient.getOutputStream(), false);
        this.in = new BufferedReader(new InputStreamReader(this.tClient.getInputStream()));
    }

    private void startRemoteLogging() throws UnknownHostException, IOException {
        boolean remoteLoggingConnected = false;
        long start = System.currentTimeMillis();
        while (!remoteLoggingConnected) {
            try {
                this.remoteLoggingSocket = new Socket("localhost", 4560);
                remoteLoggingConnected = true;
                if (!log.isDebugEnabled()) continue;
                log.debug("Log client connected to TFTP server on port 4560");
            }
            catch (ConnectException ex) {
                if (System.currentTimeMillis() - start > 60000L) break;
                log.error("could not connect remote logging, try again in 5s");
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                remoteLoggingConnected = false;
            }
        }
        if (remoteLoggingConnected) {
            this.remoteLoggingThread = new Thread((Runnable)new SocketNode(this.remoteLoggingSocket, LogManager.getLoggerRepository()), "RemoteLoggingThread");
            this.remoteLoggingThread.setDaemon(true);
            this.remoteLoggingThread.start();
        } else {
            log.error("Connect remote logging for TFTP server failed!");
        }
    }

    private void stopRemoteLogging() {
        log.debug("Closing remote debugging ...");
        if (this.remoteLoggingThread != null) {
            this.remoteLoggingThread.interrupt();
        }
        if (this.remoteLoggingSocket != null) {
            try {
                this.remoteLoggingSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        log.debug("Remote debugging closed");
    }

    protected File getTempFilePath() {
        File tmpFilePath = new File(System.getProperty("java.io.tmpdir") + File.separator + "IDM" + File.separator + "TFTP");
        if (log.isDebugEnabled()) {
            log.debug("Temporary file path is '" + tmpFilePath.getAbsolutePath() + "'");
        }
        return tmpFilePath;
    }
}

