/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.tools.tftpserver.impl;

import de.proveo.tools.tftpserver.TFTPServerWrapper;
import de.proveo.tools.tftpserver.factory.TFTPServerFactory;
import de.proveo.tools.tftpserver.impl.InProcessWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStreamReader;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServerTest {
    private static final Log log = LogFactory.getLog(ServerTest.class);
    private static TFTPServerWrapper tftp = null;

    public static void main(String[] args) throws Exception {
        tftp = TFTPServerFactory.create(System.getProperty("user.home"), 69, 1069);
        if (tftp instanceof InProcessWrapper) {
            tftp.start();
            log.info("TFTP Server running.  Press enter to stop.");
            new InputStreamReader(System.in).read();
            ServerTest.exit();
        } else {
            TFTPServerFactory.ServerState state = tftp.getState();
            if (state != null && (state.equals((Object)TFTPServerFactory.ServerState.STARTING) || state.equals((Object)TFTPServerFactory.ServerState.STARTED))) {
                log.info("TFTP Server running.");
                final JFrame frame = new JFrame("TFTP server test");
                frame.setDefaultCloseOperation(0);
                frame.setLocation(200, 200);
                frame.setSize(300, 200);
                frame.setLayout(new BorderLayout());
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        ServerTest.exit();
                    }

                    @Override
                    public void windowClosed(WindowEvent e) {
                        ServerTest.exit();
                    }
                });
                JButton btnState = new JButton("GET STATE");
                btnState.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JOptionPane.showMessageDialog(frame, "State = '" + (Object)((Object)tftp.getState()) + "'");
                    }
                });
                JButton btnExit = new JButton("Exit");
                btnExit.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ServerTest.exit();
                    }
                });
                frame.add((Component)btnState, "Center");
                frame.add((Component)btnExit, "South");
                frame.setVisible(true);
            } else {
                log.error("Could not start TFTP server!");
            }
        }
    }

    private static void exit() {
        tftp.shutdown();
        log.info("Server shut down.");
        System.exit(0);
    }
}

