/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.tools.tftpserver.impl;

import de.proveo.tools.tftpserver.TFTPServerWrapper;
import de.proveo.tools.tftpserver.factory.TFTPServerFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ControlSocket
extends Thread {
    private static final Log log = LogFactory.getLog(ControlSocket.class);
    public static final int CONTROL_SOCKET_DEFAULT_PORT = 1069;
    private final Object shutdownLock = new Object();
    private List<ControlSocketProxy> proxies = new ArrayList<ControlSocketProxy>();
    private ServerSocket serverSocket = null;
    private TFTPServerWrapper serverWrapper = null;
    private boolean shutdown = false;
    private int port = -1;

    public ControlSocket(int port, TFTPServerWrapper serverWrapper) throws IOException {
        super("ControlSocket");
        this.port = port <= 0 ? 1069 : port;
        this.serverWrapper = serverWrapper;
        this.serverSocket = new ServerSocket(this.port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockUntilShutdown() {
        Object object = this.shutdownLock;
        synchronized (object) {
            try {
                this.shutdownLock.wait();
            }
            catch (InterruptedException ex) {
                log.error("stop interrupted?!", ex);
            }
        }
    }

    public int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.shutdown) {
            ControlSocketProxy csp = new ControlSocketProxy();
            this.proxies.add(csp);
            csp.offerConnection();
        }
        Object object = this.shutdownLock;
        synchronized (object) {
            this.shutdownLock.notify();
        }
    }

    public void shutdown() {
        this.shutdown = true;
        for (int i = 0; i < this.proxies.size(); ++i) {
            this.proxies.get(i).close();
        }
        try {
            this.serverSocket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected boolean isExitCommand(String input) {
        return input.equalsIgnoreCase("exit") || input.equalsIgnoreCase("quit");
    }

    protected boolean isShutdownCommand(String input) {
        return input.equalsIgnoreCase("shutdown");
    }

    private String handleRequest(String[] params) {
        String ret = "UNKNOWN COMMAND";
        if (params != null && params.length == 1) {
            if (params[0].equals("start")) {
                if (!this.serverWrapper.getState().equals((Object)TFTPServerFactory.ServerState.STARTED) && !this.serverWrapper.getState().equals((Object)TFTPServerFactory.ServerState.STARTING)) {
                    this.serverWrapper.start();
                    ret = this.serverWrapper.getState().name();
                } else {
                    ret = "-> ALREADY " + this.serverWrapper.getState().name();
                }
            } else if (params[0].equals("stop")) {
                if (!this.serverWrapper.getState().equals((Object)TFTPServerFactory.ServerState.STOPPED) && !this.serverWrapper.getState().equals((Object)TFTPServerFactory.ServerState.SHUTING_DOWN)) {
                    this.serverWrapper.stop();
                    ret = this.serverWrapper.getState().name();
                } else {
                    ret = "-> ALREADY " + this.serverWrapper.getState().name();
                }
            } else if (params[0].equals("restart")) {
                if (!this.serverWrapper.getState().equals((Object)TFTPServerFactory.ServerState.STOPPED) && !this.serverWrapper.getState().equals((Object)TFTPServerFactory.ServerState.SHUTING_DOWN)) {
                    this.serverWrapper.stop();
                }
                this.serverWrapper.start();
                ret = this.serverWrapper.getState().equals((Object)TFTPServerFactory.ServerState.STARTING) ? "-> RESTARTING" : (this.serverWrapper.getState().equals((Object)TFTPServerFactory.ServerState.STARTED) ? "-> RESTARTED" : "-> RESTART FAILED: " + this.serverWrapper.getState().name());
            } else if (params[0].equals("state")) {
                ret = "-> " + this.serverWrapper.getState().name();
            } else if (params[0].equals("getstate")) {
                ret = this.serverWrapper.getState().name();
            }
        }
        return ret;
    }

    private class ControlSocketProxy
    extends Thread {
        private BufferedReader in;
        private PrintWriter out;
        private Socket socket = null;
        private boolean stop = false;

        public ControlSocketProxy() {
            this.setName("ControlSocketProxy[" + this.getName() + "]");
        }

        public void offerConnection() {
            block2: {
                try {
                    log.debug("Control socket on port " + ControlSocket.this.port + " opened. Waiting for connection ...");
                    this.socket = ControlSocket.this.serverSocket.accept();
                    this.out = new PrintWriter(this.socket.getOutputStream(), false);
                    this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                    this.start();
                    log.debug("Client connected on port " + ControlSocket.this.port);
                }
                catch (IOException ex) {
                    if (ControlSocket.this.shutdown) break block2;
                    log.error("Could not establish connection", ex);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.stop && !ControlSocket.this.shutdown) {
                    String inputLine = this.in.readLine();
                    if (log.isDebugEnabled()) {
                        log.debug("command input: '" + inputLine + "'");
                    }
                    if (inputLine == null || ControlSocket.this.isExitCommand(inputLine)) {
                        this.stop = true;
                        continue;
                    }
                    if (ControlSocket.this.isShutdownCommand(inputLine)) {
                        this.stop = true;
                        ControlSocket.this.shutdown();
                        continue;
                    }
                    String[] parameters = StringUtils.split(inputLine.trim());
                    if (parameters.length <= 0 || parameters[0].equals("")) continue;
                    try {
                        this.out.write(ControlSocket.this.handleRequest(parameters) + System.getProperty("line.separator"));
                        this.out.flush();
                    }
                    catch (Exception ex) {
                        this.out.write("-> ERROR: " + ex.getMessage() + System.getProperty("line.separator"));
                        this.out.flush();
                        log.error("handle command runs into", ex);
                    }
                }
                if (!this.stop) return;
                if (ControlSocket.this.shutdown) return;
                this.close();
                return;
            }
            catch (SocketException ex) {
                if (ControlSocket.this.shutdown) return;
                log.error("runs into", ex);
                return;
            }
            catch (IOException ex) {
                log.error("runs into", ex);
            }
        }

        protected void close() {
            try {
                this.socket.close();
            }
            catch (Throwable ex) {
                // empty catch block
            }
            try {
                this.in.close();
            }
            catch (Throwable ex) {
                // empty catch block
            }
            try {
                this.out.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.debug("Control socket proxy closed.");
        }
    }
}

