/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.core.util;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ThreadPool {
    private static final Logger log = Logger.getLogger(ThreadPool.class.getName());
    private static final Object lock = new Object();
    private static ThreadPool instance = null;
    private final ThreadPoolExecutor executor = new ThreadPoolExecutor(20, 100, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());

    private ThreadPool() {
        int threadsStarted = this.executor.prestartAllCoreThreads();
        log.log(Level.INFO, "Started {0} thread(s) for ThreadPool.", threadsStarted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadPool getInstance() {
        Object object = lock;
        synchronized (object) {
            if (instance == null) {
                instance = new ThreadPool();
            }
        }
        return instance;
    }

    public void execute(Runnable run) {
        try {
            this.executor.execute(run);
        }
        catch (Exception ex) {
            log.log(Level.INFO, "executing Runnable runs into", ex);
        }
    }

    public void shutdown() {
        this.executor.shutdownNow();
        instance = null;
        log.info("ThreadPool was shut down.");
    }
}

