/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.core.options;

import de.proveo.idm.core.gui.navigation.api.AppearancePreferencesProvider;
import de.proveo.idm.core.gui.navigation.api.ExtendedValue;
import de.proveo.idm.core.options.AppearanceOptionsPanelController;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Locale;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.apache.commons.lang3.ObjectUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

final class AppearancePanel
extends JPanel {
    private final DefaultComboBoxModel languageCmbBoxModel;
    private final AppearanceOptionsPanelController controller;
    private JComboBox languageCmbBox;
    private JLabel languageLbl;
    private JLabel languageRequiresRestartLbl;
    private JButton languageResetDefaultBtn;

    AppearancePanel(AppearanceOptionsPanelController controller) {
        this.controller = controller;
        String[] timeZoneIds = TimeZone.getAvailableIDs();
        TreeMap<String, ExtendedValue> timeZonesSet = new TreeMap<String, ExtendedValue>();
        for (String timeZoneId : timeZoneIds) {
            TimeZone timeZone = TimeZone.getTimeZone(timeZoneId);
            timeZonesSet.put(timeZone.getDisplayName(), new ExtendedValue(timeZoneId, timeZone.getDisplayName()));
        }
        ExtendedValue[] timeZoneValues = new ExtendedValue[timeZonesSet.size() + 1];
        timeZoneValues[0] = new ExtendedValue("", "");
        int index = 1;
        Collection timeZoneCol = timeZonesSet.values();
        for (ExtendedValue value : timeZoneCol) {
            timeZoneValues[index++] = value;
        }
        Locale[] locales = Locale.getAvailableLocales();
        TreeMap<String, ExtendedValue> localesSet = new TreeMap<String, ExtendedValue>();
        for (Locale locale : locales) {
            String displayName = locale.getDisplayName();
            if (displayName == null || displayName.trim().length() == 0) continue;
            String country = locale.getCountry();
            String language = locale.getLanguage();
            String id = null;
            if (country != null && country.trim().length() != 0) {
                id = country.trim();
            }
            if (language == null || language.trim().length() == 0) continue;
            id = id == null || id.length() == 0 ? language.trim() : id + "-" + language.trim();
            localesSet.put(displayName, new ExtendedValue(id, displayName));
        }
        ExtendedValue[] localesValues = new ExtendedValue[localesSet.size() + 1];
        localesValues[0] = new ExtendedValue("", NbBundle.getMessage(AppearancePanel.class, (String)"AppearancePanel.defaultLanguage.text"));
        index = 1;
        Collection localesCol = localesSet.values();
        for (ExtendedValue value : localesCol) {
            localesValues[index++] = value;
        }
        this.languageCmbBoxModel = new DefaultComboBoxModel<ExtendedValue>(localesValues);
        this.initComponents();
    }

    private void initComponents() {
        this.languageLbl = new JLabel();
        this.languageCmbBox = new JComboBox();
        this.languageResetDefaultBtn = new JButton();
        this.languageRequiresRestartLbl = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.languageLbl, (String)NbBundle.getMessage(AppearancePanel.class, (String)"AppearancePanel.languageLbl.text"));
        this.languageCmbBox.setModel(this.languageCmbBoxModel);
        this.languageCmbBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                AppearancePanel.this.languageCmbBoxItemStateChanged(evt);
            }
        });
        this.languageResetDefaultBtn.setIcon(new ImageIcon(this.getClass().getResource("/de/proveo/idm/core/options/resetDefault.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.languageResetDefaultBtn, (String)NbBundle.getMessage(AppearancePanel.class, (String)"AppearancePanel.languageResetDefaultBtn.text"));
        this.languageResetDefaultBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AppearancePanel.this.languageResetDefaultBtnActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.languageRequiresRestartLbl, (String)NbBundle.getMessage(AppearancePanel.class, (String)"AppearancePanel.languageRequiresRestartLbl.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(90, 90, 90).addComponent(this.languageLbl).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.languageRequiresRestartLbl).addComponent(this.languageCmbBox, -2, 270, -2)).addGap(47, 47, 47).addComponent(this.languageResetDefaultBtn).addContainerGap(74, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.languageLbl).addComponent(this.languageCmbBox, -2, -1, -2).addComponent(this.languageResetDefaultBtn)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.languageRequiresRestartLbl).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void languageCmbBoxItemStateChanged(ItemEvent evt) {
        if (1 == evt.getStateChange()) {
            this.controller.changed();
        }
    }

    private void languageResetDefaultBtnActionPerformed(ActionEvent evt) {
        this.setSelectedValue(this.languageCmbBox, "US-en");
        this.controller.changed();
    }

    void load() {
        Preferences prefs = NbPreferences.forModule(AppearancePreferencesProvider.class);
        this.setSelectedValue(this.languageCmbBox, prefs.get("AppearancePreferencesProvider.language", "US-en"));
    }

    void store() {
        Preferences prefs = NbPreferences.forModule(AppearancePreferencesProvider.class);
        String value = "";
        Object obj = this.languageCmbBox.getSelectedItem();
        if (obj != null && obj instanceof ExtendedValue) {
            ExtendedValue val = (ExtendedValue)obj;
            value = val.getValue().toString();
        }
        prefs.put("AppearancePreferencesProvider.language", value);
        prefs.put("AppearancePreferencesProvider.timezone", value);
    }

    boolean valid() {
        return true;
    }

    private void setSelectedValue(JComboBox cmbBox, Object value) {
        int index = ((DefaultComboBoxModel)cmbBox.getModel()).getIndexOf(value);
        if (index == -1) {
            for (int i = 0; i < cmbBox.getItemCount(); ++i) {
                ExtendedValue extValue;
                Object item = cmbBox.getItemAt(i);
                if (item == null || !(item instanceof ExtendedValue) || !ObjectUtils.equals((Object)value, (Object)(extValue = (ExtendedValue)item).getValue())) continue;
                cmbBox.setSelectedItem(item);
                return;
            }
        } else {
            cmbBox.setSelectedItem(value);
        }
    }
}

