/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.core.gui.util;

import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.openide.awt.HtmlBrowser;

public class ExternalURLDisplayer
extends HtmlBrowser.URLDisplayer {
    private static final Logger log = Logger.getLogger(ExternalURLDisplayer.class.getName());

    public void showURL(URL url) {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop desktop = Desktop.getDesktop();
                String protocol = url.getProtocol();
                if (protocol.equalsIgnoreCase("nbdocs") && desktop.isSupported(Desktop.Action.OPEN)) {
                    int end;
                    String ext = "";
                    String urlFilePart = url.getFile();
                    int start = StringUtils.lastIndexOf((CharSequence)urlFilePart, (CharSequence)"/");
                    if (start == -1) {
                        start = 0;
                    }
                    if ((end = StringUtils.lastIndexOf((CharSequence)urlFilePart, (CharSequence)".")) == -1) {
                        end = urlFilePart.length() - 1;
                    }
                    String filename = StringUtils.substring((String)urlFilePart, (int)start, (int)end);
                    if (end != urlFilePart.length() - 1) {
                        start = end;
                        end = urlFilePart.length();
                        ext = StringUtils.substring((String)urlFilePart, (int)start, (int)end);
                    }
                    File file = File.createTempFile(filename + "_", ext);
                    file.deleteOnExit();
                    FileUtils.copyURLToFile((URL)url, (File)file);
                    log.log(Level.INFO, "File path: {0}", file.getAbsolutePath());
                    desktop.open(file);
                    return;
                }
                if (protocol.equalsIgnoreCase("mailto") && desktop.isSupported(Desktop.Action.MAIL)) {
                    desktop.mail(url.toURI());
                    return;
                }
                if (desktop.isSupported(Desktop.Action.BROWSE)) {
                    desktop.browse(url.toURI());
                    return;
                }
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Showing URL '" + url.toString() + "' runs into", ex);
            }
        }
        log.log(Level.WARNING, "Failed to open URL ''{0}'', will try fallback implementation ...", url.toString());
        HtmlBrowser browser = new HtmlBrowser();
        browser.setURL(url);
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(2);
        frame.getContentPane().add((Component)browser);
        frame.pack();
        frame.setVisible(true);
    }
}

