/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.core.gui.navigation.api.impl;

import de.proveo.idm.core.gui.navigation.NavigationItemChildren;
import de.proveo.idm.core.gui.navigation.NavigationTopComponent;
import de.proveo.idm.core.gui.navigation.api.NavigationItem;
import de.proveo.idm.core.gui.util.MenuUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.lookup.Lookups;
import org.xml.sax.SAXException;

public class NavigationItemNode
extends AbstractNode
implements PropertyChangeListener {
    private List<? extends Action> registeredActions = null;
    private String actionPath = null;
    protected NavigationItem navigationItem;

    public NavigationItemNode(NavigationItem navigationItem) {
        super(NavigationItemNode.createChildren(navigationItem), Lookups.singleton((Object)navigationItem));
        this.navigationItem = navigationItem;
        this.setName(this.navigationItem.getName());
        if (this.navigationItem.getIconBaseWithExtension() != null) {
            this.setIconBaseWithExtension(this.navigationItem.getIconBaseWithExtension());
        } else if (this.getIconBaseWithExtension() != null) {
            this.setIconBaseWithExtension(this.getIconBaseWithExtension());
        }
        String aPath = this.navigationItem.getActionPath();
        if (aPath != null) {
            this.actionPath = aPath;
        }
        this.navigationItem.addPropertyChangeListener(this);
    }

    protected void setActionPath(String actionPath) {
        this.actionPath = actionPath;
    }

    public NavigationItem getNavigationItem() {
        return this.navigationItem;
    }

    public void setName(String s) {
        if (s == null) {
            s = "";
        }
        if (!s.equals(this.navigationItem.getName())) {
            this.navigationItem.setName(s);
        }
        super.setName(s);
        this.firePropertySetsChange(null, this.getPropertySets());
    }

    protected static Children createChildren(NavigationItem navigationItem) {
        if (navigationItem.getChildren().isEmpty()) {
            return Children.LEAF;
        }
        return new NavigationItemChildren(navigationItem);
    }

    @Override
    public void propertyChange(final PropertyChangeEvent evt) {
        if ("name".equals(evt.getPropertyName())) {
            this.setName(evt.getNewValue().toString());
        } else if ("children_add".equals(evt.getPropertyName()) || "children_remove".equals(evt.getPropertyName())) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        NavigationTopComponent nav = NavigationTopComponent.findInstance();
                        boolean expanded = nav.isNodeExpanded((Node)NavigationItemNode.this);
                        NavigationItemNode.this.setChildren(NavigationItemNode.createChildren((NavigationItem)evt.getSource()));
                        if (expanded) {
                            nav.expandNode((Node)NavigationItemNode.this);
                        }
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                run.run();
            } else {
                SwingUtilities.invokeLater(run);
            }
        }
    }

    protected String getIconBaseWithExtension() {
        return null;
    }

    public Action[] getActions(boolean context) {
        if (this.actionPath == null) {
            return super.getActions(context);
        }
        if (this.registeredActions == null) {
            try {
                this.registeredActions = MenuUtil.actionsForPaths(this.actionPath);
            }
            catch (SAXException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        ArrayList<? extends Action> actions = new ArrayList<Action>();
        actions.addAll(this.registeredActions);
        actions.addAll(Arrays.asList(super.getActions(context)));
        return actions.toArray(new Action[actions.size()]);
    }
}

