/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.core.gui.navigation.api.impl;

import de.proveo.idm.core.gui.navigation.api.NavigationItem;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractNavigationItem
implements NavigationItem {
    protected String name;
    protected String description;
    protected NavigationItem parent;
    protected final List<NavigationItem> childrens = new ArrayList<NavigationItem>();
    protected String actionPath;
    protected final PropertyChangeSupport pss;

    @Override
    public String getDescription() {
        return StringUtils.trimToEmpty((String)this.description);
    }

    @Override
    public void setDescription(String description) {
        String oldDesc = this.description;
        this.description = description;
        this.pss.firePropertyChange("description", oldDesc, description);
    }

    public AbstractNavigationItem(String name, NavigationItem parent) {
        this.name = name;
        this.pss = new PropertyChangeSupport(this);
        this.setParent(parent);
    }

    public AbstractNavigationItem(String name, String description, NavigationItem parent) {
        this(name, parent);
        this.description = description;
    }

    @Override
    public synchronized void setParent(NavigationItem parent) {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.parent = parent;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
    }

    @Override
    public synchronized void setParent(NavigationItem parent, int index) {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.parent = parent;
        if (this.parent != null) {
            this.parent.insertChild(this, index);
        }
    }

    public AbstractNavigationItem(String name) {
        this(name, null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<NavigationItem> getChildren() {
        return Collections.unmodifiableList(this.childrens);
    }

    @Override
    public synchronized void addChild(NavigationItem navigationItem) {
        if (!this.childrens.contains(navigationItem)) {
            this.childrens.add(navigationItem);
            this.pss.firePropertyChange("children_add", null, this.childrens);
        }
        if (!this.equals(navigationItem.getParent())) {
            navigationItem.setParent(this);
        }
    }

    @Override
    public synchronized void insertChild(NavigationItem navigationItem, int index) {
        if (!this.childrens.contains(navigationItem)) {
            if (index > -1 && index < this.childrens.size()) {
                this.childrens.add(index, navigationItem);
            } else {
                this.childrens.add(navigationItem);
            }
            this.pss.firePropertyChange("children_add", null, this.childrens);
        }
        if (!this.equals(navigationItem.getParent())) {
            navigationItem.setParent(this);
        }
    }

    @Override
    public synchronized void removeChild(NavigationItem navigationItem) {
        if (this.childrens.remove(navigationItem)) {
            navigationItem.setParent(null);
            this.pss.firePropertyChange("children_remove", null, this.childrens);
        }
    }

    @Override
    public NavigationItem getParent() {
        return this.parent;
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pss.addPropertyChangeListener(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pss.removePropertyChangeListener(listener);
    }

    @Override
    public String getIconBaseWithExtension() {
        return "de/proveo/idm/core/gui/navigation/api/impl/folder.png";
    }

    @Override
    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        if (this.name != null) {
            this.name = this.name.trim();
        }
        this.pss.firePropertyChange("name", oldName, this.name);
    }

    @Override
    public String getActionPath() {
        return this.actionPath;
    }

    @Override
    public void setActionPath(String actionPath) {
        this.actionPath = actionPath;
    }

    @Override
    public void merge(NavigationItem merge) {
        if (!this.equals(merge) && !this.childrens.contains(merge)) {
            merge.setParent(this);
        } else {
            ArrayList<NavigationItem> mergeChildren = new ArrayList<NavigationItem>(merge.getChildren());
            if (!mergeChildren.isEmpty()) {
                int index = this.childrens.indexOf(merge);
                AbstractNavigationItem container = index != -1 ? this.childrens.get(index) : this;
                ArrayList<NavigationItem> removeList = new ArrayList<NavigationItem>(container.getChildren());
                for (NavigationItem child : removeList) {
                    container.removeChild(child);
                }
                for (NavigationItem child : mergeChildren) {
                    container.merge(child);
                }
            }
        }
    }
}

