/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.core.gui.navigation.api;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class EFMServerData
implements Serializable,
Cloneable {
    public static final long serialVersionUID = 4L;
    public static final String PROP_NAME = "EFMServerData.name";
    public static final String PROP_URL = "EFMServerData.url";
    public static final String PROP_VERSION = "EFMServerData.version";
    public static final String PROP_TUNNEL = "EFMServerData.tunnel";
    public static final String PROP_INFOMAN_TUNNEL = "EFMServerData.tunnel.infoman";
    public static final String PROP_EXTRA_PROPERTIES = "EFMServerData.extraProperties";
    private Properties extraProperties;
    private String servername;
    private String url;
    private String version;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private Collection<String> tunnel;
    private Collection<String> infomanTunnel;

    public EFMServerData(String name, String url) {
        this.servername = name;
        this.url = url;
        this.extraProperties = new Properties();
    }

    public String getServername() {
        return this.servername;
    }

    public void setServername(String servername) {
        String old = this.servername;
        this.servername = servername;
        this.pcs.firePropertyChange(PROP_NAME, old, this.servername);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        String old = this.url;
        this.url = url;
        this.pcs.firePropertyChange(PROP_URL, old, this.url);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        String old = this.version;
        this.version = version;
        this.pcs.firePropertyChange(PROP_VERSION, old, this.version);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void setTunnel(Collection<String> tunnel) {
        this.tunnel = tunnel;
        this.pcs.firePropertyChange(PROP_TUNNEL, null, this.tunnel);
    }

    public Collection<String> getTunnel() {
        return this.tunnel;
    }

    public Collection<String> getInfomanTunnel() {
        return this.infomanTunnel;
    }

    public void setInfomanTunnel(Collection<String> infomanTunnel) {
        this.infomanTunnel = infomanTunnel;
        this.pcs.firePropertyChange(PROP_INFOMAN_TUNNEL, null, this.infomanTunnel);
    }

    public void setExtraProperty(String key, String value) {
        if (this.extraProperties == null) {
            this.extraProperties = new Properties();
        }
        this.extraProperties.setProperty(key, value);
        this.pcs.firePropertyChange(PROP_EXTRA_PROPERTIES, null, this.extraProperties);
    }

    public void removeExtraProperty(String key) {
        if (this.extraProperties == null) {
            this.extraProperties = new Properties();
        }
        this.extraProperties.remove(key);
        this.pcs.firePropertyChange(PROP_EXTRA_PROPERTIES, null, this.extraProperties);
    }

    public String getExtraProperty(String key) {
        return this.getExtraProperty(key, null);
    }

    public String getExtraProperty(String key, String defaultValue) {
        if (this.extraProperties == null) {
            this.extraProperties = new Properties();
        }
        return this.extraProperties.getProperty(key, defaultValue);
    }

    public Object clone() throws CloneNotSupportedException {
        ArrayList<String> cloneTunnel;
        EFMServerData clone = new EFMServerData(this.servername, this.url);
        if (this.tunnel != null) {
            cloneTunnel = new ArrayList<String>(this.tunnel);
            clone.setTunnel(cloneTunnel);
        }
        if (this.infomanTunnel != null) {
            cloneTunnel = new ArrayList<String>(this.infomanTunnel);
            clone.setInfomanTunnel(cloneTunnel);
        }
        clone.setVersion(this.version);
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof EFMServerData) {
            EFMServerData data = (EFMServerData)obj;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append((Object)this.servername, (Object)data.servername);
            eb.append((Object)this.url, (Object)data.url);
            eb.append((Object)this.version, (Object)data.version);
            eb.append(this.tunnel, data.tunnel);
            eb.append(this.infomanTunnel, data.infomanTunnel);
            eb.append((Object)this.extraProperties, (Object)data.extraProperties);
            return eb.isEquals();
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        hcb.append((Object)this.servername);
        hcb.append((Object)this.url);
        hcb.append((Object)this.version);
        hcb.append(this.tunnel);
        hcb.append(this.infomanTunnel);
        hcb.append((Object)this.extraProperties);
        return hcb.toHashCode();
    }
}

